/* }`^XN֌W */

#include "bootpack.h"

TaskManager *task_manager;
Timer *task_timer;

Task *Task::now(void)
{
	TaskLevel *tl = &task_manager->level[task_manager->now_lv];
	return tl->tasks[tl->now];
}

void Task::add(Task *task)
{
	TaskLevel *tl = &task_manager->level[task->level];
	tl->tasks[tl->running] = task;
	tl->running++;
	task->flags = 2; /* 쒆 */
	return;
}

void Task::remove(Task *task)
{
	int i;
	TaskLevel *tl = &task_manager->level[task->level];

	/* taskǂɂ邩T */
	for (i = 0; i < tl->running; i++) {
		if (tl->tasks[i] == task) {
			/* ɂ */
			break;
		}
	}

	tl->running--;
	if (i < tl->now) {
		tl->now--; /* ̂ŁA킹Ă */
	}
	if (tl->now >= tl->running) {
		/* nowȒlɂȂĂAC */
		tl->now = 0;
	}
	task->flags = 1; /* X[v */

	/* 炵 */
	for (; i < tl->running; i++) {
		tl->tasks[i] = tl->tasks[i + 1];
	}

	return;
}

void Task::switch_sub(void)
{
	int i;
	/* ԏ̃xT */
	for (i = 0; i < MAX_TASKLEVELS; i++) {
		if (task_manager->level[i].running > 0) {
			break; /*  */
		}
	}
	task_manager->now_lv = i;
	task_manager->lv_change = 0;
	return;
}

void task_idle(void)
{
	for (;;) {
		io_hlt();
	}
}

Task *Task::init(MemoryManager *memory_manager)
{
	int i;
	Task *task, *idle;
	SegmentDescriptor *gdt = (SegmentDescriptor *) ADR_GDT;

	task_manager = (TaskManager *) MemoryManager::allocate_4k(memory_manager, sizeof (TaskManager));
	for (i = 0; i < MAX_TASKS; i++) {
		task_manager->tasks0[i].flags = 0;
		task_manager->tasks0[i].sel = (TASK_GDT0 + i) * 8;
		task_manager->tasks0[i].tss.ldtr = (TASK_GDT0 + MAX_TASKS + i) * 8;
		SegmentDescriptor::set(gdt + TASK_GDT0 + i, 103, (int) &task_manager->tasks0[i].tss, AR_TSS32);
		SegmentDescriptor::set(gdt + TASK_GDT0 + MAX_TASKS + i, 15, (int) task_manager->tasks0[i].ldt, AR_LDT);
	}
	for (i = 0; i < MAX_TASKLEVELS; i++) {
		task_manager->level[i].running = 0;
		task_manager->level[i].now = 0;
	}

	task = Task::allocate();
	task->flags = 2;	/* 쒆}[N */
	task->priority = 2; /* 0.02b */
	task->level = 0;	/* ōx */
	Task::add(task);
	Task::switch_sub();	/* xݒ */
	load_tr(task->sel);
	task_timer = Timer::allocate();
	Timer::set_time(task_timer, task->priority);

	idle = Task::allocate();
	idle->tss.esp = MemoryManager::allocate_4k(memory_manager, 64 * 1024) + 64 * 1024;
	idle->tss.eip = (int) &task_idle;
	idle->tss.es = 1 * 8;
	idle->tss.cs = 2 * 8;
	idle->tss.ss = 1 * 8;
	idle->tss.ds = 1 * 8;
	idle->tss.fs = 1 * 8;
	idle->tss.gs = 1 * 8;
	Task::run(idle, MAX_TASKLEVELS - 1, 1);

	task_manager->task_fpu = 0;

	return task;
}

Task *Task::allocate(void)
{
	int i;
	Task *task;
	for (i = 0; i < MAX_TASKS; i++) {
		if (task_manager->tasks0[i].flags == 0) {
			task = &task_manager->tasks0[i];
			task->flags = 1; /* gp}[N */
			task->tss.eflags = 0x00000202; /* IF = 1; */
			task->tss.eax = 0; /* Ƃ肠0ɂĂƂɂ */
			task->tss.ecx = 0;
			task->tss.edx = 0;
			task->tss.ebx = 0;
			task->tss.ebp = 0;
			task->tss.esi = 0;
			task->tss.edi = 0;
			task->tss.es = 0;
			task->tss.ds = 0;
			task->tss.fs = 0;
			task->tss.gs = 0;
			task->tss.iomap = 0x40000000;
			task->tss.ss0 = 0;
			task->fpu[0] = 0x037f; /* CW(control word) */
			task->fpu[1] = 0x0000; /* SW(status word)  */
			task->fpu[2] = 0xffff; /* TW(tag word)     */
			for (i = 3; i < 108 / 4; i++) {
				task->fpu[i] = 0;
			}
			return task;
		}
	}
	return 0; /* Sgp */
}

void Task::run(Task *task, int level, int priority)
{
	if (level < 0) {
		level = task->level; /* xύXȂ */
	}
	if (priority > 0) {
		task->priority = priority;
	}

	if (task->flags == 2 && task->level != level) { /* 쒆̃x̕ύX */
		Task::remove(task); /* sflags1ɂȂ̂ŉifs */
	}
	if (task->flags != 2) {
		/* X[vNꍇ */
		task->level = level;
		Task::add(task);
	}

	task_manager->lv_change = 1; /* ^XNXCb`̂ƂɃx */
	return;
}

void Task::sleep(Task *task)
{
	Task *now_task;
	if (task->flags == 2) {
		/* 쒆 */
		now_task = Task::now();
		Task::remove(task); /* sflags1ɂȂ */
		if (task == now_task) {
			/* g̃X[v̂ŁA^XNXCb`Kv */
			Task::switch_sub();
			now_task = Task::now(); /* ݒł́Aũ݂^XNvĂ炤 */
			farjmp(0, now_task->sel);
		}
	}
	return;
}

void Task::switcher(void)
{
	TaskLevel *tl = &task_manager->level[task_manager->now_lv];
	Task *new_task, *now_task = tl->tasks[tl->now];
	tl->now++;
	if (tl->now == tl->running) {
		tl->now = 0;
	}
	if (task_manager->lv_change != 0) {
		Task::switch_sub();
		tl = &task_manager->level[task_manager->now_lv];
	}
	new_task = tl->tasks[tl->now];
	Timer::set_time(task_timer, new_task->priority);
	if (new_task != now_task) {
		farjmp(0, new_task->sel);
	}
	return;
}

int *inthandler07(int *esp)
{
	Task *now = Task::now();
	io_cli();
	clts();
	if (task_manager->task_fpu != now) {
		if (task_manager->task_fpu != 0) {
			fnsave(task_manager->task_fpu->fpu);
		}
		frstor(now->fpu);
		task_manager->task_fpu = now;
	}
	io_sti();
	return 0;
}
