/* }EX֌W */

#include "bootpack.h"
#include <stdio.h>

Queue *mousequeue;
int mousedata0;

void inthandler2c(int *esp)
/* PS/2}EX̊荞 */
{
	int data;
	io_out8(PIC1_OCW2, 0x64);	/* IRQ-12tPIC1ɒʒm */
	io_out8(PIC0_OCW2, 0x62);	/* IRQ-02tPIC0ɒʒm */
	data = io_in8(PORT_KEYDAT);
	Queue::push(mousequeue, data + mousedata0);
	return;
}

extern unsigned short table_8_565[256];

void MouseCursor::init(unsigned short *mouse, char bc)
/* }EXJ[\i11x17j */
{
	static char* cursor[17]/*[11]*/ = {
		"*..........",
		"**.........",
		"*O*........",
		"*OO*.......",
		"*OOO*......",
		"*OOOO*.....",
		"*OOOOO*....",
		"*OOOOOO*...",
		"*OOOOOOO*..",
		"*OOOOOOOO*.",
		"*OOOOO*****",
		"*OO*OO*....",
		"*O*.*OO*...",
		"**..*OO*...",
		"*....*OO*..",
		".....*OO*..",
		"......**..."
	};
	int x, y;

	for (y = 0; y < 17; y++) {
		for (x = 0; x < 11; x++) {
			if (cursor[y][x] == '*') {
				mouse[y * 11 + x] = table_8_565[COL8_000000];
			}
			if (cursor[y][x] == 'O') {
				mouse[y * 11 + x] = table_8_565[COL8_FFFFFF];
			}
			if (cursor[y][x] == '.') {
				mouse[y * 11 + x] = table_8_565[bc & 0xff];
			}
		}
	}
	return;
}

#define KEYCMD_SENDTO_MOUSE		0xd4
#define MOUSECMD_ENABLE			0xf4

void Mouse::init(Queue *queue, int data0, Mouse *mouse)
{
	int result, i;
	static unsigned char cmd[7] = {
		0xF3, /* TvO[gݒ */
		0xC8, /* 200 */
		0xF3, /* TvO[gݒ */
		0x64, /* 100 */
		0xF3, /* TvO[gݒ */
		0x50, /* 80 */
		0xF2  /* foCX^Cv擾 */
	};

	/* ݐFIFOobt@L */
	mousequeue = queue;
	mousedata0 = data0;

	/* zC[}EX */
	for (i = 0; i < 7; i++) {
		Keyboard::sendready();
		io_out8(PORT_KEYCMD, KEYCMD_SENDTO_MOUSE);
		Keyboard::sendready();
		io_out8(PORT_KEYDAT, cmd[i]);
	}

	/* foCX^Cv擾 */
	io_cli();
	for (i = 0; i < 8; i++) {
		result = io_in8(PORT_KEYDAT);
	}
	io_sti();

	/* zC[Lǂ`FbN */
	if (result == 0x03) {
		mouse->scrollmode = 1;
	} else {
		mouse->scrollmode = 0;
	}

	/* }EXL */
	Keyboard::sendready();
	io_out8(PORT_KEYCMD, KEYCMD_SENDTO_MOUSE);
	Keyboard::sendready();
	io_out8(PORT_KEYDAT, MOUSECMD_ENABLE);
	/* ܂ACK(0xfa)MĂ */
	mouse->phase = 0; /* }EX0xfa҂ĂiK */
	return;
}

int Mouse::decode(Mouse *mouse, unsigned char dat)
{
	if (mouse->phase == 0) {
		/* }EX0xfa҂ĂiK */
		if (dat == 0xfa) {
			mouse->phase = 1;
		}
		return 0;
	}
	if (mouse->phase == 1) {
		/* }EX1oCgڂ҂ĂiK */
		if ((dat & 0xc8) == 0x08) {
			/* 1oCgڂ */
			mouse->buf[0] = dat;
			mouse->phase = 2;
		}
		return 0;
	}
	if (mouse->phase == 2) {
		/* }EX2oCgڂ҂ĂiK */
		mouse->buf[1] = dat;
		mouse->phase = 3;
		return 0;
	}
	if (mouse->phase == 3) {
		/* }EX3oCgڂ҂ĂiK */
		mouse->buf[2] = dat;
		if (mouse->scrollmode != 0) {
			mouse->phase = 4;
		} else {
			mouse->phase = 1;
		}
		mouse->btn = mouse->buf[0] & 0x07;
		mouse->x = mouse->buf[1];
		mouse->y = mouse->buf[2];
		if ((mouse->buf[0] & 0x10) != 0) {
			mouse->x |= 0xffffff00;
		}
		if ((mouse->buf[0] & 0x20) != 0) {
			mouse->y |= 0xffffff00;
		}
		mouse->y = - mouse->y; /* }EXły̕ʂƔ */
		if (mouse->scrollmode != 0) {
			return 0;
		} else {
			return 1;
		}
	}
	if (mouse->phase == 4) {
		/* }EX4oCgڂ҂ĂiK */
		mouse->buf[3] = dat;
		/* XN[Ή}EX̂݃XN[ */
		mouse->phase  = 1;
		/* mouse.buf[3]́A4rbgLȒlł */
		/* Ƃ肠͂ɒl܂ */
		mouse->scroll = mouse->buf[3] & 0x0f;
		if (mouse->scroll & 0x08) {
			/* }CiX̒l */
			mouse->scroll |= 0xfffffff0;
		}
		return 1;
	}
	return -1; /* ɗ邱Ƃ͂Ȃ͂ */
}
