/* ֌W */

#include "bootpack.h"

#define EFLAGS_AC_BIT		0x00040000
#define CR0_CACHE_DISABLE	0x60000000

unsigned int memtest(unsigned int start, unsigned int end)
{
	char flg486 = 0;
	unsigned int eflg, cr0, i;

	/* 386A486ȍ~Ȃ̂̊mF */
	eflg = io_load_eflags();
	eflg |= EFLAGS_AC_BIT; /* AC-bit = 1 */
	io_store_eflags(eflg);
	eflg = io_load_eflags();
	if ((eflg & EFLAGS_AC_BIT) != 0) { /* 386łAC=1ɂĂ0ɖ߂Ă܂ */
		flg486 = 1;
	}
	eflg &= ~EFLAGS_AC_BIT; /* AC-bit = 0 */
	io_store_eflags(eflg);

	if (flg486 != 0) {
		cr0 = load_cr0();
		cr0 |= CR0_CACHE_DISABLE; /* LbV֎~ */
		store_cr0(cr0);
	}

	i = memtest_sub(start, end);

	if (flg486 != 0) {
		cr0 = load_cr0();
		cr0 &= ~CR0_CACHE_DISABLE; /* LbV */
		store_cr0(cr0);
	}

	return i;
}

void memman_init(struct MEMMAN *man)
{
	man->frees = 0;			/* ̌ */
	man->maxfrees = 0;		/* 󋵊ώ@pFfrees̍ől */
	man->lostsize = 0;		/* ɎsvTCY */
	man->losts = 0;			/* Ɏs */
	return;
}

unsigned int memman_total(struct MEMMAN *man)
/* TCY̍v */
{
	unsigned int i, t = 0;
	for (i = 0; i < man->frees; i++) {
		t += man->free[i].size;
	}
	return t;
}

unsigned int memman_alloc(struct MEMMAN *man, unsigned int size)
/* m */
{
	unsigned int i, a;
	for (i = 0; i < man->frees; i++) {
		if (man->free[i].size >= size) {
			/* \ȍL̂𔭌 */
			a = man->free[i].addr;
			man->free[i].addr += size;
			man->free[i].size -= size;
			if (man->free[i].size == 0) {
				/* free[i]ȂȂ̂őOւ߂ */
				man->frees--;
				for (; i < man->frees; i++) {
					man->free[i] = man->free[i + 1]; /* \̂̑ */
				}
			}
			return a;
		}
	}
	return 0; /* Ȃ */
}

int memman_free(struct MEMMAN *man, unsigned int addr, unsigned int size)
/*  */
{
	int i, j;
	/* ܂Ƃ߂₷lƁAfree[]addrɕłق */
	/* ܂Aǂɓׂ߂ */
	for (i = 0; i < man->frees; i++) {
		if (man->free[i].addr > addr) {
			break;
		}
	}
	/* free[i - 1].addr < addr < free[i].addr */
	if (i > 0) {
		/* O */
		if (man->free[i - 1].addr + man->free[i - 1].size == addr) {
			/* Ô̈ɂ܂Ƃ߂ */
			man->free[i - 1].size += size;
			if (i < man->frees) {
				/*  */
				if (addr + size == man->free[i].addr) {
					/* ȂƌƂ܂Ƃ߂ */
					man->free[i - 1].size += man->free[i].size;
					/* man->free[i]̍폜 */
					/* free[i]ȂȂ̂őOւ߂ */
					man->frees--;
					for (; i < man->frees; i++) {
						man->free[i] = man->free[i + 1]; /* \̂̑ */
					}
				}
			}
			return 0; /* I */
		}
	}
	/* OƂ͂܂Ƃ߂Ȃ */
	if (i < man->frees) {
		/* 낪 */
		if (addr + size == man->free[i].addr) {
			/* Ƃ͂܂Ƃ߂ */
			man->free[i].addr = addr;
			man->free[i].size += size;
			return 0; /* I */
		}
	}
	/* Oɂɂ܂Ƃ߂Ȃ */
	if (man->frees < MEMMAN_FREES) {
		/* free[i]Aւ炵āA܂ */
		for (j = man->frees; j > i; j--) {
			man->free[j] = man->free[j - 1];
		}
		man->frees++;
		if (man->maxfrees < man->frees) {
			man->maxfrees = man->frees; /* őlXV */
		}
		man->free[i].addr = addr;
		man->free[i].size = size;
		return 0; /* I */
	}
	/* ɂ点Ȃ */
	man->losts++;
	man->lostsize += size;
	return -1; /* sI */
}

unsigned int memman_alloc_4k(struct MEMMAN *man, unsigned int size)
{
	unsigned int a;
	size = (size + 0xfff) & 0xfffff000;
	a = memman_alloc(man, size);
	return a;
}

int memman_free_4k(struct MEMMAN *man, unsigned int addr, unsigned int size)
{
	int i;
	size = (size + 0xfff) & 0xfffff000;
	i = memman_free(man, addr, size);
	return i;
}
