#include "../../baygui.h"

namespace baygui {
    namespace awt {
        /** Ԃŉł͂Ȃ Frame ̐VCX^X𐶐܂BFrame ̃^Cg͋łB*/
        Frame::Frame() {
            addClassName(baygui_awt_Frame);
            this->handle = 0;
            this->buffer = NULL;
            this->active = NULL;
            this->title  = NULL;
            Application::add(this);
        }

        /** fXgN^łB*/
        Frame::~Frame() {
            delete this->title;
        }

        /** t[̃^CgԂ܂B*/
        char* Frame::getTitle() {
            return this->title;
        }

        /** ̃R|[lg̓tH[JX擾邱Ƃv܂B*/
        void Frame::requestFocus() {
            this->focused = true;
            if (this->active != NULL) {
                this->active->transferFocus();
            }
            this->active = this;
        }

        /** AvP[V̎sJn܂B*/
        void Frame::run() {
            Application::run(this);
        }

        /** ̃t[̃TCYύX܂B*/
        void Frame::setBounds(int x, int y, int width, int height) {
            this->rectangle->x = INSETS_LEFT;
            this->rectangle->y = INSETS_TOP;
            this->rectangle->width  = width;
            this->rectangle->height = height;

            if (this->buffer == NULL) {
                this->buffer = new unsigned char[width * height * sizeof(short)];
#ifdef HARIBOTE
                this->handle = api_openwin(
                    this->buffer, 
                    width, 
                    height, 
                    -1, 
                    (char *) this->title
                );
#endif
            }
        }

        /** ̃t[̃^CgAw肳ꂽɐݒ肵܂B*/
        void Frame::setTitle(const char* title) {
            if (this->title != NULL) delete this->title;
            int I = strlen(title) + 1;
            this->title = new char[I];
            memcpy(this->title, title, I);
        }

        /** ̃R|[lgɃtH[JXړ܂B*/
        void Frame::transferFocus() {
            this->focused = false;
        }
    }
}
