###############################################################################
# <p>
# Wiki API
# </p>
###############################################################################
package Wiki;
use strict;
use CGI2;
use File::Copy;
use File::Path;
use Wiki::DefaultStorage;
use Wiki::HTMLParser;
use vars qw($VERSION $DEBUG);
$VERSION = '3.6.4';
$DEBUG   = 0;
#==============================================================================
# <p>
#   󥹥ȥ饯
# </p>
#==============================================================================
sub new {
	my $class = shift;
	my $self  = {};
	
	# ɤ߹
	my $setupfile = shift || 'setup.dat';
	$self->{"config"} = &Util::load_config_hash(undef,$setupfile);
	die "setup file ${setupfile} not found" if (keys %{$self->{"config"}} == 0);
	$self->{"config"}->{"plugin_dir"} = "."         unless exists($self->{"config"}->{"plugin_dir"});
	$self->{"config"}->{"frontpage"}  = "FrontPage" unless exists($self->{"config"}->{"frontpage"});
	unshift(@INC, $self->{"config"}->{"plugin_dir"});
	$ENV{'TZ'} = $self->{"config"}->{"time_zone"};
	$CGI::POST_MAX = $self->{"config"}->{"post_max"} if $self->{"config"}->{"post_max"} ne '';
	
	# 󥹥ѿ
	$self->{"handler"}            = {};
	$self->{"handler_permission"} = {};
	$self->{"plugin"}             = {};
	$self->{"title"}              = "";
	$self->{"menu"}               = [];
	$self->{"CGI"}                = CGI2->new();
	$self->{"hook"}               = {};
	$self->{"user"}               = ();
	$self->{"admin_menu"}         = ();
	$self->{"editform"}           = ();
	$self->{"edit"}               = 0;
	$self->{"parse_times"}        = 0;
	$self->{"format"}             = {};
	$self->{"installed_plugin"}   = ();
	$self->{"head_info"}          = ();
	
	# ȥ졼Υ󥹥󥹤
	if($self->{config}->{"storage"} eq ""){
		$self->{"storage"} = Wiki::DefaultStorage->new($self);
	} else {
		eval ("use ".$self->{config}->{"storage"}.";");
		$self->{"storage"} = $self->{config}->{"storage"}->new($self);
	}
	
	return bless $self,$class;
}

###############################################################################
#
# 桼طΥ᥽åɷ
#
###############################################################################
#==============================================================================
# <p>
#   桼ɲäޤ
# </p>
# <pre>
# $wiki-&gt;add_user(ID,ѥ,桼);
# </pre>
# <p>
# 桼פˤϴԥ桼ξ0̥桼ξ1ꤷޤ
# ʤΥ᥽åɤϼ¹ԻWiki.pm˥桼ɲä뤿ΤΤǡ
# Υ᥽åɤФƥ桼ɲäƤ³ϹԤޤ
# </p>
#==============================================================================
sub add_user {
	my $self = shift;
	my $id   = shift;
	my $pass = shift;
	my $type = shift;

	push(@{$self->{"user"}},{id=>$id,pass=>$pass,type=>$type});
}

#==============================================================================
# <p>
#   桼¸ߤ뤫ɤǧޤ
# </p>
#==============================================================================
sub user_exists {
	my $self = shift;
	my $id   = shift;
	foreach my $user (@{$self->{"user"}}){
		if($user->{id} eq $id){
			return 1;
		}
	}
	return 0;
}

#==============================================================================
# <p>
#   ޤ
#   󤷤Ƥϥޤϥåե󥹤
#   󤷤Ƥʤundef֤ޤ
# </p>
# <pre>
# my $info = $wiki-&gt;get_login_info();
# if(defined($info)){          # 󤷤Ƥʤundef
#   my $id   = $info-&gt;{id};    # 桼ID
#   my $type = $info-&gt;{type};  # 桼μ(0: 1:)
# }
# </pre>
#==============================================================================
sub get_login_info {
	my $self = shift;
	if (exists($self->{'login_info'})){
		return $self->{'login_info'};
	}

	my $cgi = $self->get_CGI();
	return undef unless(defined($cgi));
	
	my $session = $cgi->get_session($self);
	unless(defined($session)){
		$self->{'login_info'} = undef;
		return undef;
	}
	my $id   = $session->param("wiki_id");
	my $type = $session->param("wiki_type");
	my $path = $session->param("wiki_path");

	# PATH_INFOĴ٤
	my $path_info = $cgi->path_info();
	if(!defined($path_info)){ $path_info  = ""; }
	if(!defined($path     )){ $path       = ""; }
	if(!defined($id       )){ $id         = ""; }
	if(!defined($type     )){ $type       = ""; }
	
	if($path_info eq "" && $path ne ""){
		$self->{'login_info'} = undef;
		return undef;
	} elsif($path ne "" && !($path_info =~ /^$path($|\/)/)){
		$self->{'login_info'} = undef;
		return undef;
	}
	
	# ååȤƤʤ
	if($id eq "" ||  $type eq ""){
		$self->{'login_info'} = undef;
		return undef;
	}
	
	# 桼ֵ
	$self->{'login_info'} = {id=>$id,type=>$type,path=>$path};
	return $self->{'login_info'};
}

#==============================================================================
# <p>
#   åԤޤ
# </p>
#==============================================================================
sub login_check {
	my $self = shift;
	my $id   = shift;
	my $pass = shift;
	my $path = $self->get_CGI()->path_info();
	foreach(@{$self->{"user"}}){
		if($_->{id} eq $id && $_->{pass} eq $pass){
			return {id=>$id,pass=>$pass,type=>$_->{type},path=>$path};
		}
	}
	return undef;
}

###############################################################################
#
# ץ饰طΥ᥽åɷ
#
###############################################################################
#==============================================================================
# <p>
#   ǥåȥեץ饰ɲäޤ
# </p>
# <pre>
# $wiki-&gt;add_editform_plugin(ǥåȥեץ饰Υ饹̾,ͥ);
# </pre>
# <p>
# ͥ٤礭ۤɾ̤ɽޤ
# </p>
#==============================================================================
sub add_editform_plugin {
	my $self   = shift;
	my $plugin = shift;
	my $weight = shift;
	push(@{$self->{"editform"}},{class=>$plugin,weight=>$weight});
}

#==============================================================================
# <p>
#   ԽեѤΥץ饰νϤޤ
# </p>
#==============================================================================
sub get_editform_plugin {
	my $self = shift;
	my $buf = "";
	foreach my $plugin (sort { $b->{weight}<=>$a->{weight} } @{$self->{"editform"}}){
		my $obj = $self->get_plugin_instance($plugin->{class});
		$buf .= $obj->editform($self)."\n";
	}
	return $buf;
}

#==============================================================================
# <p>
# ѤΥ˥塼ɲäޤԥ桼󤷤ɽޤ
# ͥ٤⤤ۤɾΤۤɽޤ
# </p>
# <pre>
# $wiki-&gt;add_admin_menu(˥塼̾,ܤURL,ͥ,ܺ);
# </pre>
#==============================================================================
sub add_admin_menu {
	my $self   = shift;
	my $label  = shift;
	my $url    = shift;
	my $weight = shift;
	my $desc   = shift;
	
	push(@{$self->{"admin_menu"}},{label=>$label,url=>$url,weight=>$weight,desc=>$desc,type=>0});
}

#==============================================================================
# <p>
# 桼ѤΥ˥塼ɲäޤ
# 桼󤷤ɽޤԥ桼ξɽޤ
# ͥ٤⤤ۤɾΤۤɽޤ
# </p>
# <pre>
# $wiki-&gt;add_admin_menu(˥塼̾,ܤURL,ͥ,ܺ);
# </pre>
#==============================================================================
sub add_user_menu {
	my $self   = shift;
	my $label  = shift;
	my $url    = shift;
	my $weight = shift;
	my $desc   = shift;
	
	push(@{$self->{"admin_menu"}},{label=>$label,url=>$url,weight=>$weight,desc=>$desc,type=>1});
}

#==============================================================================
# <p>
# ѤΥ˥塼ޤ
# </p>
#==============================================================================
sub get_admin_menu {
	my $self = shift;
	return sort { $b->{weight}<=>$a->{weight} } @{$self->{"admin_menu"}};
}

#==============================================================================
# <p>
# ץ饰򥤥󥹥ȡ뤷ޤΥ᥽åɤwiki.cgiˤäcallޤ
# ץ饰ȯˤ̾Υ᥽åɤѤ뤳ȤϤޤ
# </p>
#==============================================================================
sub install_plugin {
	my $self   = shift;
	my $plugin = shift;
	
	if ($plugin =~ /\W/) {
		return "<div class=\"error\">".Util::escapeHTML("${plugin}ץ饰ʥץ饰Ǥ")."</div>";
	}
		
	my $module = "plugin::${plugin}::Install";
	eval 'require &Util::get_module_file($module);'.$module.'::install($self);';
	
	if($@){
		return "<div class=\"error\">".Util::escapeHTML("${plugin}ץ饰󤬥󥹥ȡǤޤ$@")."</div>";
	} else {
		push(@{$self->{"installed_plugin"}},$plugin);
		return "";
	}
}

#==============================================================================
# <p>
# ץ饰󤬥󥹥ȡ뤵Ƥ뤫ɤĴ٤ޤ
# </p>
#==============================================================================
sub is_installed {
	my $self   = shift;
	my $plugin = shift;
	
	foreach (@{$self->{"installed_plugin"}}){
		if($_ eq $plugin){
			return 1;
		}
	}
	return 0;
}

#==============================================================================
# <p>
# ˥塼ܤɲäޤƱ̾ιܤϿƤϾ񤭤ޤ
# ͥ٤⤤ۤɺ¦ɽޤ
# </p>
# <pre>
# $wiki-&gt;add_menu(̾,URL,ͥ,ݤ뤫ɤ);
# </pre>
# <p>
# 󥸥˥뤵ʤ41Ĥ0ꤷޤ
# άϥĤޤ
# </p>
#==============================================================================
sub add_menu {
	my $self     = shift;
	my $name     = shift;
	my $href     = shift;
	my $weight   = shift;
	my $nofollow = shift;
	
	my $flag = 0;
	foreach(@{$self->{"menu"}}){
		if($_->{name} eq $name){
			$_->{href} = $href;
			$flag = 1;
			last;
		}
	}
	if($flag==0){
		push(@{$self->{"menu"}},{name=>$name,href=>$href,weight=>$weight,nofollow=>$nofollow});
	}
}

#===============================================================================
# <p>
# եåץ饰ϿޤϿץ饰do_hook᥽åɤǸƤӽФޤ
# </p>
# <pre>
# $wiki-&gt;add_hook(եå̾,եåץ饰Υ饹̾);
# </pre>
#===============================================================================
sub add_hook {
	my $self = shift;
	my $name = shift;
	my $obj  = shift;
	
	push(@{$self->{"hook"}->{$name}},$obj);
}

#===============================================================================
# <p>
# add_hook᥽åɤϿ줿եåץ饰¹Ԥޤ
# ˤϥեå̾˲äǤդΥѥ᡼ϤȤǤޤ
# Υѥ᡼ϸƤӽФ륯饹hook᥽åɤΰȤϤޤ
# </p>
# <pre>
# $wiki-&gt;do_hook(եå̾[,1[,2...]]);
# </pre>
#===============================================================================
sub do_hook {
	my $self = shift;
	my $name = shift;
	
	foreach my $class (@{$self->{"hook"}->{$name}}){
		my $obj = $self->get_plugin_instance($class);
		$obj->hook($self,$name,@_);
	}
}

#==============================================================================
# <p>
# ϥɥץ饰ɲäޤ
# ꥯȻactionȤѥ᡼פ륢󤬸ƤӽФޤ
# </p>
# <pre>
# $wiki-&gt;add_handler(actionѥ᡼,ϥɥΥ饹̾);
# </pre>
#==============================================================================
sub add_handler {
	my $self   = shift;
	my $action = shift;
	my $class  = shift;
	
	$self->{"handler"}->{$action}=$class;
	$self->{"handler_permission"}->{$action} = 1;
}

#==============================================================================
# <p>
# 桼ѤΥϥɥɲäޤ
# Υ᥽åɤˤäɲä줿ϥɥϥ󤷤ƤΤ߼¹ԲǽǤ
# ʳξϥ顼åɽޤ
# </p>
# <pre>
# $wiki-&gt;add_user_handler(actionѥ᡼,ϥɥΥ饹̾);
# </pre>
#==============================================================================
sub add_user_handler {
	my $self   = shift;
	my $action = shift;
	my $class  = shift;
	
	$self->{"handler"}->{$action}=$class;
	$self->{"handler_permission"}->{$action} = 2;
}

#==============================================================================
# <p>
# ѤΥϥɥɲäޤ
# Υ᥽åɤˤäɲä줿ϥɥϴԤȤƥ󤷤ƤΤ߼¹ԲǽǤ
# ʳξϥ顼åɽޤ
# </p>
# <pre>
# $wiki-&gt;add_admin_handler(actionѥ᡼,ϥɥΥ饹̾);
# </pre>
#==============================================================================
sub add_admin_handler {
	my $self   = shift;
	my $action = shift;
	my $class  = shift;
	
	$self->{"handler"}->{$action}=$class;
	$self->{"handler_permission"}->{$action} = 0;
}
#==============================================================================
# <p>
# 饤ץ饰ɲäޤ
# </p>
# <p>
# Υ᥽åɤ3.4ϤȤθߴݻ뤿˻Ĥޤ3.6ѻߤΤȤޤ
# </p>
#==============================================================================
sub add_plugin {
	my $self   = shift;
	my $name   = shift;
	my $class  = shift;
	
	$self->add_inline_plugin($name,$class,"HTML");
}
#==============================================================================
# <p>
# 饤ץ饰Ͽޤץ饰νϥפˤ"WIKI"ޤ"HTML"ꤷޤ
# ά"HTML"ꤷΤȤߤʤޤ
# </p>
# <pre>
# $wiki-&gt;add_inline_plugin(ץ饰̾,ץ饰Υ饹̾,ץ饰νϥ);
# </pre>
#==============================================================================
sub add_inline_plugin {
	my ($self, $name, $class, $format) = @_;
	
	if($format eq ""){
		$format = "HTML";
	} else {
		$format = uc($format);
	}
	
	$self->{"plugin"}->{$name} = {CLASS=>$class,TYPE=>'inline',FORMAT=>$format};
}

#==============================================================================
# <p>
# ѥ饰եץ饰Ͽޤץ饰νϥפˤ"WIKI"ޤ"HTML"ꤷޤ
# ά"HTML"ꤷΤȤߤʤޤ
# </p>
# <pre>
# $wiki-&gt;add_inline_plugin(ץ饰̾,ץ饰Υ饹̾,ץ饰νϥ);
# </pre>
#==============================================================================
sub add_paragraph_plugin {
	my ($self, $name, $class, $format) = @_;
	
	if($format eq ""){
		$format = "HTML";
	} else {
		$format = uc($format);
	}
	
	$self->{"plugin"}->{$name} = {CLASS=>$class,TYPE=>'paragraph',FORMAT=>$format};
}

#==============================================================================
# <p>
# ֥åץ饰Ͽޤץ饰νϥפˤ"WIKI"ޤ"HTML"ꤷޤ
# ά"HTML"ꤷΤȤߤʤޤ
# </p>
# <pre>
# $wiki-&gt;add_block_plugin(ץ饰̾,ץ饰Υ饹̾,ץ饰νϥ);
# </pre>
#==============================================================================
sub add_block_plugin {
	my ($self, $name, $class, $format) = @_;
	
	if($format eq ""){
		$format = "HTML";
	} else {
		$format = uc($format);
	}
	
	$self->{"plugin"}->{$name} = {CLASS=>$class,TYPE=>'block',FORMAT=>$format};
}

#==============================================================================
# <p>
# ץ饰ξޤ
# </p>
# <pre>
# my $info = $wiki-&gt;get_plugin_info(&quot;include&quot;);
# my $class  = $info-&gt;{CLASS};  # ץ饰Υ饹̾
# my $type   = $info-&gt;{TYPE};   # inlineparagraphblockΤ줫
# my $format = $info-&gt;{FORMAT}; # HTMLޤWIKI
# </pre>
#==============================================================================
sub get_plugin_info {
	my $self = shift;
	my $name = shift;
	
	return $self->{plugin}->{$name};
}

#==============================================================================
# <p>
# add_handler᥽åɤϿ줿ϥɥ¹Ԥޤ
# ϥɥdo_action᥽åɤ֤ͤޤ
# </p>
# <pre>
# my $content = $wiki-&gt;call_handler(actionѥ᡼);
# </pre>
#==============================================================================
sub call_handler {
	my $self   = shift;
	my $action = shift;
	
	if(!defined($action)){
		$action = "";
	}
	
	my $obj = $self->get_plugin_instance($self->{"handler"}->{$action});
	
	unless(defined($obj)){
		return $self->error("ʥǤ");
	}
	
	# ѤΥ
	if($self->{"handler_permission"}->{$action}==0){
		my $login = $self->get_login_info();
		if(!defined($login)){
			return $self->error("󤷤Ƥޤ");
			
		} elsif($login->{type}!=0){
			return $self->error("Ը¤ɬפǤ");
		}
		return $obj->do_action($self).
		       "<div class=\"comment\"><a href=\"".$self->create_url({action=>"LOGIN"})."\">˥塼</a></div>";
	
	# 桼ѤΥ
	} elsif($self->{"handler_permission"}->{$action}==2){
		my $login = $self->get_login_info();
		if(!defined($login)){
			return $self->error("󤷤Ƥޤ");
		}
		return $obj->do_action($self).
		       "<div class=\"comment\"><a href=\"".$self->create_url({action=>"LOGIN"})."\">˥塼</a></div>";
		
	# ̤Υ
	} else {
		return $obj->do_action($self);
	}
}

#===============================================================================
# <p>
# ϤWikiեޥåȤʸHTMLѴ֤ޤ
# </p>
# <pre>
# my $html = $wiki-&gt;process_wiki(ʸ);
# </pre>
#===============================================================================
sub process_wiki {
	my $self    = shift;
	my $source  = shift;
	my $mainflg = shift;
	
	if($self->{parse_times} >= 50){
		return $self->error("Wiki::process_wikiθƤӽФ¤ۤޤ");
	}
	
	$self->{parse_times}++;
	my $parser = Wiki::HTMLParser->new($self,$mainflg);
	$parser->parse($source);
	$self->{parse_times}--;
	
	return $parser->{html};
}

#===============================================================================
# <p>
# 饤ץ饰󡢥ѥ饰եץ饰θƤӽФѤδؿˡ
# Υ᥽åɤΤ̿̾§private᥽åɤΥ᥽å̾_Ϥ
# ˽äƤޤ
# </p>
#===============================================================================
sub process_plugin {
	my $self   = shift;
	my $plugin = shift;
	my $parser = shift;
	
	if(defined($plugin->{error}) && $plugin->{error} ne ""){
		return "<font class=\"error\">".$plugin->{error}."</font>";
	}

	my $name = $plugin->{command};
	my @args = @{$plugin->{args}};
	my $info = $self->get_plugin_info($name);
	my $obj  = $self->get_plugin_instance($info->{CLASS});

	if(!defined($obj)){
		return "<font class=\"error\">".&Util::escapeHTML($name)."ץ饰¸ߤޤ</font>";
		
	} else {
		if($info->{FORMAT} eq "WIKI"){
			# ΢(ץ饰ѡȤ)
			push(@{$self->{'current_parser'}}, $parser);
			if($info->{TYPE} eq "inline"){
				my @result = $parser->parse_line($obj->inline($self,@args));
				pop(@{$self->{'current_parser'}});
				return @result;
			} elsif($info->{TYPE} eq "paragraph"){
				$parser->parse($obj->paragraph($self,@args));
			} else {
				$parser->parse($obj->block($self,@args));
			}
			# ѡλȤ
			pop(@{$self->{'current_parser'}});
			return undef;
		} else {
			if($info->{TYPE} eq "inline"){
				return $obj->inline($self,@args);
			} elsif($info->{TYPE} eq "paragraph"){
				return $obj->paragraph($self,@args);
			} else {
				return $obj->block($self,@args);
			}
		}
	}
}

#==============================================================================
# <p>
# ѡξ硢ͭWiki::ParserΥ󥹥󥹤ֵѤޤ
# ѡƤץ饰󤫤ѹ˻Ѥޤ
# </p>
#==============================================================================
sub get_current_parser {
	my $self = shift;
	my @parsers = @{$self->{'current_parser'}};
	return $parsers[$#parsers];
}

#==============================================================================
# <p>
# 顼ξ硢ƤӽФޤ
# ϥɥ餫饨顼𤹤ݤ˻ѤƤ
# </p>
# <pre>
# sub do_action {
#   my $self = shift;
#   my $wiki = shift;
#   ...
#   return $wiki-&gt;error(顼å);
# }
# </pre>
#==============================================================================
sub error {
	my $self    = shift;
	my $message = shift;
	
	$self->set_title("顼");
	$self->get_CGI->param("action","ERROR");
	
	return "<div class=\"error\">".Util::escapeHTML($message)."</div>";
}

#===============================================================================
# <p>
# ץ饰Υ󥹥󥹤ޤWiki.pmŪ˻Ѥ᥽åɤǤ
# ץ饰ȯˤ̾Υ᥽åɤѤɬפϤޤ
# </p>
#===============================================================================
sub get_plugin_instance {
	my $self  = shift;
	my $class = shift;
	
	if($class eq ""){
		return undef;
	}
	
	if(!defined($self->{instance}->{$class})){
		eval {
			require &Util::get_module_file($class);
		};
		return undef if $@;
		my $obj = $class->new();
		$self->{instance}->{$class} = $obj;
		
		return $obj;
	} else {
		return $self->{instance}->{$class};
	}
}

#===============================================================================
# <p>
# 饤ץ饰ѡƥޥɤȰʬ䤷ޤ
# </p>
#===============================================================================
sub parse_inline_plugin {
	my $self = shift;
	my $text = shift;
	my ($cmd, @args_tmp) = split(/ /,$text);
	my $args_txt = &Util::trim(join(" ",@args_tmp));
	if($cmd =~ s/}}(.*?)$//){
		return { command=>$cmd, args=>[], post=>"$1 $args_txt"};
	}
	
	my @ret_args;
	my $tmp    = "";
	my $escape = 0;
	my $quote  = 0;
	my $i      = 0;
	
	for($i = 0; $i<length($args_txt); $i++){
		my $c = substr($args_txt,$i,1);
		if($quote!=1 && $c eq ","){
			if($quote==3){
				$tmp .= '}';
			}
			push(@ret_args,$tmp);
			$tmp = "";
			$quote = 0;
		} elsif($quote==1 && $c eq "\\"){
			if($escape==0){
				$escape = 1;
			} else {
				$tmp .= $c;
				$escape = 0;
			}
		} elsif($quote==0 && $c eq '"'){
			if($tmp eq ""){
				$quote = 1;
			} else {
				$tmp .= $c;
			}
		} elsif($quote==1 && $c eq '"'){
			if($escape==1){
				$tmp .= $c;
				$escape = 0;
			} else {
				$quote = 2;
			}
		} elsif(($quote==0 || $quote==2) && $c eq '}'){
			$quote = 3;
		} elsif($quote==3){
			if($c eq '}'){
				last;
			} else {
				$tmp .= '}'.$c;
				$quote = 0;
			}
		} elsif($quote==2){
			return {error=>"饤ץ饰ιʸǤ"};
		} else {
			$tmp .= $c;
			$escape = 0;
		}
	}
	
	if($quote!=3){
		my $info = $self->get_plugin_info($cmd);
		return undef if (defined($info->{TYPE}) && $info->{TYPE} ne 'block');
	}
	
	if($tmp ne ""){
		push(@ret_args,$tmp);
	}
	
	return { command=>$cmd, args=>\@ret_args, 
		post=>substr($args_txt, $i + 1, length($args_txt) - $i)};
}

#==============================================================================
# <p>
# եޥåȥץ饰ɲäޤ
# եޥåȥץ饰convert_to_fswiki᥽åɤconvert_from_fswiki᥽åɤ
# 饹ǤʤƤϤʤޤ
# </p>
# <pre>
# $wiki-&gt;add_format_plugin(ʸˡ̾,饹̾);
# </pre>
#==============================================================================
sub add_format_plugin {
	my $self  = shift;
	my $name  = shift;
	my $class = shift;
	
	$self->{'format'}->{$name} = $class;
}

#==============================================================================
# <p>
# 󥹥ȡ뤵Ƥեޥåȥץ饰ΰޤ
# </p>
# <pre>
# my @formats = $wiki-&gt;get_format_names();
# </pre>
#==============================================================================
sub get_format_names {
	my $self = shift;
	my @list = keys(%{$self->{'format'}});
	if(!scalar(@list)){
		push(@list, "FSWiki");
	}
	return sort(@list);
}

#==============================================================================
# <p>
# Wiki񼰤ǵҤFSWikiν񼰤Ѵޤ
# </p>
# <pre>
# $source = $wiki-&gt;convert_to_fswiki($source,&quot;YukiWiki&quot;);
# </pre>
# <p>
# 饤񼰤ΤѴԤ軰1Ϥޤ
# </p>
# <pre>
# $source = $wiki-&gt;convert_to_fswiki($source,&quot;YukiWiki&quot;,1);
# </pre>
#==============================================================================
sub convert_to_fswiki {
	my $self   = shift;
	my $source = shift;
	my $type   = shift;
	my $inline = shift;
	
	my $obj = $self->get_plugin_instance($self->{'format'}->{$type});
	unless(defined($obj)){
		return $source;
	} else {
		$source =~ s/\r\n/\n/g;
		$source =~ s/\r/\n/g;
		if($inline){
			return $obj->convert_to_fswiki_line($source);
		} else {
			return $obj->convert_to_fswiki($source);
		}
	}
}

#==============================================================================
# <p>
# FSWikiν񼰤ǵҤWikiν񼰤Ѵޤ
# </p>
# <pre>
# $source = $wiki-&gt;convert_from_fswiki($source,&quot;YukiWiki&quot;);
# </pre>
# <p>
# 饤񼰤ΤѴԤ軰1Ϥޤ
# </p>
# <pre>
# $source = $wiki-&gt;convert_from_fswiki($source,&quot;YukiWiki&quot;,1);
# </pre>
#==============================================================================
sub convert_from_fswiki {
	my $self   = shift;
	my $source = shift;
	my $type   = shift;
	my $inline = shift;
	
	my $obj = $self->get_plugin_instance($self->{'format'}->{$type});
	unless(defined($obj)){
		return $source;
	} else {
		$source =~ s/\r\n/\n/g;
		$source =~ s/\r/\n/g;
		if($inline){
			return $obj->convert_from_fswiki_line($source);
		} else {
			return $obj->convert_from_fswiki($source);
		}
	}
}

#==============================================================================
# <p>
# ߤΥ桼Խ˻ѤեޥåȤޤ
# formatץ饰󤬥ƥ١ȤƤʤϾ"FSWiki"֤ޤ
# </p>
# <pre>
# my $format = $wiki-&gt;get_edit_format();
# </pre>
#==============================================================================
sub get_edit_format {
	my $self = shift;
	my $from = shift;
	
	# formatץ饰󤬥ƥ١ȤƤʤFSWikiեޥåȤ֤
	unless($self->is_installed("format")){
		return "FSWiki";
	}

	#̾ϴĶ̤ꤷWikiեޥåȤ
	my $config = &Util::load_config_hash($self, $self->config('config_file'));
	my $format = $config->{site_wiki_format};

	# Cookie˥եޥåȤꤵƤϤ
	#(âconfig.datե뤫μCookie̵)
	if($from ne "config"){
		my $cgi = $self->get_CGI();
		if($cgi->cookie(-name=>'edit_format') ne ""){
			$format = $cgi->cookie(-name=>'edit_format');
		}
	}

	if($format eq ""){
		return "FSWiki";
	} else {
		return $format;
	}
}

#==============================================================================
# <p>
# head˽Ϥɲäޤ
# ȥƥץ졼ȤбƤɬפޤ
# </p>
# <pre>
# $wiki-&gt;add_head_info(&quot;<link rel=\&quot;alternate\&quot; type=\&quot;application/rss+xml\&quot; title=\&quot;RSS\&quot; href=\&quot;?action=RSS\&quot;>&quot;);
# </pre>
#==============================================================================
sub add_head_info {
	my $self = shift;
	my $info = shift;
	
	push(@{$self->{'head_info'}},$info);
}

###############################################################################
#
# ˴ؤ᥽åɷ
#
###############################################################################
#==============================================================================
# <p>
# ڡ뤷ޤ
# </p>
# <pre>
# $wiki-&gt;freeze_page(ڡ̾);
# </pre>
#==============================================================================
sub freeze_page {
	my $self = shift;
	$self->{"storage"}->freeze_page(@_);
}

#==============================================================================
# <p>
# ڡޤ
# </p>
# <pre>
# $wiki-&gt;un_freeze_page(ڡ̾);
# </pre>
#==============================================================================
sub un_freeze_page {
	my $self = shift;
	$self->{"storage"}->un_freeze_page(@_);
}

#==============================================================================
# <p>
# 뤵ƤڡΥꥹȤޤ
# </p>
#==============================================================================
sub get_freeze_list {
	my $self = shift;
	return $self->{"storage"}->get_freeze_list();
}

#==============================================================================
# <p>
# Ϥڡ椫ɤ٤ޤ
# </p>
# <pre>
# if($wiki-&gt;is_freeze(ڡ̾)){
#   ...
# }
# </pre>
#==============================================================================
sub is_freeze {
	my $self = shift;
	my $page = shift;
	my $path = undef;
	
	if($page =~ /(^.*?[^:]):([^:].*?$)/){
		$path = $1;
		$page = $2;
	}
	
	return $self->{storage}->is_freeze($page,$path);
}

#==============================================================================
# <p>
# ϤڡԽǽɤĴ٤ޤ
# ԽԲĥ⡼ɡsetup.pl$accept_edit0ꤵƤˤϥ󤷤ƤԽǽ
# ڡ뤵Ƥϴԥ桼ǥ󤷤ƤԽǽȤʤޤ
# </p>
# <pre>
# if($wiki-&gt;can_modify_page(ڡ̾)){
#   ...
# }
# </pre>
#==============================================================================
sub can_modify_page {
	my $self = shift;
	my $page = shift;
	my $login = $self->get_login_info();
	if($self->config('accept_edit')==0 && !defined($login)){
		return 0;
	}
	if($self->config('accept_edit')==2 && (!defined($login) || $login->{type}!=0)){
		return 0;
	}
	if($self->is_freeze($page) && (!defined($login) || $login->{type}!=0)){
		return 0;
	}
	unless($self->can_show($page)){
		return 0;
	}
	return 1;
}

###############################################################################
#
# ȸ¤˴ؤ᥽åɷ
#
###############################################################################
#==============================================================================
# <p>
# ڡλȥ٥ꤷޤ
# <p>
# <ul>
#   <li>0 - ˸</li>
#   <li>1 - 桼˸</li>
#   <li>2 - Ԥ˸</li>
# </ul>
# <pre>
# $wiki-&gt;set_page_level(ڡ̾,٥);
# </pre>
#==============================================================================
sub set_page_level {
	my $self  = shift;
	my $page  = shift;
	my $level = shift;

	$self->{"storage"}->set_page_level($page,$level);

	# $level ̤ʤڡǡʤΤǡեåϢס
	return if (not defined $level);

	# ݤ򸡺
	my $new_level = $self->get_page_level($page);
	if ($new_level != $level) {
		die "ڡ '$page' λȸ¥٥ '$level' ѹ褦ȤޤԤޤ";
	}

	# ڡ٥ѹΤǡեåȯԡ
	$self->do_hook('change_page_level', $page, $new_level);
}

#==============================================================================
# <p>
# ڡλȥ٥ޤ
# ڡ̾ꤵƤʤ硢ƤΥڡλȥ٥
# ϥåե󥹤֤ޤ
# </p>
# <ul>
#   <li>0 - ˸</li>
#   <li>1 - 桼˸</li>
#   <li>2 - Ԥ˸</li>
# </ul>
# <pre>
# my $level = $get_page_level(ڡ̾);
# </pre>
#==============================================================================
sub get_page_level {
	my $self  = shift;
	my $page  = shift;
	my $path  = undef;
	
	if($page =~ /(^.*?[^:]):([^:].*?$)/){
		$path = $1;
		$page = $2;
	}
	
	$self->{"storage"}->get_page_level($page,$path);
}

#==============================================================================
# <p>
# ߤΥ桼¤Ǳǽʥڡ٥ξͤޤ
# </p>
# <pre>
# my $can_show_max = $wiki-&gt;_get_can_show_max();
# </pre>
#==============================================================================
sub _get_can_show_max {
	my $self = shift;

	# ֱǽ page level ξ͡פΤʤСֵѡ
	if (exists $self->{'can_show_max'}) {
		return $self->{'can_show_max'};
	}

	# Wiki Τα¤ͤȡԤΥ桼¥٥롣
	my $accept_show = $self->config('accept_show'); # Wiki Τα
	my $login_user  = $self->get_login_info();      # ߤ login 
	my $user_level                                  # 桼¥٥
		= (not defined $login_user)  ? 0            #   桼
		: ($login_user->{type} != 0) ? 1            #   桼
		:                              2;           #   

	# Wiki Τα¤ãƤ桼ʤ顢
	if ($user_level >= $accept_show) {
		# ֱǽ page level ͡פϡ桼¥٥
		return $self->{'can_show_max'} = $user_level;
	}

	# Wiki Τα¤ãƤʤ桼ʤΤǡ
	# ֱǽ page level ͡פ -1ʤڡԲġ
	return $self->{'can_show_max'} = -1;
}

#==============================================================================
# <p>
# ڡȲǽɤޤ
# </p>
# <pre>
# if($wiki-&gt;can_show(ڡ̾)){
#   # Ȳǽ
# } else {
#   # Բǽ
# }
# </pre>
#==============================================================================
sub can_show {
	my ($self, $page) = @_;

	#ֱǽ page level ¡פ̤ΤʤС롣
	if (not exists $self->{'can_show_max'}) {
		$self->_get_can_show_max();
	}

	# page level ǽ page level °ʲʤ鿿֤
	return ($self->get_page_level($page) <= $self->{'can_show_max'});
}

###############################################################################
#
# ¾Υ᥽åɷ
#
###############################################################################
#==============================================================================
# <p>
# ڡ˥פ뤿URL桼ƥƥ᥽åɤǤ
# Ȥƥڡ̾Ϥޤ
# </p>
# <pre>
# $wiki-&gt;create_page_url(&quot;FrontPage&quot;);
# </pre>
# <p>
# 嵭Υɤ̾ʲURLޤ
# </p>
# <pre>
# wiki.cgi?page=FrontPage
# </pre>
#==============================================================================
sub create_page_url {
	my $self = shift;
	my $page = shift;
	return $self->create_url({page=>$page});
}

#==============================================================================
# <p>
# ǤդURL뤿Υ桼ƥƥ᥽åɤǤ
# Ȥƥѥ᡼Υϥåե󥹤Ϥޤ
# </p>
# <pre>
# $wiki-&gt;create_url({action=>HOGE,type=>1});
# </pre>
# <p>
# 嵭Υɤ̾ʲURLޤ
# </p>
# <pre>
# wiki.cgi?action=HOGE&amp;type=1
# </pre>
#==============================================================================
sub create_url {
	my $self   = shift;
	my $params = shift;
	my $url    = $self->config('script_name');
	my $query  = '';
	foreach my $key (keys(%$params)){
		if($query ne ''){
			$query .= '&amp;';
		}
		$query .= Util::url_encode($key)."=".Util::url_encode($params->{$key});
	}
	if($query ne ''){
		$url .= '?'.$query; 
	}
	return $url;
}

#==============================================================================
# <p>
# ϥɥǥȥꤹ˻Ѥޤ
# </p>
# <pre>
# $wiki-&gt;set_title(ȥ[,ԽϤΥڡɤ]);
# </pre>
# <p>
# ԽϤβ̤ξ硢1ꤷƤ
# ܥåкѤ˰ʲMETAϤޤ
# </p>
# <pre>
# &lt;meta name=&quot;ROBOTS&quot; content=&quot;NOINDEX, NOFOLLOW&quot;&gt;
# </pre>
#==============================================================================
sub set_title {
	my $self  = shift;
	my $title = shift;
	my $edit  = shift;
	$self->{"title"} = $title;
	$self->{"edit"}  = 1 if $edit;
}

#==============================================================================
# <p>
# ȥޤ
# </p>
#==============================================================================
sub get_title {
	my $self = shift;
	return $self->{"title"};
}

#==============================================================================
# <p>
# ڡΰޤ
# Ȥƥϥåե󥹤ϤȤǼƤꤹ뤳Ȥǽ
# ǥեȤǤƤΥڡ̾ǥȤꥹȤֵѤ롣
# </p>
# <p>
# ʲϻȸΤڡΤ߼ǥȤ롣
# </p>
# <pre>
# my @list = $wiki-&gt;get_page_list({-sort   => 'last_modified',
#                                  -permit => 'show'});
# </pre>
# <p>
# ʲƤΥڡ̾ǥȤ롣
# </p>
# <pre>
# my @list = $wiki-&gt;get_page_list({-sort => 'name'});
# </pre>
# <p>
# ʲϺǿ10롣
# </p>
# <pre>
# my @list = $wiki-&gt;get_page_list({-sort=>'last_modified',-max=>10});
# </pre>
#==============================================================================
sub get_page_list {
	my $self = shift;
	my $args = shift;
	
	return $self->{"storage"}->get_page_list($args);

}

#==============================================================================
# <p>
# ڡʪŪʡʥǡեι˺ǽޤ
# </p>
# <pre>
# my $modified = $wiki-&gt;get_last_modified(ڡ̾);
# </pre>
#==============================================================================
sub get_last_modified {
	my $self = shift;
	return $self->{"storage"}->get_last_modified(@_);
}

#==============================================================================
# <p>
# ڡŪʺǽޤ
# ֥ॹפ򹹿ʤפ˥åƥڡ¸
# Υ᥽åɤ֤¸ΤΤˤʤޤ
# </p>
# <pre>
# my $modified = $wiki-&gt;get_last_modified2(ڡ̾);
# </pre>
#==============================================================================
sub get_last_modified2 {
	my $self = shift;
	return $self->{"storage"}->get_last_modified2(@_);
}

#==============================================================================
# <p>
# ڡΥޤ
# </p>
# <p>
# 軰˥եޥå̾ϤΤߡեޥåȥץ饰ˤ
# ѴԤޤʳξɬפ˱ƥץ饰¦
# Wiki::convert_from_fswiki᥽åɤƤѴԤޤ
# </p>
#==============================================================================
sub get_page {
	my $self   = shift;
	my $page   = shift;
	my $format = shift;
	my $path   = undef;
	
	if($page =~ /(^.*?[^:]):([^:].*?$)/){
		$path = $1;
		$page = $2;
	}
	
	my $content = $self->{"storage"}->get_page($page,$path);
	
	if($format eq "" || $format eq "FSWiki"){
		return $content;
	} else {
		return $self->convert_from_fswiki($content,$format);
	}
}

#==============================================================================
# <p>
# Хååפ줿ޤХååפ¸ߤʤ϶ʸ֤ޤ
# Хååפбȥ졼ѤƤ˼ꤹ뤳ȤǤޤ
# </p>
# <pre>
# # ХååפѤƤʤ
# my $backup = $wiki-&gt;get_backup(ڡ̾);
#
# # ХååפѤƤ
# my $backup = $wiki-&gt;get_backup(ڡ̾,);
# </pre>
# <p>
# ϸŤΤ0οͤǻꤷޤ
# </p>
#==============================================================================
sub get_backup {
	my $self = shift;
	return $self->{"storage"}->get_backup(@_);
}

#==============================================================================
# <p>
# ڡ¸ޤ
# å⡼ONѤƤ硢ڡΥåޤ
# </p>
# <pre>
# $wiki-&gt;save_page(ڡ̾,ڡ);
# </pre>
# <p>
# եޥåȥץ饰ˤեޥåȤѴϹԤޤ
# Ĥޤꡢեޥåȥץ饰ѤƤ硢Υ᥽åɤϤ
# WikiϻFSWikiѴ줿ǤʤФʤޤ
# </p>
# <p>
# ¸˥ॹפ򹹿ʤ硢軰1Ϥޤ
# </p>
# <pre>
# $wiki-&gt;save_page(ڡ̾,ڡ,1);
# </pre>
#
#==============================================================================
sub save_page {
	my $self     = shift;
	my $pagename = shift;
	my $content  = shift;
	my $sage     = shift;
	
	# ڡ̾å
	if($pagename =~ /([\|\[\]])|^:|([^:]:[^:])/){
		die "ڡ̾˻ѤǤʤʸޤޤƤޤ";
	}
	# äѥ᡼
	$self->get_CGI->param("page"   ,$pagename);
	$self->get_CGI->param("content",$content);
	$self->do_hook("save_before");
	# ѥ᡼ɤ߹ľ
	$content = $self->get_CGI()->param("content");
	
	if($self->{"storage"}->save_page($pagename,$content,$sage)){
		if($content ne ""){
			$self->do_hook("save_after");
		} else {
			$self->do_hook("delete");
		}
	}
}

#===============================================================================
# <p>
# ڡ¸ߤ뤫ɤĴ٤ޤ
# </p>
# <pre>
# if($wiki-&gt;page_exists(ڡ̾)){
#   # ڡ¸ߤν
# } else {
#   # ڡ¸ߤʤν
# }
# </pre>
#===============================================================================
sub page_exists {
	my $self = shift;
	my $page = shift;
	my $path = undef;
	
	if($page =~ /(^.*?[^:]):([^:].*?$)/){
		$path = $1;
		$page = $2;
	}
	
	# InterWikiλǥɥåȤޤळȤϤǤʤ
	if(defined($path) && index($path,".")!=-1){
		return 0;
	}
	
	return $self->{"storage"}->page_exists($page,$path);
}

#===============================================================================
# <p>
# CGI֥Ȥ
# </p>
# <pre>
# my $cgi = $wiki-&gt;get_CGI;
# </pre>
#===============================================================================
sub get_CGI {
	my $self = shift;
	return $self->{"CGI"};
}

#==============================================================================
# <p>
# Ϥڡ˥쥯Ȥޤ
# ڡ¸˥ڡɽϤΥ᥽åɤѤƲ
# ʤΥ᥽åɤƤӽФȤǥץȤμ¹ԤϽλƤӽФޤ
# </p>
# <pre>
# $wiki-&gt;redirect(&quot;FrontPage&quot;);
# </pre>
#==============================================================================
sub redirect {
	my $self = shift;
	my $page = shift;
	$self->redirectURL($self->create_page_url($page));
}

#==============================================================================
# <p>
# URL˥쥯Ȥޤ
# Υ᥽åɤƤӽФȤǥץȤμ¹ԤϽλƤӽФޤ
# </p>
# <pre>
# $wiki-&gt;redirectURL(쥯ȤURL);
# </pre>
#==============================================================================
sub redirectURL {
	my $self = shift;
	my $url  = shift;
	
	# Locationǥ쥯
	if($self->config('redirect')==1){
		my ($hoge,$param) = split(/\?/,$url);
		$url = $self->get_CGI->url().$self->get_CGI()->path_info();
		if($param ne ''){
			$url = "$url?$param";
		}
		print "Location: $url\n\n";
		
	# METAǥ쥯
	} else {
		my $tmpl = HTML::Template->new(filename=>$self->config('tmpl_dir')."/redirect.tmpl",
		                               die_on_bad_params => 0);
		
		$tmpl->param(URL=>$url);
		
		print "Content-Type: text/html\n\n";
		print $tmpl->output();
	}
	exit();
}

#==============================================================================
# <p>
# Х⤷ѹޤ
# </p>
# <pre>
# # ǡեǼǥ쥯ȥ
# my $data_dir = $wiki-&gt;config('data_dir');
#
# # $data_dirǾ
# $wiki-&gt;config('data_dir',$data_dir);
# </pre>
#==============================================================================
sub config {
	my $self  = shift;
	my $name  = shift;
	my $value = shift;
	if(defined($value)){
		$self->{config}->{$name} = $value;
	} else {
		return $self->{config}->{$name};
	}
}
###############################################################################
#
# FarmطΥ᥽åɷ
#
###############################################################################
#==============================================================================
# <p>
# FarmǽͭˤʤäƤ뤫ɤޤ
# </p>
# <pre>
# if($wiki-&gt;farm_is_enable()){
#   # FarmͭˤʤäƤȤν
# } else {
#   # Farm̵ˤʤäƤȤν
# }
# </pre>
#==============================================================================
sub farm_is_enable {
	my $self = shift;
	my $farm_config = &Util::load_config_hash($self,$self->config('farmconf_file'));
	if(defined $farm_config->{usefarm} and $farm_config->{usefarm}==1){
		return 1;
	} else {
		return 0;
	}
}

#==============================================================================
# <p>
# WikiޤˤWiki̾WikiȤδIDѥɤϤޤ
# Υ᥽åǤWiki̾ΥХǡʣåϹԤޤ
# ˹ԤɬפޤΥ᥽åɤfarmץ饰ѤƤΤ߻ѲǽǤ
# </p>
# <pre>
# $wiki-&gt;create_wiki(Wiki̾,ID,ѥ);
# </pre>
#==============================================================================
sub create_wiki{
	my $self  = shift;
	my $child = shift;
	my $id    = shift;
	my $pass  = shift;
	
	# databackupǥ쥯ȥ򷡤StorageǤۤʡ
	unless($self->wiki_exists($child)){
		eval {
			# ǥݡȤǥ쥯ȥ򷡤
			mkpath($self->config('data_dir'  )."/$child") or die $!;
			mkpath($self->config('backup_dir')."/$child") or die $!;
			mkpath($self->config('config_dir')."/$child") or die $!;
			mkpath($self->config('log_dir'   )."/$child") or die $!;
			
			# Υԡ
			copy($self->config('config_dir')."/".$self->config('config_file'),
			     $self->config('config_dir')."/$child/".$self->config('config_file')) or die $!;
			copy($self->config('config_dir')."/".$self->config('usercss_file'),
			     $self->config('config_dir')."/$child/".$self->config('usercss_file')) or die $!;
			copy($self->config('config_dir')."/".$self->config('plugin_file'),
			     $self->config('config_dir')."/$child/".$self->config('plugin_file')) or die $!;
			copy($self->config('config_dir')."/".$self->config('mime_file'),
			     $self->config('config_dir')."/$child/".$self->config('mime_file')) or die $!;
			
			# 桼κʤǺΤϤäȥ줫⡦
			open(USERDAT,">".$self->config('config_dir')."/$child/".$self->config('userdat_file')) or die $!;
			print USERDAT "$id=".&Util::md5($pass,$id)."\t0\n";
			close(USERDAT);
			
			# ƥץ졼ȤڡΥԡ
			my $farm_config = &Util::load_config_hash($self,$self->config('farmconf_file'));
			if($farm_config->{'use_template'}==1 && $child ne "template"){
				my $template = $self->config('data_dir')."/template";
				my $depth = $self->_get_wiki_depth();
				my $count = 0;
				while((!(-e $template) || !(-d $template)) && $count < $depth && $farm_config->{'search_parent'}==1){
					$template =~ s/\/template$//;
					$template = $template."/../template";
					$count++;
				}
				if(-e $template && -d $template){
					opendir(DIR,$template) or die $!;
					while(my $entry = readdir(DIR)){
						if($entry =~ /\.wiki$/){
							copy($template."/$entry",$self->config('data_dir')."/$child/$entry");
						}
					}
					closedir(DIR);
				}
			}
			# create_wikiեåθƤӽФ
			$self->do_hook("create_wiki");
		};
		
		# 顼ȯ祯꡼󥢥å׽
		if($@){
			my $error = $@;
			# ϥ顼ФƤ³
			eval {
				$self->remove_wiki("/$child");
			};
			die "$childκ˼Ԥޤȯ顼ϰʲΤȤǤ\n\n$error";
		}
	}
}

#==============================================================================
# <p>
# ߤWikiγؤֵѤޤ롼Ȥξ0Wikiξ1
# ¹Wikiξ2ĤȤ褦ˤʤޤ
# </p>
#==============================================================================
sub _get_wiki_depth {
	my $self = shift;
	my $path_info = $self->get_CGI()->path_info();
	$path_info =~ s/^\///;
	my $depth = split(/\//,$path_info);
	return $depth;
}

#==============================================================================
# <p>
# WikiޤˤϺWikiȤΥѥPATH_INFOʬˤϤޤ
# Υ᥽åɤfarmץ饰ѤƤΤ߻ѲǽǤ
# </p>
# <pre>
# $wiki-&gt;remove_wiki(WikiȤΥѥ);
# </pre>
#==============================================================================
sub remove_wiki {
	my $self = shift;
	my $path = shift;
	
	# ǥݡȤǥ쥯ȥ
	rmtree($self->config('data_dir'  ).$path) or die $!;
	rmtree($self->config('backup_dir').$path) or die $!;
	rmtree($self->config('config_dir').$path) or die $!;
	rmtree($self->config('log_dir'   ).$path) or die $!;
	
	# remove_wikiեåθƤӽФ
	$self->get_CGI()->param('path',$path);
	$self->do_hook("remove_wiki");
}

#==============================================================================
# <p>
# Ϥ̾ΤλWiki¸ߤ뤫ɤĴ٤ޤ
# Υ᥽åɤfarmץ饰ѤƤΤ߻ѲǽǤ
# </p>
# <pre>
# $wiki-&gt;wiki_exists(Wiki̾);
# </pre>
#==============================================================================
sub wiki_exists{
	my $self  = shift;
	my $child = shift;
	return ($child =~ /[A-Za-z0-9]+(\/[A-Za-z0-9]+)*/
			and -d $self->config('data_dir')."/$child");
}

#==============================================================================
# <p>
# WikiǼޤ¹Wiki¹WikiΥե󥹤ȤƳǼƤޤ
# </p>
#==============================================================================
sub get_wiki_list{
	my $self = shift;
	if($self->farm_is_enable){
		my @list = $self->search_child($self->config('config_dir'));
		return @list;
	} else {
		return ();
	}
}

#==============================================================================
# <p>
# WikiΥĥ꡼Ǽޤ
# ͥȤWikiե󥹤ǳǼޤ
# </p>
#==============================================================================
sub search_child {
	my $self = shift;
	my $dir  = shift;
	my @dirs = ();
	my @list = ();
	
	opendir(DIR,$dir) or die $!;
	while(my $entry = readdir(DIR)){
		if(-d "$dir/$entry" && $entry ne "." && $entry ne ".."){
			push(@dirs,$entry);
		}
	}
	closedir(DIR);
	@dirs = sort @dirs;
	
	foreach my $entry (@dirs){
		push(@list,$entry);
		my @child = $self->search_child("$dir/$entry");
		if($#child>-1){
			push(@list,\@child);
		}
	}
	
	return @list;
}

#==============================================================================
# <p>
# λν
# </p>
#==============================================================================
sub _process_before_exit {
	my $self = shift;
	# ץ饰ѤΥեå
	$self->do_hook('finalize');
	# finalize᥽åɤθƤӽФ
	$self->get_CGI()->finalize();
	$self->{storage}->finalize();
}

1;
