class HistologiesController < ApplicationController
  # GET /histologies
  # GET /histologies.json
  def index
    @histologies = Histology.all

    respond_to do |format|
      format.html # index.html.erb
      format.json { render json: @histologies }
    end
  end

  # GET /histologies/1
  # GET /histologies/1.json
  def show
    @histology = Histology.find(params[:id])
 
    respond_to do |format|
      format.html # show.html.erb
      format.json { render json: @histology }
    end
  end

  # GET /histologies/new
  # GET /histologies/new.json
  def new
    @histology = Histology.new
    @histology.number = current_number
    
    respond_to do |format|
      format.html # new.html.erb
      format.json { render json: @histology }
    end
  end

  # GET /histologies/1/edit
  def edit
    @histology = Histology.find(params[:id])
  end

  # POST /histologies
  # POST /histologies.json
  def create
    @histology = Histology.new(params[:histology])

    respond_to do |format|
      if @histology.save
        @histology.reports.create(:histology=>@histology, :locked=>false, :revision=>1)
        format.html { redirect_to :action=> "new"}
        format.json { render json: @histology, status: :created, location: @histology }
      else
        format.html { render action: "new" }
        format.json { render json: @histology.errors, status: :unprocessable_entity }
      end
    end
  end

  # PUT /histologies/1
  # PUT /histologies/1.json
  def update
    @histology = Histology.find(params[:id])

    respond_to do |format|
      if @histology.update_attributes(params[:histology])
        format.html { redirect_to @histology, notice: 'Histology was successfully updated.' }
        format.json { head :no_content }
      else
        format.html { render action: "edit" }
        format.json { render json: @histology.errors, status: :unprocessable_entity }
      end
    end
  end

  # DELETE /histologies/1
  # DELETE /histologies/1.json
  def destroy
    @histology = Histology.find(params[:id])
    @histology.destroy

    respond_to do |format|
      format.html { redirect_to histologies_url }
      format.json { head :no_content }
    end
  end
  
  
  private

  def current_number
    year = Time.now.year * 100000
    year + Histology.where("number >= ?", year).count + 1
  end
end
