class ApplicationController < ActionController::Base
  protect_from_forgery
  before_filter :authorize
  
  private
    def authorize
      unless User.find_by_id(session[:user_id])
        redirect_to login_url, notice: "Please login"
      end
    end
end
