package net.tk_factory.sample.jfreechart;

import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Random;

import net.tk_factory.sample.AbstractSample;

import org.apache.log4j.Logger;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.ChartUtilities;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.StandardChartTheme;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.data.time.Day;
import org.jfree.data.time.Hour;
import org.jfree.data.time.TimeSeries;
import org.jfree.data.time.TimeSeriesCollection;

/**
 * JFreeChartѤץץǤ<br/>
 * <br/>
 * <b></b>
 * <ol type="1">
 * <li>աʻˤޤ</li>
 * <li>ChartUtilities饹ѤơPNGǲϤޤ</li>
 * </ol>
 *
 * @author Takafumi Kondo (TK Factory)
 *
 * @see org.jfree.chart.ChartFactory#createXYBarChart
 * @see org.jfree.chart.StandardChartTheme#createLegacyTheme
 */
public class SampleCreateXYBarChart extends AbstractSample
{
    /** 饹̾ */
    private static final String CLASS_NAME =
        SampleCreateXYBarChart.class.getSimpleName();

    /**  */
    private static final Logger LOGGER =
        Logger.getLogger(SampleCreateXYBarChart.class.getName());

    /** ϥե̾PNG */
    private static final String OUT_FILE_NAME_PNG =
        SAMPLE_FILE_DIRECTORY +  CLASS_NAME + ".png";

    /**
     * SampleCreateXYBarChart֥Ȥۤȡ
     * UnsupportedOperationExceptionޤ<br/>
     */
    protected SampleCreateXYBarChart()
    {
        throw new UnsupportedOperationException();
    }

    /**
     * main᥽åɤǤ<br/>
     *
     * @param args 
     */
    public static void main(String[] args)
    {
        LOGGER.info("[START]" + CLASS_NAME);

        FileOutputStream png = null;

        try
        {
            //Ǥ˽ϥե뤬¸ߤƤϺ
            deleteExistsFile(OUT_FILE_NAME_PNG);

            //쥬ơޤꤹ
            ChartFactory.setChartTheme(StandardChartTheme.createLegacyTheme());

            //աʻˤΥǡꤹ
            TimeSeriesCollection dataset = new TimeSeriesCollection();
            Random rand = new Random();
            TimeSeries series = new TimeSeries("", Hour.class);
            Day day = new Day(1, 1, 2009);
            for (int i = 0; i < 24; i++)
            {
                series.add(new Hour(i, day), rand.nextInt(20));
            }
            dataset.addSeries(series);

            //աʻˤ
            JFreeChart chart = ChartFactory.createXYBarChart(
                    //եȥ
                    "̥",
                    //ƥ꼴٥
                    "",
                    //ΰ輴ɽ
                    true,
                    //ͼ٥
                    "",
                    //ǡå
                    dataset,
                    //դν
                    PlotOrientation.VERTICAL,
                    //Ƚɽ̵ͭ
                    true,
                    //ġåפɽ̵ͭ
                    false,
                    //URLưŪ̵ͭ
                    false);

            //PNGǥե¸
            png = new FileOutputStream(OUT_FILE_NAME_PNG);
            ChartUtilities.writeChartAsPNG(png, chart, 600, 400);
        }
        catch (IOException ioex)
        {
            LOGGER.error(getStackTrace(ioex));
        }
        finally
        {
            try
            {
                if (png != null)
                {
                    png.close();
                }
            }
            catch (IOException ioex)
            {
                LOGGER.error(getStackTrace(ioex));
            }

            LOGGER.info("[E N D]" + CLASS_NAME);
        }
    }
}
