package net.tk_factory.sample.jfreechart;

import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Calendar;
import java.util.Date;

import net.tk_factory.sample.AbstractSample;

import org.apache.log4j.Logger;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.ChartUtilities;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.StandardChartTheme;
import org.jfree.data.xy.DefaultWindDataset;
import org.jfree.data.xy.WindDataset;

/**
 * JFreeChartѤץץǤ<br/>
 * <br/>
 * <b></b>
 * <ol type="1">
 * <li>ɥ㡼Ȥޤ</li>
 * <li>ChartUtilities饹ѤơPNGǲϤޤ</li>
 * </ol>
 *
 * @author Takafumi Kondo (TK Factory)
 *
 * @see org.jfree.chart.ChartFactory#createWindPlot
 * @see org.jfree.chart.StandardChartTheme#createLegacyTheme
 */
public class SampleCreateWindPlot extends AbstractSample
{
    /** 饹̾ */
    private static final String CLASS_NAME =
        SampleCreateWindPlot.class.getSimpleName();

    /**  */
    private static final Logger LOGGER =
        Logger.getLogger(SampleCreateWindPlot.class.getName());

    /** ϥե̾PNG */
    private static final String OUT_FILE_NAME_PNG =
        SAMPLE_FILE_DIRECTORY +  CLASS_NAME + ".png";

    /**
     * SampleCreateWindPlot֥Ȥۤȡ
     * UnsupportedOperationExceptionޤ<br/>
     */
    protected SampleCreateWindPlot()
    {
        throw new UnsupportedOperationException();
    }

    /**
     * main᥽åɤǤ<br/>
     *
     * @param args 
     */
    public static void main(String[] args)
    {
        LOGGER.info("[START]" + CLASS_NAME);

        FileOutputStream png = null;

        try
        {
            //Ǥ˽ϥե뤬¸ߤƤϺ
            deleteExistsFile(OUT_FILE_NAME_PNG);

            //쥬ơޤꤹ
            ChartFactory.setChartTheme(StandardChartTheme.createLegacyTheme());

            //ɥ㡼ȤΥǡꤹ
            String[] seriesNames =
            {
                "¬",
            };
            Object[][] seriesData = new Object[][]
            {
                createItem(getTimeInMillis(2009, Calendar.JANUARY, 1), 0, 10),
                createItem(getTimeInMillis(2009, Calendar.JANUARY, 2), 1, 8),
                createItem(getTimeInMillis(2009, Calendar.JANUARY, 3), 2, 10),
                createItem(getTimeInMillis(2009, Calendar.JANUARY, 4), 3, 10),
                createItem(getTimeInMillis(2009, Calendar.JANUARY, 5), 4, 7),
                createItem(getTimeInMillis(2009, Calendar.JANUARY, 6), 5, 10),
                createItem(getTimeInMillis(2009, Calendar.JANUARY, 7), 6, 8),
                createItem(getTimeInMillis(2009, Calendar.JANUARY, 8), 7, 11),
                createItem(getTimeInMillis(2009, Calendar.JANUARY, 9), 8, 10),
                createItem(getTimeInMillis(2009, Calendar.JANUARY, 10), 9, 11),
            };
            Object[][][] data =
            {
                seriesData,
            };
            WindDataset dataset = new DefaultWindDataset(seriesNames, data);

            //ɥ㡼Ȥ
            JFreeChart chart = ChartFactory.createWindPlot(
                    //եȥ
                    "",
                    //ƥ꼴٥
                    "",
                    //ͼ٥
                    "",
                    //ǡå
                    dataset,
                    //Ƚɽ̵ͭ
                    true,
                    //ġåפɽ̵ͭ
                    false,
                    //URLưŪ̵ͭ
                    false);

            //PNGǥե¸
            png = new FileOutputStream(OUT_FILE_NAME_PNG);
            ChartUtilities.writeChartAsPNG(png, chart, 600, 400);
        }
        catch (IOException ioex)
        {
            LOGGER.error(getStackTrace(ioex));
        }
        finally
        {
            try
            {
                if (png != null)
                {
                    png.close();
                }
            }
            catch (IOException ioex)
            {
                LOGGER.error(getStackTrace(ioex));
            }

            LOGGER.info("[E N D]" + CLASS_NAME);
        }
    }

    /**
     * ꤵ줿ǯUTCߥͤޤ<br/>
     *
     * @param year ǯ
     * @param month 
     * @param day 
     * @return UTCߥ
     */
    private static long getTimeInMillis(int year, int month, int day)
    {
        Calendar calendar = Calendar.getInstance();
        calendar.set(year, month, day, 12, 0);
        return calendar.getTimeInMillis();
    }

    /**
     * ꤵ줿UTCߥ͡Ϥ򥦥ɥ㡼Ȥɽ
     * ǡѴޤ<br/>
     *
     * @param millis UTCߥ
     * @param dir 
     * @param force 
     * @return
     */
    private static Object[] createItem(long millis, int dir, int force)
    {
        Object[] object =
        {
            new Date(millis),
            new Integer(dir),
            new Integer(force),
        };
        return object;
    }
}
