package net.tk_factory.sample.jfreechart;

import java.io.FileOutputStream;
import java.io.IOException;

import net.tk_factory.sample.AbstractSample;

import org.apache.log4j.Logger;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.ChartUtilities;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.StandardChartTheme;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.data.category.DefaultCategoryDataset;

/**
 * JFreeChartѤץץǤ<br/>
 * <br/>
 * <b></b>
 * <ol type="1">
 * <li>ޤաʣġˤޤ</li>
 * <li>ChartUtilities饹ѤơPNGǲϤޤ</li>
 * </ol>
 *
 * @author Takafumi Kondo (TK Factory)
 *
 * @see org.jfree.chart.ChartFactory#createLineChart3D
 * @see org.jfree.chart.StandardChartTheme#createLegacyTheme
 */
public class SampleCreateLineChart3D extends AbstractSample
{
    /** 饹̾ */
    private static final String CLASS_NAME =
        SampleCreateLineChart3D.class.getSimpleName();

    /**  */
    private static final Logger LOGGER =
        Logger.getLogger(SampleCreateLineChart3D.class.getName());

    /** ϥե̾PNG */
    private static final String OUT_FILE_NAME_PNG =
        SAMPLE_FILE_DIRECTORY +  CLASS_NAME + ".png";

    /**
     * SampleCreateBarChart3D֥Ȥۤȡ
     * UnsupportedOperationExceptionޤ<br/>
     */
    protected SampleCreateLineChart3D()
    {
        throw new UnsupportedOperationException();
    }

    /**
     * main᥽åɤǤ<br/>
     *
     * @param args 
     */
    public static void main(String[] args)
    {
        LOGGER.info("[START]" + CLASS_NAME);

        FileOutputStream png = null;

        try
        {
            //Ǥ˽ϥե뤬¸ߤƤϺ
            deleteExistsFile(OUT_FILE_NAME_PNG);

            //쥬ơޤꤹ
            ChartFactory.setChartTheme(StandardChartTheme.createLegacyTheme());

            //ޤդΥǡꤹ
            DefaultCategoryDataset dataset = new DefaultCategoryDataset();
            //
            dataset.addValue(14.3, "ٻ", "");
            dataset.addValue(70.1, "ɤǤʤ", "");
            dataset.addValue(15.6, "ٻʤ", "");
            //20
            dataset.addValue(10.7, "ٻ", "20");
            dataset.addValue(68.0, "ɤǤʤ", "20");
            dataset.addValue(21.3, "ٻʤ", "20");
            //30
            dataset.addValue(11.6, "ٻ", "30");
            dataset.addValue(69.7, "ɤǤʤ", "30");
            dataset.addValue(18.7, "ٻʤ", "30");
            //40
            dataset.addValue(15.1, "ٻ", "40");
            dataset.addValue(71.7, "ɤǤʤ", "40");
            dataset.addValue(13.2, "ٻʤ", "40");
            //50
            dataset.addValue(14.6, "ٻ", "50");
            dataset.addValue(72.4, "ɤǤʤ", "50");
            dataset.addValue(13.0, "ٻʤ", "50");
            //60ʾ
            dataset.addValue(24.6, "ٻ", "60ʾ");
            dataset.addValue(68.5, "ɤǤʤ", "60ʾ");
            dataset.addValue(6.9, "ٻʤ", "60ʾ");

            //ޤդ
            JFreeChart chart = ChartFactory.createLineChart3D(
                    //եȥ
                    "ջٻΨ",
                    //ƥ꼴٥
                    "ǯ",
                    //ͼ٥
                    "ٻΨ",
                    //ǡå
                    dataset,
                    //դν
                    PlotOrientation.VERTICAL,
                    //Ƚɽ̵ͭ
                    true,
                    //ġåפɽ̵ͭ
                    false,
                    //URLưŪ̵ͭ
                    false);

            //PNGǥե¸
            png = new FileOutputStream(OUT_FILE_NAME_PNG);
            ChartUtilities.writeChartAsPNG(png, chart, 600, 400);
        }
        catch (IOException ioex)
        {
            LOGGER.error(getStackTrace(ioex));
        }
        finally
        {
            try
            {
                if (png != null)
                {
                    png.close();
                }
            }
            catch (IOException ioex)
            {
                LOGGER.error(getStackTrace(ioex));
            }

            LOGGER.info("[E N D]" + CLASS_NAME);
        }
    }
}
