package net.tk_factory.sample.jfreechart;

import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Calendar;
import java.util.Date;

import net.tk_factory.sample.AbstractSample;

import org.apache.log4j.Logger;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.ChartUtilities;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.StandardChartTheme;
import org.jfree.data.gantt.Task;
import org.jfree.data.gantt.TaskSeries;
import org.jfree.data.gantt.TaskSeriesCollection;
import org.jfree.data.time.SimpleTimePeriod;

/**
 * JFreeChartѤץץǤ<br/>
 * <br/>
 * <b></b>
 * <ol type="1">
 * <li>ȥ㡼Ȥޤ</li>
 * <li>ChartUtilities饹ѤơPNGǲϤޤ</li>
 * </ol>
 *
 * @author Takafumi Kondo (TK Factory)
 *
 * @see org.jfree.chart.ChartFactory#createGanttChart
 * @see org.jfree.chart.StandardChartTheme#createLegacyTheme
 */
public class SampleCreateGanttChart extends AbstractSample
{
    /** 饹̾ */
    private static final String CLASS_NAME =
        SampleCreateGanttChart.class.getSimpleName();

    /**  */
    private static final Logger LOGGER =
        Logger.getLogger(SampleCreateGanttChart.class.getName());

    /** ϥե̾PNG */
    private static final String OUT_FILE_NAME_PNG =
        SAMPLE_FILE_DIRECTORY +  CLASS_NAME + ".png";

    /**
     * SampleCreateGanttChart֥Ȥۤȡ
     * UnsupportedOperationExceptionޤ<br/>
     */
    protected SampleCreateGanttChart()
    {
        throw new UnsupportedOperationException();
    }

    /**
     * main᥽åɤǤ<br/>
     *
     * @param args 
     */
    public static void main(String[] args)
    {
        LOGGER.info("[START]" + CLASS_NAME);

        FileOutputStream png = null;

        try
        {
            //Ǥ˽ϥե뤬¸ߤƤϺ
            deleteExistsFile(OUT_FILE_NAME_PNG);

            //쥬ơޤꤹ
            ChartFactory.setChartTheme(StandardChartTheme.createLegacyTheme());

            Task task;
            SimpleTimePeriod sp;

            //ȥ㡼ȤΥǡꤹ
            TaskSeriesCollection collection = new TaskSeriesCollection();
            TaskSeries series1 = new TaskSeries("ͽ");
            sp = new SimpleTimePeriod(
                    convert2date(2009, Calendar.APRIL, 1),
                    convert2date(2009, Calendar.APRIL, 30));
            task = new Task("߷", sp);
            series1.add(task);
            sp = new SimpleTimePeriod(
                    convert2date(2009, Calendar.MAY, 1),
                    convert2date(2009, Calendar.JULY, 31));
            task = new Task("ȯ", sp);
            series1.add(task);
            sp = new SimpleTimePeriod(
                    convert2date(2009, Calendar.AUGUST, 1),
                    convert2date(2009, Calendar.SEPTEMBER, 30));
            task = new Task("ƥ", sp);
            series1.add(task);
            collection.add(series1);

            TaskSeries series2 = new TaskSeries("");
            sp = new SimpleTimePeriod(
                    convert2date(2009, Calendar.APRIL, 1),
                    convert2date(2009, Calendar.APRIL, 20));
            task = new Task("߷", sp);
            series2.add(task);
            sp = new SimpleTimePeriod(
                    convert2date(2009, Calendar.APRIL, 21),
                    convert2date(2009, Calendar.JULY, 20));
            task = new Task("ȯ", sp);
            series2.add(task);
            sp = new SimpleTimePeriod(
                    convert2date(2009, Calendar.JULY, 21),
                    convert2date(2009, Calendar.SEPTEMBER, 15));
            task = new Task("ƥ", sp);
            series2.add(task);
            collection.add(series2);

            //ȥ㡼Ȥ
            JFreeChart chart = ChartFactory.createGanttChart(
                    //եȥ
                    "ȯ塼",
                    //ƥ꼴٥
                    "ե",
                    //ͼ٥
                    "",
                    //ǡå
                    collection,
                    //Ƚɽ̵ͭ
                    true,
                    //ġåפɽ̵ͭ
                    false,
                    //URLưŪ̵ͭ
                    false);

            //PNGǥե¸
            png = new FileOutputStream(OUT_FILE_NAME_PNG);
            ChartUtilities.writeChartAsPNG(png, chart, 600, 400);
        }
        catch (IOException ioex)
        {
            LOGGER.error(getStackTrace(ioex));
        }
        finally
        {
            try
            {
                if (png != null)
                {
                    png.close();
                }
            }
            catch (IOException ioex)
            {
                LOGGER.error(getStackTrace(ioex));
            }

            LOGGER.info("[E N D]" + CLASS_NAME);
        }
    }

    /**
     * շѴޤ<br/>
     *
     * @param year ǯ
     * @param month 
     * @param day 
     * @return 
     */
    private static Date convert2date(int year, int month, int day)
    {
        Calendar calendar = Calendar.getInstance();
        calendar.set(year, month, day);
        Date result = calendar.getTime();
        return result;
    }
}
