package net.tk_factory.sample.apache.poi.workbook;

import java.io.FileInputStream;
import java.io.IOException;
import net.tk_factory.sample.AbstractSample;
import org.apache.log4j.Logger;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.poifs.filesystem.POIFSFileSystem;

/**
 * Apache POI-HSSFѤץץǤ<br/>
 * <br/>
 * <b></b>
 * <ol type="1">
 * <li>HSSFWorkbook饹Ѥơ¸Υ֥å򳫤ޤ</li>
 * </ol>
 * @author Takafumi Kondo (TK Factory)
 * @see org.apache.poi.hssf.usermodel.HSSFWorkbook
 * @see org.apache.poi.poifs.filesystem.POIFSFileSystem
 */
public class SampleOpenWorkbook extends AbstractSample
{
    /** 饹̾ */
    private static final String CLASS_NAME =
        SampleOpenWorkbook.class.getSimpleName();

    /**  */
    private static final Logger LOGGER =
        Logger.getLogger(SampleOpenWorkbook.class.getName());

    /** ϥե̾ */
    private static final String IN_FILE_NAME =
        SAMPLE_FILE_DIRECTORY + CLASS_NAME + "In.xls";

    /**
     * SampleOpenWorkbook֥Ȥۤȡ
     * UnsupportedOperationExceptionޤ<br/>
     */
    protected SampleOpenWorkbook()
    {
        throw new UnsupportedOperationException();
    }

    /**
     * main᥽åɤǤ<br/>
     *
     * @param args 
     */
    public static void main(String[] args)
    {
        LOGGER.info("[START]" + CLASS_NAME);

        FileInputStream in = null;

        try
        {
            //ϥե뤬¸ߤƤ뤫å
            checkExistsFile(IN_FILE_NAME);

            //եɹ
            in = new FileInputStream(IN_FILE_NAME);
            POIFSFileSystem fs = new POIFSFileSystem(in);
            HSSFWorkbook workbook = new HSSFWorkbook(fs);
            LOGGER.debug(workbook.toString());
        }
        catch (IOException ioex)
        {
            LOGGER.error(getStackTrace(ioex));
        }
        finally
        {
            try
            {
                if (in != null)
                {
                    in.close();
                }
            }
            catch (IOException ioex)
            {
                LOGGER.error(getStackTrace(ioex));
            }

            LOGGER.info("[E N D]" + CLASS_NAME);
        }
    }
}
