package net.tk_factory.sample.apache.poi.row;

import java.io.FileOutputStream;
import java.io.IOException;
import net.tk_factory.sample.AbstractSample;
import org.apache.log4j.Logger;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;

/**
 * Apache POI-HSSFѤץץǤ<br/>
 * <br/>
 * <b></b>
 * <ol type="1">
 * <li>HSSFSheet饹setDefaultRowHeight᥽åɤѤơǥեȤιԤι⤵ꤷޤ</li>
 * </ol>
 * @author Takafumi Kondo (TK Factory)
 * @see org.apache.poi.hssf.usermodel.HSSFSheet#setDefaultRowHeight(short)
 */
public class SampleSetDefaultRowHeight extends AbstractSample
{
    /** 饹̾ */
    private static final String CLASS_NAME =
        SampleSetDefaultRowHeight.class.getSimpleName();

    /**  */
    private static final Logger LOGGER =
        Logger.getLogger(SampleSetDefaultRowHeight.class.getName());

    /** ϥե̾ */
    private static final String OUT_FILE_NAME =
        SAMPLE_FILE_DIRECTORY + CLASS_NAME + "Out.xls";

    /**
     * SampleSetDefaultRowHeight֥Ȥۤȡ
     * UnsupportedOperationExceptionޤ<br/>
     */
    protected SampleSetDefaultRowHeight()
    {
        throw new UnsupportedOperationException();
    }

    /**
     * main᥽åɤǤ<br/>
     *
     * @param args 
     */
    public static void main(String[] args)
    {
        FileOutputStream out = null;

        try
        {
            //Ǥ˽ϥե뤬¸ߤƤϺ
            deleteExistsFile(OUT_FILE_NAME);

            //֥å
            HSSFWorkbook workbook = new HSSFWorkbook();

            //Ȥɲä
            HSSFSheet sheet = workbook.createSheet();
            LOGGER.debug(sheet.toString());

            //ǥեȤι⤵ꤹ
            //⤵1ꤹ1/20ݥȤˤʤ
            //⤵1ꤹ1/20ݥȤˤʤꡢ
            //1ݥȤ1/72
            //εǽͭˤʤäƤʤ褦Ǥ
            sheet.setDefaultRowHeight((short)100);

            //ե¸
            out = new FileOutputStream(OUT_FILE_NAME);
            workbook.write(out);
        }
        catch (IOException ioex)
        {
            LOGGER.error(getStackTrace(ioex));
        }
        finally
        {
            try
            {
                if (out != null)
                {
                    out.close();
                }
            }
            catch (IOException ioex)
            {
                LOGGER.error(getStackTrace(ioex));
            }
        }
    }
}
