package net.tk_factory.sample.apache.commons.lang;

import org.apache.commons.lang.math.NumberUtils;

import junit.framework.TestCase;

/**
 * Apache Commons LangѤץץǤ<br/>
 *
 * @author Takafumi Kondo (TK Factory)
 * @see org.apache.commons.lang.NumberUtils
 */
public class TestNumberUtils extends TestCase
{

    /**
     *  @see org.apache.commons.lang.math.NumberUtils#toInt(String)
     */
    public void testToInt1()
    {
        assertEquals(
                NumberUtils.toInt(null),
                0);
        assertEquals(
                NumberUtils.toInt(""),
                0);
        assertEquals(
                NumberUtils.toInt("1"),
                1);
    }

    /**
     *  @see org.apache.commons.lang.math.NumberUtils#toInt(String, int)
     */
    public void testToInt2()
    {
        assertEquals(
                NumberUtils.toInt(null, 1),
                1);
        assertEquals(
                NumberUtils.toInt("", 1),
                1);
        assertEquals(
                NumberUtils.toInt("1", 0),
                1);
    }

    /**
     *  @see org.apache.commons.lang.math.NumberUtils#toLong(String)
     */
    public void testToLong1()
    {
        assertEquals(
                NumberUtils.toLong(null),
                0L);
        assertEquals(
                NumberUtils.toLong(""),
                0L);
        assertEquals(
                NumberUtils.toLong("1"),
                1L);
    }

    /**
     *  @see org.apache.commons.lang.math.NumberUtils#toLong(String, long)
     */
    public void testToLong2()
    {
        assertEquals(
                NumberUtils.toLong(null, 1L),
                1L);
        assertEquals(
                NumberUtils.toLong("", 1L),
                1L);
        assertEquals(
                NumberUtils.toLong("1", 0L),
                1L);
    }

    /**
     *  @see org.apache.commons.lang.math.NumberUtils#toFloat(String)
     */
    public void testToFloat1()
    {
        assertEquals(
                NumberUtils.toFloat(null),
                0.0f);
        assertEquals(
                NumberUtils.toFloat(""),
                0.0f);
        assertEquals(
                NumberUtils.toFloat("1.5"),
                1.5f);
    }

    /**
     *  @see org.apache.commons.lang.math.NumberUtils#toFloat(String, float)
     */
    public void testToFloat2()
    {
        assertEquals(
                NumberUtils.toFloat(null, 1.1f),
                1.1f);
        assertEquals(
                NumberUtils.toFloat("", 1.1f),
                1.1f);
        assertEquals(
                NumberUtils.toFloat("1.5", 0.0f),
                1.5f);
    }

    /**
     *  @see org.apache.commons.lang.math.NumberUtils#toDouble(String)
     */
    public void testToDouble1()
    {
        assertEquals(
                NumberUtils.toDouble(null),
                0.0d);
        assertEquals(
                NumberUtils.toDouble(""),
                0.0d);
        assertEquals(
                NumberUtils.toDouble("1.5"),
                1.5d);
    }

    /**
     *  @see org.apache.commons.lang.math.NumberUtils#toDouble(String, double)
     */
    public void testToDouble2()
    {
        assertEquals(
                NumberUtils.toDouble(null, 1.1d),
                1.1d);
        assertEquals(
                NumberUtils.toDouble("", 1.1d),
                1.1d);
        assertEquals(
                NumberUtils.toDouble("1.5", 0.0d),
                1.5d);
    }

}
