package net.tk_factory.sample;

import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ResourceBundle;

/**
 * ץץΥѡ饹Ǥ<br/>
 * ƤΥץץϡΥ饹Ѿƺޤ<br/>
 *
 * @author Takafumi Kondo (TK Factory)
 */
public abstract class AbstractSample
{
    /** եѥǥ쥯ȥ */
    protected static final String SAMPLE_FILE_DIRECTORY =
        ResourceBundle.getBundle("Sample").getString("SAMPLE_FILE_DIRECTORY");

    /**
     * AbstractSample֥Ȥۤȡ
     * UnsupportedOperationExceptionޤ<br/>
     */
    protected AbstractSample()
    {
        throw new UnsupportedOperationException();
    }

    /**
     * 㳰Υåȥ졼ʸѴޤ<br/>
     *
     * @param ex 㳰
     * @return åȥ졼
     */
    protected static String getStackTrace(Throwable ex)
    {
        StringWriter sw = new StringWriter();
        ex.printStackTrace(new PrintWriter(sw));
        String detail = sw.toString();
        try
        {
            sw.close();
        }
        catch (IOException e)
        {
            // 㳰ȯƤ³Ԥ
        }
        return detail;
    }

    /**
     * ե뤬¸ߤ뤫ɤå
     * ¸ߤϥեޤ<br/>
     *
     * @param name ե̾
     */
    protected static void deleteExistsFile(String name)
    {
        File file = new File(name);
        if (file.exists())
        {
            file.delete();
        }
    }

    /**
     * ե뤬¸ߤ뤫ɤå
     * ¸ߤʤIOException򥹥ޤ<br/>
     *
     * @param name ե̾
     * @throws IOException ꤵ줿ե뤬¸ߤʤ
     */
    protected static void checkExistsFile(String name)
        throws IOException
    {
        File file = new File(name);
        if (!file.exists())
        {
            StringBuffer msg = new StringBuffer();
            msg.append("Not Exists File [")
                .append(name)
                .append("]");
            throw new IOException(msg.toString());
        }
    }
}
