/*
 * Copyright 2009-2011 the Fess Project and the Others.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND,
 * either express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 */

package jp.sf.fess.service;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

import javax.annotation.Resource;

import jp.sf.fess.Constants;
import jp.sf.fess.crud.CrudMessageException;
import jp.sf.fess.crud.service.BsFileCrawlingConfigService;
import jp.sf.fess.db.cbean.FileConfigToBrowserTypeMappingCB;
import jp.sf.fess.db.cbean.FileConfigToLabelTypeMappingCB;
import jp.sf.fess.db.cbean.FileConfigToRoleTypeMappingCB;
import jp.sf.fess.db.cbean.FileCrawlingConfigCB;
import jp.sf.fess.db.exbhv.FileConfigToBrowserTypeMappingBhv;
import jp.sf.fess.db.exbhv.FileConfigToLabelTypeMappingBhv;
import jp.sf.fess.db.exbhv.FileConfigToRoleTypeMappingBhv;
import jp.sf.fess.db.exentity.FileConfigToBrowserTypeMapping;
import jp.sf.fess.db.exentity.FileConfigToLabelTypeMapping;
import jp.sf.fess.db.exentity.FileConfigToRoleTypeMapping;
import jp.sf.fess.db.exentity.FileCrawlingConfig;
import jp.sf.fess.pager.FileCrawlingConfigPager;

import org.seasar.dbflute.bhv.ConditionBeanSetupper;

public class FileCrawlingConfigService extends BsFileCrawlingConfigService
        implements Serializable {

    private static final long serialVersionUID = 1L;

    @Resource
    protected FileConfigToBrowserTypeMappingBhv fileConfigToBrowserTypeMappingBhv;

    @Resource
    protected FileConfigToRoleTypeMappingBhv fileConfigToRoleTypeMappingBhv;

    @Resource
    protected FileConfigToLabelTypeMappingBhv fileConfigToLabelTypeMappingBhv;

    public List<FileCrawlingConfig> getAllFileCrawlingConfigList() {
        return getAllFileCrawlingConfigList(true, true, true, true);
    }

    public List<FileCrawlingConfig> getAllFileCrawlingConfigList(
            boolean withBrowserType, boolean withLabelType,
            boolean withRoleType, boolean available) {
        FileCrawlingConfigCB cb = new FileCrawlingConfigCB();
        cb.query().setDeletedBy_IsNull();
        if (available) {
            cb.query().setAvailable_Equal(Constants.T);
        }
        List<FileCrawlingConfig> list = fileCrawlingConfigBhv.selectList(cb);
        if (withBrowserType) {
            final ConditionBeanSetupper<FileConfigToBrowserTypeMappingCB> setupper1 = new ConditionBeanSetupper<FileConfigToBrowserTypeMappingCB>() {
                public void setup(FileConfigToBrowserTypeMappingCB cb) {
                    cb.setupSelect_BrowserType();
                    cb.query().queryBrowserType().setDeletedBy_IsNull();
                    cb.query().queryBrowserType().addOrderBy_SortOrder_Asc();
                }

            };
            fileCrawlingConfigBhv.loadFileConfigToBrowserTypeMappingList(list,
                    setupper1);
        }
        if (withBrowserType) {
            final ConditionBeanSetupper<FileConfigToRoleTypeMappingCB> setupper2 = new ConditionBeanSetupper<FileConfigToRoleTypeMappingCB>() {
                public void setup(FileConfigToRoleTypeMappingCB cb) {
                    cb.setupSelect_RoleType();
                    cb.query().queryRoleType().setDeletedBy_IsNull();
                    cb.query().queryRoleType().addOrderBy_SortOrder_Asc();
                }

            };
            fileCrawlingConfigBhv.loadFileConfigToRoleTypeMappingList(list,
                    setupper2);
        }
        if (withRoleType) {
            final ConditionBeanSetupper<FileConfigToLabelTypeMappingCB> setupper3 = new ConditionBeanSetupper<FileConfigToLabelTypeMappingCB>() {
                public void setup(FileConfigToLabelTypeMappingCB cb) {
                    cb.setupSelect_LabelType();
                    cb.query().queryLabelType().setDeletedBy_IsNull();
                    cb.query().queryLabelType().addOrderBy_SortOrder_Asc();
                }

            };
            fileCrawlingConfigBhv.loadFileConfigToLabelTypeMappingList(list,
                    setupper3);
        }
        return list;
    }

    public FileCrawlingConfig getFileCrawlingConfig(Map<String, String> keys) {
        FileCrawlingConfig fileCrawlingConfig = super
                .getFileCrawlingConfig(keys);

        if (fileCrawlingConfig != null) {
            FileConfigToBrowserTypeMappingCB fctbtmCb = new FileConfigToBrowserTypeMappingCB();
            fctbtmCb.query().setFileConfigId_Equal(fileCrawlingConfig.getId());
            fctbtmCb.query().queryBrowserType().setDeletedBy_IsNull();
            fctbtmCb.query().queryFileCrawlingConfig().setDeletedBy_IsNull();
            List<FileConfigToBrowserTypeMapping> fctbtmList = fileConfigToBrowserTypeMappingBhv
                    .selectList(fctbtmCb);
            if (!fctbtmList.isEmpty()) {
                List<String> browserTypeIds = new ArrayList<String>(
                        fctbtmList.size());
                for (FileConfigToBrowserTypeMapping mapping : fctbtmList) {
                    browserTypeIds
                            .add(Long.toString(mapping.getBrowserTypeId()));
                }
                fileCrawlingConfig.setBrowserTypeIds(browserTypeIds
                        .toArray(new String[browserTypeIds.size()]));
            }

            FileConfigToRoleTypeMappingCB fctrtmCb = new FileConfigToRoleTypeMappingCB();
            fctrtmCb.query().setFileConfigId_Equal(fileCrawlingConfig.getId());
            fctrtmCb.query().queryRoleType().setDeletedBy_IsNull();
            fctrtmCb.query().queryFileCrawlingConfig().setDeletedBy_IsNull();
            List<FileConfigToRoleTypeMapping> fctrtmList = fileConfigToRoleTypeMappingBhv
                    .selectList(fctrtmCb);
            if (!fctrtmList.isEmpty()) {
                List<String> roleTypeIds = new ArrayList<String>(
                        fctrtmList.size());
                for (FileConfigToRoleTypeMapping mapping : fctrtmList) {
                    roleTypeIds.add(Long.toString(mapping.getRoleTypeId()));
                }
                fileCrawlingConfig.setRoleTypeIds(roleTypeIds
                        .toArray(new String[roleTypeIds.size()]));
            }

            FileConfigToLabelTypeMappingCB fctltmCb = new FileConfigToLabelTypeMappingCB();
            fctltmCb.query().setFileConfigId_Equal(fileCrawlingConfig.getId());
            fctltmCb.query().queryLabelType().setDeletedBy_IsNull();
            fctltmCb.query().queryFileCrawlingConfig().setDeletedBy_IsNull();
            List<FileConfigToLabelTypeMapping> fctltmList = fileConfigToLabelTypeMappingBhv
                    .selectList(fctltmCb);
            if (!fctltmList.isEmpty()) {
                List<String> labelTypeIds = new ArrayList<String>(
                        fctltmList.size());
                for (FileConfigToLabelTypeMapping mapping : fctltmList) {
                    labelTypeIds.add(Long.toString(mapping.getLabelTypeId()));
                }
                fileCrawlingConfig.setLabelTypeIds(labelTypeIds
                        .toArray(new String[labelTypeIds.size()]));
            }

        }

        return fileCrawlingConfig;
    }

    public void store(FileCrawlingConfig fileCrawlingConfig)
            throws CrudMessageException {
        boolean isNew = fileCrawlingConfig.getId() == null;
        String[] browserTypeIds = fileCrawlingConfig.getBrowserTypeIds();
        String[] labelTypeIds = fileCrawlingConfig.getLabelTypeIds();
        String[] roleTypeIds = fileCrawlingConfig.getRoleTypeIds();
        super.store(fileCrawlingConfig);
        Long FileConfigId = fileCrawlingConfig.getId();
        if (isNew) {
            // Insert
            if (browserTypeIds != null) {
                List<FileConfigToBrowserTypeMapping> fctbtmList = new ArrayList<FileConfigToBrowserTypeMapping>();
                for (String browserTypeId : browserTypeIds) {
                    FileConfigToBrowserTypeMapping mapping = new FileConfigToBrowserTypeMapping();
                    mapping.setFileConfigId(FileConfigId);
                    mapping.setBrowserTypeId(Long.parseLong(browserTypeId));
                    fctbtmList.add(mapping);
                }
                fileConfigToBrowserTypeMappingBhv.batchInsert(fctbtmList);
            }
            if (labelTypeIds != null) {
                List<FileConfigToLabelTypeMapping> fctltmList = new ArrayList<FileConfigToLabelTypeMapping>();
                for (String labelTypeId : labelTypeIds) {
                    FileConfigToLabelTypeMapping mapping = new FileConfigToLabelTypeMapping();
                    mapping.setFileConfigId(FileConfigId);
                    mapping.setLabelTypeId(Long.parseLong(labelTypeId));
                    fctltmList.add(mapping);
                }
                fileConfigToLabelTypeMappingBhv.batchInsert(fctltmList);
            }
            if (roleTypeIds != null) {
                List<FileConfigToRoleTypeMapping> fctrtmList = new ArrayList<FileConfigToRoleTypeMapping>();
                for (String roleTypeId : roleTypeIds) {
                    FileConfigToRoleTypeMapping mapping = new FileConfigToRoleTypeMapping();
                    mapping.setFileConfigId(FileConfigId);
                    mapping.setRoleTypeId(Long.parseLong(roleTypeId));
                    fctrtmList.add(mapping);
                }
                fileConfigToRoleTypeMappingBhv.batchInsert(fctrtmList);
            }
        } else {
            // Update
            if (browserTypeIds != null) {
                FileConfigToBrowserTypeMappingCB fctbtmCb = new FileConfigToBrowserTypeMappingCB();
                fctbtmCb.query().setFileConfigId_Equal(FileConfigId);
                List<FileConfigToBrowserTypeMapping> fctbtmList = fileConfigToBrowserTypeMappingBhv
                        .selectList(fctbtmCb);
                List<FileConfigToBrowserTypeMapping> newList = new ArrayList<FileConfigToBrowserTypeMapping>();
                List<FileConfigToBrowserTypeMapping> matchedList = new ArrayList<FileConfigToBrowserTypeMapping>();
                for (String id : browserTypeIds) {
                    Long browserTypeId = Long.parseLong(id);
                    boolean exist = false;
                    for (FileConfigToBrowserTypeMapping mapping : fctbtmList) {
                        if (mapping.getBrowserTypeId().equals(browserTypeId)) {
                            exist = true;
                            matchedList.add(mapping);
                            break;
                        }
                    }
                    if (!exist) {
                        // new
                        FileConfigToBrowserTypeMapping mapping = new FileConfigToBrowserTypeMapping();
                        mapping.setFileConfigId(FileConfigId);
                        mapping.setBrowserTypeId(Long.parseLong(id));
                        newList.add(mapping);
                    }
                }
                fctbtmList.removeAll(matchedList);
                fileConfigToBrowserTypeMappingBhv.batchInsert(newList);
                fileConfigToBrowserTypeMappingBhv.batchDelete(fctbtmList);
            }
            if (labelTypeIds != null) {
                FileConfigToLabelTypeMappingCB fctltmCb = new FileConfigToLabelTypeMappingCB();
                fctltmCb.query().setFileConfigId_Equal(FileConfigId);
                List<FileConfigToLabelTypeMapping> fctltmList = fileConfigToLabelTypeMappingBhv
                        .selectList(fctltmCb);
                List<FileConfigToLabelTypeMapping> newList = new ArrayList<FileConfigToLabelTypeMapping>();
                List<FileConfigToLabelTypeMapping> matchedList = new ArrayList<FileConfigToLabelTypeMapping>();
                for (String id : labelTypeIds) {
                    Long labelTypeId = Long.parseLong(id);
                    boolean exist = false;
                    for (FileConfigToLabelTypeMapping mapping : fctltmList) {
                        if (mapping.getLabelTypeId().equals(labelTypeId)) {
                            exist = true;
                            matchedList.add(mapping);
                            break;
                        }
                    }
                    if (!exist) {
                        // new
                        FileConfigToLabelTypeMapping mapping = new FileConfigToLabelTypeMapping();
                        mapping.setFileConfigId(FileConfigId);
                        mapping.setLabelTypeId(Long.parseLong(id));
                        newList.add(mapping);
                    }
                }
                fctltmList.removeAll(matchedList);
                fileConfigToLabelTypeMappingBhv.batchInsert(newList);
                fileConfigToLabelTypeMappingBhv.batchDelete(fctltmList);
            }
            if (roleTypeIds != null) {
                FileConfigToRoleTypeMappingCB fctrtmCb = new FileConfigToRoleTypeMappingCB();
                fctrtmCb.query().setFileConfigId_Equal(FileConfigId);
                List<FileConfigToRoleTypeMapping> fctrtmList = fileConfigToRoleTypeMappingBhv
                        .selectList(fctrtmCb);
                List<FileConfigToRoleTypeMapping> newList = new ArrayList<FileConfigToRoleTypeMapping>();
                List<FileConfigToRoleTypeMapping> matchedList = new ArrayList<FileConfigToRoleTypeMapping>();
                for (String id : roleTypeIds) {
                    Long roleTypeId = Long.parseLong(id);
                    boolean exist = false;
                    for (FileConfigToRoleTypeMapping mapping : fctrtmList) {
                        if (mapping.getRoleTypeId().equals(roleTypeId)) {
                            exist = true;
                            matchedList.add(mapping);
                            break;
                        }
                    }
                    if (!exist) {
                        // new
                        FileConfigToRoleTypeMapping mapping = new FileConfigToRoleTypeMapping();
                        mapping.setFileConfigId(FileConfigId);
                        mapping.setRoleTypeId(Long.parseLong(id));
                        newList.add(mapping);
                    }
                }
                fctrtmList.removeAll(matchedList);
                fileConfigToRoleTypeMappingBhv.batchInsert(newList);
                fileConfigToRoleTypeMappingBhv.batchDelete(fctrtmList);
            }
        }
    }

    protected void setupListCondition(FileCrawlingConfigCB cb,
            FileCrawlingConfigPager fileCrawlingConfigPager) {
        super.setupListCondition(cb, fileCrawlingConfigPager);

        // setup condition
        cb.query().setDeletedBy_IsNull();
        cb.query().addOrderBy_SortOrder_Asc();

        // search

    }

    protected void setupEntityCondition(FileCrawlingConfigCB cb,
            Map<String, String> keys) {
        super.setupEntityCondition(cb, keys);

        // setup condition
        cb.query().setDeletedBy_IsNull();

    }

    protected void setupStoreCondition(FileCrawlingConfig fileCrawlingConfig) {
        super.setupStoreCondition(fileCrawlingConfig);

        // setup condition

    }

    protected void setupDeleteCondition(FileCrawlingConfig fileCrawlingConfig) {
        super.setupDeleteCondition(fileCrawlingConfig);

        // setup condition

    }

}
