/*
 * Copyright 2009-2009 the Fess Project and the Others.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND,
 * either express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 */
package jp.sf.fess.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;

import org.apache.solr.client.solrj.response.QueryResponse;
import org.apache.solr.common.SolrDocumentList;

public class QueryResponseList<E> implements List<E> {
    private List<E> parent;

    /** The value of current page number. */
    protected int pageSize;

    /** The value of current page number. */
    protected int currentPageNumber;

    protected long allRecordCount;

    protected int allPageCount;

    protected boolean existNextPage;

    protected boolean existPrevPage;

    protected long currentStartRecordNumber;

    protected long currentEndRecordNumber;

    protected List<String> pageNumberList;

    // for testing
    protected QueryResponseList(List<E> parent) {
        this.parent = parent;
    }

    public QueryResponseList(QueryResponse queryResponse, Class<E> type,
            int pageSize) {
        this.parent = queryResponse.getBeans(type);
        SolrDocumentList sdList = queryResponse.getResults();

        calculatePageInfo(sdList.getStart(), pageSize, sdList.getNumFound());
    }

    protected void calculatePageInfo(long start, int size, long numFound) {
        pageSize = size;
        allRecordCount = numFound;
        allPageCount = (int) ((allRecordCount - 1) / (long) pageSize) + 1;
        existPrevPage = start > 0;
        existNextPage = start < (long) (allPageCount - 1) * (long) pageSize;
        currentPageNumber = (int) (start / (long) pageSize) + 1;
        currentStartRecordNumber = numFound != 0 ? (currentPageNumber - 1)
                * pageSize + 1 : 0;
        currentEndRecordNumber = (currentPageNumber) * pageSize;
        currentEndRecordNumber = allRecordCount < currentEndRecordNumber ? allRecordCount
                : currentEndRecordNumber;

        int pageRangeSize = 5;
        int startPageRangeSize = currentPageNumber - pageRangeSize;
        if (startPageRangeSize < 1) {
            startPageRangeSize = 1;
        }
        int endPageRangeSize = currentPageNumber + pageRangeSize;
        if (endPageRangeSize > allPageCount) {
            endPageRangeSize = allPageCount;
        }
        pageNumberList = new ArrayList<String>();
        for (int i = startPageRangeSize; i <= endPageRangeSize; i++) {
            pageNumberList.add(String.valueOf(i));
        }

    }

    public boolean add(E e) {
        return parent.add(e);
    }

    public void add(int index, E element) {
        parent.add(index, element);
    }

    public boolean addAll(Collection<? extends E> c) {
        return parent.addAll(c);
    }

    public boolean addAll(int index, Collection<? extends E> c) {
        return parent.addAll(index, c);
    }

    public void clear() {
        parent.clear();
    }

    public boolean contains(Object o) {
        return parent.contains(o);
    }

    public boolean containsAll(Collection<?> c) {
        return parent.containsAll(c);
    }

    public boolean equals(Object o) {
        return parent.equals(o);
    }

    public E get(int index) {
        return parent.get(index);
    }

    public int hashCode() {
        return parent.hashCode();
    }

    public int indexOf(Object o) {
        return parent.indexOf(o);
    }

    public boolean isEmpty() {
        return parent.isEmpty();
    }

    public Iterator<E> iterator() {
        return parent.iterator();
    }

    public int lastIndexOf(Object o) {
        return parent.lastIndexOf(o);
    }

    public ListIterator<E> listIterator() {
        return parent.listIterator();
    }

    public ListIterator<E> listIterator(int index) {
        return parent.listIterator(index);
    }

    public E remove(int index) {
        return parent.remove(index);
    }

    public boolean remove(Object o) {
        return parent.remove(o);
    }

    public boolean removeAll(Collection<?> c) {
        return parent.removeAll(c);
    }

    public boolean retainAll(Collection<?> c) {
        return parent.retainAll(c);
    }

    public E set(int index, E element) {
        return parent.set(index, element);
    }

    public int size() {
        return parent.size();
    }

    public List<E> subList(int fromIndex, int toIndex) {
        return parent.subList(fromIndex, toIndex);
    }

    public Object[] toArray() {
        return parent.toArray();
    }

    public <T> T[] toArray(T[] a) {
        return parent.toArray(a);
    }

    public int getPageSize() {
        return pageSize;
    }

    public void setPageSize(int pageSize) {
        this.pageSize = pageSize;
    }

    public int getCurrentPageNumber() {
        return currentPageNumber;
    }

    public void setCurrentPageNumber(int currentPageNumber) {
        this.currentPageNumber = currentPageNumber;
    }

    public long getAllRecordCount() {
        return allRecordCount;
    }

    public void setAllRecordCount(long allRecordCount) {
        this.allRecordCount = allRecordCount;
    }

    public int getAllPageCount() {
        return allPageCount;
    }

    public void setAllPageCount(int allPageCount) {
        this.allPageCount = allPageCount;
    }

    public boolean isExistNextPage() {
        return existNextPage;
    }

    public void setExistNextPage(boolean existNextPage) {
        this.existNextPage = existNextPage;
    }

    public boolean isExistPrevPage() {
        return existPrevPage;
    }

    public void setExistPrevPage(boolean existPrevPage) {
        this.existPrevPage = existPrevPage;
    }

    public long getCurrentStartRecordNumber() {
        return currentStartRecordNumber;
    }

    public void setCurrentStartRecordNumber(long currentStartRecordRange) {
        this.currentStartRecordNumber = currentStartRecordRange;
    }

    public long getCurrentEndRecordNumber() {
        return currentEndRecordNumber;
    }

    public void setCurrentEndRecordNumber(long currentEndRecordRange) {
        this.currentEndRecordNumber = currentEndRecordRange;
    }

    public List<String> getPageNumberList() {
        return pageNumberList;
    }

    public void setPageNumberList(List<String> pageNumberList) {
        this.pageNumberList = pageNumberList;
    }

}
