package jp.sf.fess.crud.service;

import java.util.List;
import java.util.Map;

import javax.annotation.Resource;

import jp.sf.fess.crud.CommonConstants;
import jp.sf.fess.crud.CrudMessageException;
import jp.sf.fess.db.cbean.CrawlingSessionCB;
import jp.sf.fess.db.exbhv.CrawlingSessionBhv;
import jp.sf.fess.db.exentity.CrawlingSession;
import jp.sf.fess.pager.CrawlingSessionPager;

import org.seasar.dbflute.cbean.PagingResultBean;
import org.seasar.framework.beans.util.Beans;

public abstract class BsCrawlingSessionService {

    @Resource
    protected CrawlingSessionBhv crawlingSessionBhv;

    public BsCrawlingSessionService() {
        super();
    }

    public List<CrawlingSession> getCrawlingSessionList(
            CrawlingSessionPager crawlingSessionPager) {

        CrawlingSessionCB cb = new CrawlingSessionCB();

        cb.fetchFirst(crawlingSessionPager.getPageSize());
        cb.fetchPage(crawlingSessionPager.getCurrentPageNumber());

        setupListCondition(cb, crawlingSessionPager);

        PagingResultBean<CrawlingSession> crawlingSessionList = crawlingSessionBhv
                .selectPage(cb);

        // update pager
        Beans.copy(crawlingSessionList, crawlingSessionPager).includes(
                CommonConstants.PAGER_CONVERSION_RULE).execute();
        crawlingSessionList.setPageRangeSize(5);
        crawlingSessionPager.setPageNumberList(crawlingSessionList.pageRange()
                .createPageNumberList());

        return crawlingSessionList;
    }

    public CrawlingSession getCrawlingSession(Map<String, String> keys) {
        CrawlingSessionCB cb = new CrawlingSessionCB();

        cb.query().setId_Equal(Long.parseLong(keys.get("id")));
        // TODO Long, Integer, String supported only.

        setupEntityCondition(cb, keys);

        CrawlingSession crawlingSession = crawlingSessionBhv.selectEntity(cb);
        if (crawlingSession == null) {
            // TODO exception?
            return null;
        }

        return crawlingSession;
    }

    public void store(CrawlingSession crawlingSession)
            throws CrudMessageException {
        setupStoreCondition(crawlingSession);

        crawlingSessionBhv.insertOrUpdate(crawlingSession);

    }

    public void delete(CrawlingSession crawlingSession)
            throws CrudMessageException {
        setupDeleteCondition(crawlingSession);

        crawlingSessionBhv.delete(crawlingSession);

    }

    protected void setupListCondition(CrawlingSessionCB cb,
            CrawlingSessionPager crawlingSessionPager) {

        if (crawlingSessionPager.id != null) {
            cb.query().setId_Equal(Long.parseLong(crawlingSessionPager.id));
        }
        // TODO Long, Integer, String supported only.
    }

    protected void setupEntityCondition(CrawlingSessionCB cb,
            Map<String, String> keys) {
    }

    protected void setupStoreCondition(CrawlingSession crawlingSession) {
    }

    protected void setupDeleteCondition(CrawlingSession crawlingSession) {
    }
}