package jp.sf.fess.entity;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

import org.apache.solr.common.util.NamedList;
import org.apache.solr.common.util.SimpleOrderedMap;

public class FieldAnalysisResponse extends
        LinkedHashMap<String, Map<String, List<Map<String, Object>>>> {

    private static final long serialVersionUID = 1L;

    protected long execTime;

    public FieldAnalysisResponse(final NamedList<Object> response) {
        final NamedList<?> fnList = getNamedList(
                getNamedList(response, "analysis"), "field_names");
        if (fnList != null) {
            for (int i = 0; i < fnList.size(); i++) {
                final String fieldName = fnList.getName(i);
                final NamedList<?> analysisList = getNamedList(
                        fnList.getVal(i), "index");
                final Map<String, List<Map<String, Object>>> analysisMap = new LinkedHashMap<String, List<Map<String, Object>>>();
                put(fieldName, analysisMap);

                if (analysisList != null) {
                    for (int j = 0; j < analysisList.size(); j++) {
                        final String analysisName = analysisList.getName(j);
                        final Object analysisDataList = analysisList.getVal(j);
                        if (analysisDataList instanceof List<?>) {
                            final List<Map<String, Object>> dataMapList = getDataMap((List<Object>) analysisDataList);
                            analysisMap.put(analysisName, dataMapList);
                        }
                    }
                }
            }
        }
    }

    private List<Map<String, Object>> getDataMap(
            final List<Object> analysisDataList) {
        final List<Map<String, Object>> dataMapList = new ArrayList<Map<String, Object>>();
        for (final Object dataList : analysisDataList) {
            if (dataList instanceof SimpleOrderedMap<?>) {
                final Map<String, Object> dataMap = new LinkedHashMap<String, Object>();
                for (int k = 0; k < ((SimpleOrderedMap<?>) dataList).size(); k++) {
                    final String dataName = ((SimpleOrderedMap<?>) dataList)
                            .getName(k);
                    final Object dataObj = ((SimpleOrderedMap<?>) dataList)
                            .getVal(k);
                    dataMap.put(dataName, dataObj);
                }
                dataMapList.add(dataMap);
            }
        }
        return dataMapList;
    }

    public long getExecTime() {
        return execTime;
    }

    public void setExecTime(final long execTime) {
        this.execTime = execTime;
    }

    private NamedList<?> getNamedList(final Object obj, final String key) {
        if (obj instanceof NamedList<?>) {
            return (NamedList<?>) ((NamedList<?>) obj).get(key);
        }
        return null;
    }

}
