/*
 * Copyright 2009-2010 the Fess Project and the Others.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND,
 * either express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 */
package jp.sf.fess;

import java.util.regex.Pattern;

public class Constants {
    public static final int MAJOR_VERSION = 4;

    public static final int MINOR_VERSION = 0;

    public static final String FESS_VERSION = String.valueOf(MAJOR_VERSION)
            + "." + String.valueOf(MINOR_VERSION);

    public static final String WEB_API_VERSION = "1";

    public static final String LOGIN_INFO = "jp.sf.fess.LoginInfo";

    public static final String EMPTY_STRING = "";

    public static final String TRUE = "true";

    public static final String FALSE = "false";

    public static final String T = "T";

    public static final String F = "F";

    public static final String ON = "on";

    public static final String ASC = "asc";

    public static final String DESC = "desc";

    public static final String READY = "ready";

    public static final String RUNNING = "running";

    public static final String DONE = "done";

    public static final String ITEM_LABEL = "label";

    public static final String ITEM_VALUE = "value";

    public static final String UTF_8 = "UTF-8";

    public static final String MS932 = "MS932";

    public static final String STANDARD_DATE_FORMAT = "yyyy-MM-dd'T'HH:mm:ss.SSSZ";

    public static final String DEFAULT_CRON_EXPRESSION = "0 0 0 * * ?";

    public static final String DEFAULT_SEARCH_LOG_CRON_EXPRESSION = "0 * * * * ?";

    public static final String DEFAULT_DAILY_CRON_EXPRESSION = "0 0 0 * * ?";

    public static final int DEFAULT_INTERVAL_TIME_FOR_FS = 1000;

    public static final int DEFAULT_INTERVAL_TIME_FOR_WEB = 30000;

    public static final int DEFAULT_NUM_OF_THREAD_FOR_FS = 5;

    public static final int DEFAULT_NUM_OF_THREAD_FOR_WEB = 3;

    public static final long DEFAULT_CRAWLING_EXECUTION_INTERVAL = 5000L;

    public static final long DEFAULT_COMMIT_PER_COUNT = 1000L;

    /** Solr Status: Active */
    public static final String ACTIVE = "ACTIVE";

    /** Solr Status: Inactive */
    public static final String INACTIVE = "INACTIVE";

    /** Solr Status: Corrupted */
    public static final String CORRUPTED = "CORRUPTED";

    public static final String GOOGLE_MOBILE_TRANSCODER = "google";

    // solr properties

    public static final String CURRENT_SERVER_FOR_UPDATE = "current.server.for.update";

    public static final String CURRENT_SERVER_FOR_SELECT = "current.server.for.select";

    // fess properties

    public static final String SEARCH_LOG_PROPERTY = "search.log";

    public static final String APPEND_QUERY_PARAMETER_PROPERTY = "append.query.parameter";

    public static final String DIFF_CRAWLING_PROPERTY = "crawling.diff";

    public static final String CRAWLING_THREAD_COUNT_PROPERTY = "crawling.thread.count";

    public static final String CRON_EXPRESSION_PROPERTY = "cron.expression";

    public static final String SEARCH_LOG_CRON_EXPRESSION_PROPERTY = "cron.expression.searchlog";

    public static final String DAILY_CRON_EXPRESSION_PROPERTY = "cron.expression.daily";

    public static final String DAY_FOR_CLEANUP_PROPERTY = "day.for.cleanup";

    public static final String SNAPSHOT_REPLICATION_PROPERTY = "snapshot.replication";

    public static final String SNAPSHOT_PATH_PROPERTY = "snapshot.path";

    public static final String OPTIMIZE_PROPERTY = "optimize.index";

    public static final String COMMIT_PROPERTY = "commit.index";

    public static final String COMMIT_PER_COUNT_PROPERTY = "commit.count";

    public static final String SERVER_ROTATION_PROPERTY = "server.rotation";

    public static final String MOBILE_TRANSCODER_PROPERTY = "mobile.transcoder";

    public static final String WEB_API_XML_PROPERTY = "web.api.xml";

    public static final String WEB_API_JSON_PROPERTY = "web.api.json";

    public static final String WEB_DESIGN_EDITOR_PROPERTY = "design.editor";

    public static final String DEFAULT_LABEL_VALUE_PROPERTY = "label.value";

    public static final String SUPPORTED_SEARCH_FEATURE_PROPERTY = "search.feature";

    public static final String IGNORE_FAILURE_TYPE_PROPERTY = "failure.ignoretype";

    public static final String FAILURE_COUNT_THRESHOLD_PROPERTY = "failure.countthreshold";

    public static final String WEB_API_HOT_SEARCH_WORD_PROPERTY = "web.api.hotsearch";

    public static final String CSV_FILE_ENCODING_PROPERTY = "csv.file.encoding";

    public static final String PURGE_SERCH_LOG_DAY_PROPERTY = "purge.searchlog.day";

    public static final String PURGE_SESSION_INFO_DAY_PROPERTY = "purge.sessioninfo.day";

    public static final String PURGE_BY_BOTS_PROPERTY = "purge.by.bots";

    public static final String AUTH_CIPHER = "jp.sf.fess.AuthCipher";

    public static final String RETURN_PATH = "jp.sf.fess.ReturnPath";

    public static final String HIGHLIGHT_QUERIES = "jp.sf.fess.Queries";

    public static final String DEFAULT_DATETIME_FORMAT = "yyyy-MM-dd'T'HH:mm:ss";

    public static final int DONE_STATUS = 9999;

    public static final String SUPPORTED_SEARCH_WEB_MOBILE = "WM";

    public static final String SUPPORTED_SEARCH_WEB = "W";

    public static final String SUPPORTED_SEARCH_MOBILE = "M";

    public static final String SUPPORTED_SEARCH_NONE = "n";

    public static final String DEFAULT_IGNORE_FAILURE_TYPE = "";

    public static final String DEFAULT_FAILURE_COUNT = "10";

    public static final String DEFAULT_PURGE_DAY = "30";

    public static final String DEFAULT_PURGE_BY_BOTS = "BaiduMobaider,"
            + "Baiduspider," + "CCBot," + "Googlebot," + "ia_archive,"
            + "Mediapartners-Google," + "mobile goo," + "msnbot,"
            + "Slurp,Yeti";

    // info map

    public static final String CRAWLER_STATUS = "CrawlerStatus";

    public static final String CRAWLER_START_TIME = "CrawlerStartTime";

    public static final String CRAWLER_END_TIME = "CrawlerEndTime";

    public static final String CRAWLER_EXEC_TIME = "CrawlerExecTime";

    public static final String WEB_CRAWLER_START_TIME = "WebCrawlerStartTime";

    public static final String WEB_CRAWLER_END_TIME = "WebCrawlerEndTime";

    public static final String FS_CRAWLER_START_TIME = "FsCrawlerStartTime";

    public static final String FS_CRAWLER_END_TIME = "FsCrawlerEndTime";

    public static final String DATA_CRAWLER_START_TIME = "DataCrawlerStartTime";

    public static final String DATA_CRAWLER_END_TIME = "DataCrawlerEndTime";

    public static final String OPTIMIZE_START_TIME = "OptimizeStartTime";

    public static final String OPTIMIZE_END_TIME = "OptimizeEndTime";

    public static final String OPTIMIZE_EXEC_TIME = "OptimizeExecTime";

    public static final String COMMIT_START_TIME = "CommitStartTime";

    public static final String COMMIT_END_TIME = "CommitEndTime";

    public static final String COMMIT_EXEC_TIME = "CommitExecTime";

    public static final String WEB_CRAWLING_EXEC_TIME = "WebCrawlExecTime";

    public static final String WEB_INDEX_EXEC_TIME = "WebIndexExecTime";

    public static final String WEB_INDEX_SIZE = "WebIndexSize";

    public static final String FS_CRAWLING_EXEC_TIME = "FsCrawlExecTime";

    public static final String FS_INDEX_EXEC_TIME = "FsIndexExecTime";

    public static final String FS_INDEX_SIZE = "FsIndexSize";

    public static final String DATA_CRAWLING_EXEC_TIME = "DataCrawlExecTime";

    public static final String DATA_INDEX_EXEC_TIME = "DataIndexExecTime";

    public static final String DATA_INDEX_SIZE = "DataIndexSize";

    public static final String REPLICATION_STATUS = "ReplicationStatus";

    public static final String REPLICATION_START_TIME = "ReplicationStartTime";

    public static final String REPLICATION_END_TIME = "ReplicationEndTime";

    public static final String REPLICATION_EXEC_TIME = "ReplicationExecTime";

    public static final String INDEXING_TARGET = "indexingTarget";

    public static final String DIGEST_PREFIX = "...";

    public static final String BASIC = "BASIC";

    public static final String DIGEST = "DIGEST";

    public static final String NTLM = "NTLM";

    public static final String SAMBA = "SAMBA";

    public static final String[] RESERVED = { "+", "-", "&&", "||", "!", "(",
            ")", "{", "}", "[", "]", "^", "~", "*", "?", "\\", ";", ":" };

    public static final Pattern SOLR_FIELD_RESERVED_PATTERN = Pattern
            .compile("([+\\-!\\(\\){}\\[\\]^\"~\\\\:\\p{Zs}]|(&&)|(\\|\\|))");// "*", "?",

    public static final String SEARCH_LOG_ACCESS_TYPE = "searchLogAccessType";

    public static final String DATE_FORMAT_ISO_8601_WITH_MS = "yyyy-MM-dd'T'HH:mm:ss.SZ";

    public static final String DATE_FORMAT_DIGIT_ONLY = "yyyyMMddHHmmss";

}
