/*
 * Copyright 2009-2009 the Fess Project and the Others.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND,
 * either express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 */
package jp.sf.fess.db.exentity;

import java.util.ArrayList;
import java.util.List;

import jp.sf.fess.db.bsentity.BsWebCrawlingConfig;

/**
 * The entity of WEB_CRAWLING_CONFIG.
 * <p>
 * You can implement your original methods here.
 * This class remains when re-generating.
 * </p>
 * @author DBFlute(AutoGenerator)
 */
public class WebCrawlingConfig extends BsWebCrawlingConfig implements
        CrawlingConfig {

    /** Serial version UID. (Default) */
    private static final long serialVersionUID = 1L;

    private String[] browserTypeIds;

    /* (non-Javadoc)
     * @see jp.sf.fess.db.exentity.CrawlingConfig#getBrowserTypeIds()
     */
    public String[] getBrowserTypeIds() {
        return browserTypeIds;
    }

    public void setBrowserTypeIds(String[] browserTypeIds) {
        this.browserTypeIds = browserTypeIds;
    }

    @Override
    public String[] getBrowserTypeValues() {
        List<String> values = new ArrayList<String>();
        List<WebConfigToBrowserTypeMapping> list = getWebConfigToBrowserTypeMappingList();
        if (list != null && !list.isEmpty()) {
            for (WebConfigToBrowserTypeMapping mapping : list) {
                values.add(mapping.getBrowserType().getValue());
            }
        }
        return values.toArray(new String[values.size()]);
    }

}
