package jp.sf.fess.suggest.converter;

import java.util.LinkedHashMap;
import java.util.Map;

public class ReplaceConverter implements SuggestConverter {
    protected Map<String, String> replaceMap = new LinkedHashMap<String, String>();

    @Override
    public String convert(final String query) {
        String target = query;
        for (final Map.Entry<String, String> entry : replaceMap.entrySet()) {
            target = target.replaceAll(entry.getKey(), entry.getValue());
        }
        return target;
    }

    public void addReplaceString(final String before, final String after) {
        replaceMap.put(before, after);
    }
}
