if(!dojo._hasResource["aipo.widget.WideUseMemberSelectList"]){
    //_hasResource checks added by build. Do not use _hasResource directly in your code.
dojo._hasResource["aipo.widget.WideUseMemberSelectList"] = true;
/*
 * Aipo is a groupware program developed by Aimluck,Inc.
 * http://www.aipo.com/
 *
 * Copyright(C) 2012 avanza Co.,Ltd. All rights reserved.
 * http://www.avnz.co.jp/
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

// 汎用閲覧メンバー選択ダイアログ
dojo.provide("aipo.widget.WideUseMemberSelectList");

dojo.require("dijit._Widget");
dojo.require("dijit._Templated");

/** 汎用閲覧メンバー選択ダイアログ */
dojo.declare("aipo.widget.WideUseMemberSelectList", [dijit._Widget, dijit._Templated], {
    widgetId:"",
    inputWidth: "95%",
    inputValue: "",
    initGroupName: "", //add
    initParentGroupName: "", //add
    selectId: "",
    memberFromId: "",
    memberFromUrl: "",
    memberFromOptionKey: "",
    memberFromOptionValue: "",
    memberToId: "",
    buttonAddId: "",
    buttonRemoveId: "",
    memberLimit: 0,
    groupSelectId: "",
    parentGroupSelectId: "",
    group1SelectPreOptionKey: "",
    group1SelectPreOptionValue: "",
    group2SelectPreOptionKey: "",
    group2SelectPreOptionValue: "",
    post1GroupUrl: "",
    changePost2GroupUrl: "",
    changePost1GroupUrl: "",
    groupSelectOptionKey: "",
    groupSelectOptionValue: "",
    tmpPortretId: "",
    tmpPortretId: "",
    callback: function(){},

    member_maximum_to:10,

    templateString: "<div id=\"${widgetId}\" widgetId=\"${widgetId}\" style=\"display: none\">"
                    + "<table class=\"none\" ><tr><td><div id=\"memberPopupDiv\">"
                    + "<div class=\"outer\"><div class=\"popup\" style=\"width:300px\">"
                    + "<div class=\"clearfix\"><div class=\"memberlistToTop\" >閲覧メンバー一覧</div>"
                    + "<div class=\"memberlistFromTop\">"
                    + "<select size=\"1\" style=\"width:100%\" name=\"${parentGroupSelectId}\" id=\"${parentGroupSelectId}\" dojoAttachEvent=\"onchange:changeParentGroup\"></select>"
                    + "<select size=\"1\" style=\"width:100%\" name=\"${groupSelectId}\" id=\"${groupSelectId}\" dojoAttachEvent=\"onchange:changeGroup\"></select>"
                    + "</div>"
                    + "</div><div class=\"clearfix\">"
                    + "<div class=\"memberlistToBody\">"
                    + "<select size=\"10\" multiple=\"multiple\" style=\"width:100%\" name=\"${memberToId}\" id=\"${memberToId}\"></select>"
                    + "</div><div class=\"memberlistFromBody\"><select size=\"10\" multiple=\"multiple\" style=\"width:100%\" name=\"${memberFromId}\" id=\"${memberFromId}\"></select></div></div><div class=\"clearfix\"><div class=\"memberlistToBottom\">"
                    + "<div class=\"alignright\">"
                    + "<input id=\"${buttonRemoveId}\" name=\"${buttonRemoveId}\" type=\"button\" class=\"button\" value=\"　削除　\"/ dojoAttachEvent=\"onclick:onMemberRemoveClick\"/></div></div>"
                    + "<div class=\"memberlistFromBottom\"><div class=\"alignright\"><input id=\"${buttonAddId}\" name=\"${buttonAddId}\" type=\"button\" class=\"button\" value=\"　＜ 追加　\"/ dojoAttachEvent=\"onclick:onMemberAddClick\"/></div></div></div>"
                    + "<div class=\"clearfix small\" style=\"padding-top: 5px;\">※閲覧できるメンバーは１０人までとなっております。</div>"
                    + "<div align=\"center\" style=\"margin:4px;\">"
                    + "<input type=\"button\" value=\"メンバーを変更する\" dojoAttachEvent=\"onclick:onCloseClick\"/> </div>"
                    + "</div></div></div></td></tr></table></div>\n",

    /**
     * 初期表示処理
     */
    postCreate: function(){

        this.id = this.widgetId;

        //メンバーリストボックス初期表示
        var url = this.memberFromUrl+"&mode=post1_group&groupname="+this.initGroupName;
        var params = {
          url: url,
          key: this.memberFromOptionKey,
          value: this.memberFromOptionValue,
          indicator: this.widgetId + "-memberlist-indicator"
        };
        aimluck.io.createOptions(this.memberFromId, params);

        //部署１プルダウンを表示
        params = {
          url: this.post1GroupUrl,
          key: this.groupSelectOptionKey,
          value: this.groupSelectOptionValue,
          selectedId: this.initParentGroupName,
          preOptions: { key:this.group1SelectPreOptionKey, value:this.group1SelectPreOptionValue }
        };
        aimluck.io.createOptions(this.parentGroupSelectId, params);

        //部署２プルダウンを表示
        url = this.changePost1GroupUrl+"&parent_group_name="+this.initParentGroupName;
        params = {
          url: url,
          key: this.groupSelectOptionKey,
          value: this.groupSelectOptionValue,
          selectedId: this.initGroupName,
          preOptions: { key:this.group2SelectPreOptionKey, value:this.group2SelectPreOptionValue }
        };
        aimluck.io.createOptions(this.groupSelectId, params);

    },
    /**
     * selectタグ指定のoption追加処理
     *
     * @param select selectタグオブジェクト
     * @param value optionのvalueへの設定値
     * @param text optionのinnerHTMLへの設定値
     * @param is_selected selectedフラグ
     */
    addOption:function(select, value, text, is_selected) {
        // 閲覧メンバー最大値を超える場合は追加しない
        if (this.memberLimit != 0 && select.options.length >= this.memberLimit){
            return;
        }
        // 追加するOPTIONタグを生成
        var option = document.createElement("OPTION");
        option.value = value;
        option.text = text;
        option.selected = is_selected;
        // オプションタグをselectタグの最下方に追加する
        // ドキュメントの状態で追加方法を切替する
        if (document.all) {
            if (select.options.length == 1 && select.options[0].value == ""){
                select.options.remove(0);
            }
            select.add(option, select.options.length);
        } else {
            if (select.options.length == 1 && select.options[0].value == ""){
                select.removeChild(select.options[0]);
            }
            select.insertBefore(option, select.options[select.options.length]);
        }
    },
    /**
     * ウィジットの閲覧メンバーのみにoptionを追加する
     *
     * @param value optionのvalueへの設定値
     * @param text optionのinnerHTMLへの設定値
     * @param is_selected selectedフラグ
     */
    addOptionToMemberTo:function(value, text, is_selected) {
        this.addOption(dojo.byId(this.memberToId), value, text, is_selected);
    },
    /**
     * 呼び出し元ポートレットの閲覧メンバーのみにoptionを追加する
     *
     * @param value optionのvalueへの設定値
     * @param text optionのinnerHTMLへの設定値
     * @param is_selected selectedフラグ
     */
    addOptionToSelect:function(value, text, is_selected) {
        this.addOption(dojo.byId(this.selectId), value, text, is_selected);
    },
    /**
     * ウィジットと呼び出し元ポートレットの閲覧メンバー両方にoptionを追加する
     *
     * @param value optionのvalueへの設定値
     * @param text optionのinnerHTMLへの設定値
     * @param is_selected selectedフラグ
     */
    addOptionSync:function(value, text, is_selected) {
        this.addOption(dojo.byId(this.memberToId), value, text, is_selected);
        this.addOption(dojo.byId(this.selectId), value, text, is_selected);
    },
    /**
     * メンバー追加処理
     *
     * @param select selectタグオブジェクト
     */
    addMember:function(select_member_from, select_member_to) {
      if (document.all) {
            var f_o = select_member_from.options;
            var t_o = select_member_to.options;
            if (f_o.length == 1 && f_o[0].value == "") return;
            for(i = 0 ; i < f_o.length; i ++ ) {
                if(!f_o[i].selected) continue;
                var iseq = false;

                for( j = 0 ; j < t_o.length; j ++ ) {
	                if( t_o[j].value == f_o[i].value ) {
	                    iseq = true;
	                    break;
	                }
                }

                if(iseq) continue;
                var option = document.createElement("OPTION");
                option.value = f_o[i].value;
                option.text = f_o[i].text;
                option.selected = true;
	            if (t_o.length == 1 && t_o[0].value == ""){
	                    t_o.remove(0);
	            }
               if (this.memberLimit != 0 && select_member_to.options.length >= this.memberLimit) return;
               if( this.member_maximum_to  > t_o.length){
                    t_o.add(option, t_o.length);
               }
            }
      } else {
            var f_o = select_member_from.options;
            var t_o = select_member_to.options;
            if (f_o.length == 1 && f_o[0].value == "") return;
            for(i = 0 ; i < f_o.length; i ++ ) {
                if(!f_o[i].selected) continue;
                var iseq = false;

                for( j = 0 ; j < t_o.length; j ++ ) {
	                if( t_o[j].value == f_o[i].value ) {
	                    iseq = true;
	                    break;
	                }
                }

                if(iseq) continue;
                var option = document.createElement("OPTION");
                option.value = f_o[i].value;
                option.text = f_o[i].text;
                option.selected = true;
	            if (select_member_to.options.length == 1 && select_member_to.options[0].value == ""){
	                select_member_to.removeChild(select_member_to.options[0]);
	            }
                if (this.memberLimit != 0 && select_member_to.options.length >= this.memberLimit) return;
                if( this.member_maximum_to  > t_o.length){
                    select_member_to.insertBefore(option, t_o[t_o.length]);
                }
            }
      }
    },
    /**
     * 全メンバー削除処理
     *
     * @param select selectタグオブジェクト
     */
    removeAllMember:function(select) {
      if (document.all) {
        var t_o = select.options;
          for(i = 0 ;i < t_o.length; i ++ ) {
              if( t_o[i].selected ) {
              t_o.remove(i);
                i -= 1;
            }
            }
      } else {
        var t_o = select.options;
          for(i = 0 ;i < t_o.length; i ++ ) {
              if( t_o[i].selected ) {
                    select.removeChild(t_o[i]);
                i -= 1;
                }
            }
      }
    },
    /**
     * メンバー削除処理
     *
     * @param select selectタグオブジェクト
     */
    removeMember:function(select) {
      if (document.all) {
        var t_o = select.options;
          for(i = 0 ;i < t_o.length; i ++ ) {
              if( t_o[i].selected ) {
              t_o.remove(i);
                i -= 1;
            }
            }
      } else {
        var t_o = select.options;
          for(i = 0 ;i < t_o.length; i ++ ) {
              if( t_o[i].selected ) {
                    select.removeChild(t_o[i]);
                i -= 1;
                }
            }
      }
    },
    /**
     * 選択中の閲覧メンバーを削除する<br/>
     * 選択済みリストと、呼び出し元ポートレットのメンバーリストの内容を同期する。
     */
    removeMemberSync:function() {
      var select = dojo.byId(this.memberToId);
      var selectsub = dojo.byId(this.selectId);
      if (document.all) {
        var t_o = select.options;
        var f_o = selectsub.options;
          for(i = 0 ;i < t_o.length; i ++ ) {
            if( t_o[i].selected ) {
              t_o.remove(i);
              f_o.remove(i);
                i -= 1;
            }
          }
      } else {
        var t_o = select.options;
        var f_o = selectsub.options;
        for(i = 0 ;i < t_o.length; i ++ ) {
          if( t_o[i].selected ) {
            select.removeChild(t_o[i]);
            selectsub.removeChild(f_o[i]);
            i -= 1;
          }
        }
      }
    },
    /**
     * 部署２プルダウン選択時処理
     *
     * @param select selectタグオブジェクト
     */
    changeGroup: function(select) {

      //部署2プルダウンの選択値を取得
      var group_name = select.target.options[select.target.selectedIndex].value;
      var url = "";
      if( group_name == "ALL" ) {
        //"すべて"を選択した場合、部署１の選択肢を取得して、表示処理
        url = this.changePost2GroupUrl+"&mode=post1_group&groupname="+dojo.byId(this.parentGroupSelectId).value;
      } else {
        url = this.changePost2GroupUrl+"&mode=group&groupname="+group_name;
      }
      var params = {
        url: url,
        key: this.memberFromOptionKey,
        value: this.memberFromOptionValue,
        indicator: this.widgetId + "-memberlist-indicator"
      };
      aimluck.io.createOptions(this.memberFromId, params);

    },
    /**
     * 部署１プルダウン選択時処理
     *
     * @param select selectタグオブジェクト
     */
    changeParentGroup: function(select) {

      ////////////////////////
      //メンバーリストボックス表示
      ////////////////////////
      var group_name = select.target.options[select.target.selectedIndex].value;
      var url = this.changePost2GroupUrl+"&mode=post1_group&groupname="+group_name;
      var params = {
        url: url,
        key: this.memberFromOptionKey,
        value: this.memberFromOptionValue,
        indicator: this.widgetId + "-memberlist-indicator"
      };
      aimluck.io.createOptions(this.memberFromId, params);

      /////////////////////
      //部署２プルダウンを表示
      /////////////////////

      //部署1プルダウンの選択値を取得
      var parent_group_name = select.target.options[select.target.selectedIndex].value;

      //部署2プルダウン生成処理
      var url = this.changePost1GroupUrl+"&parent_group_name="+parent_group_name;
      var preOptionKey = "";
      var preOptionValue = "";
      if( parent_group_name == "groupsend" ) {
        preOptionKey = this.group2SelectPreOptionKey;
        preOptionValue = this.group2SelectPreOptionValue;
      }
      var params = {
        url: url,
        key: this.groupSelectOptionKey,
        value: this.groupSelectOptionValue,
        selectedId: this.initGroupName,
        preOptions: { key:preOptionKey, value:preOptionValue }
      };
      aimluck.io.createOptions(this.groupSelectId, params);

    },
    /**
     * 追加ボタンクリック処理
     *
     * @param evt イベント
     */
    onMemberAddClick: function(/*Event*/ evt){
      this.addMember(dojo.byId(this.memberFromId), dojo.byId(this.memberToId));
      this.addMember(dojo.byId(this.memberFromId), dojo.byId(this.selectId));
    },
    /**
     * 削除ボタンクリック処理
     *
     * @param evt イベント
     */
    onMemberRemoveClick: function(/*Event*/ evt){
      this.removeMemberSync();
      var select = dojo.byId(this.memberToId);
      if(select.options.length == 0){
        if(aipo.schedule.login_aliasname != "undefined"){
          var alias = aipo.schedule.login_aliasname.replace(/&amp;/g, "&").replace(/&quot;/g, "\"").replace(/&lt;/g, "<").replace(/&gt;/g, ">");
          this.addOptionSync(aipo.schedule.login_id, alias, true);
        }
      }
    },
    /**
     * クローズ処理
     */
    onCloseClick: function(){
        dojo.style(this.domNode, "display", "none");
        this.callback.call(this.callback);
    }
});

}
