/*
 * Aipo is a groupware program developed by Aimluck,Inc.
 * Copyright (C) 2004-2011 Aimluck,Inc.
 * http://www.aipo.com
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

package com.aimluck.eip.schedule;

import java.util.Date;

import com.aimluck.commons.field.ALDateTimeField;
import com.aimluck.commons.field.ALNumberField;
import com.aimluck.commons.field.ALStringField;
import com.aimluck.eip.common.ALData;

/**
 * スケジュールの検索データを管理するクラスです。
 * 
 */
public class ScheduleResultData implements ALData, Cloneable {

  /** <code>schedule_id</code> スケジュールID */
  private ALNumberField schedule_id;

  /** <code>parent_id</code> 親スケジュール ID */
  private ALNumberField parent_id;

  /** <code>type</code> 施設かどうか */
  private ALStringField type;

  /** <code>start_date</code> 開始時間 */
  private ALDateTimeField start_date;

  /** <code>end_date</code> 終了時間 */
  private ALDateTimeField end_date;

  /** <code>name</code> 予定 */
  private ALStringField name;

  /** 場所 */
  private ALStringField place;

  /** <code>ptn</code> 繰り返しパターン */
  private String ptn;

  /** <code>format</code> フォーマット */
  private String format = "H:mm";

  /** <code>is_owner</code> オーナーかどうか */
  private boolean is_owner;

  /** <code>is_tmpreserve</code> 仮スケジュールかどうか */
  @Deprecated
  private boolean is_tmpreserve;

  /** <code>is_duplicate</code> 重複スケジュールかどうか */
  private boolean is_duplicate;

  /** <code>is_public</code> 公開スケジュールかどうか */
  private boolean is_public;

  /** <code>is_hidden</code> 表示するかどうか */
  private boolean is_hidden;

  /** <code>is_loginuser</code> ログインユーザー */
  private boolean is_loginuser;

  /** <code>is_member</code> 共有メンバー */
  private boolean is_member;

  /** <code>is_confirm</code> 確認済みかどうか */
  private boolean is_confirm;

  /** <code>is_repeat</code> 繰り返しかどうか */
  private boolean is_repeat;

  /** <code>is_dummy</code> ダミーかどうか */
  private boolean is_dummy;

  /** <code>is_editable</code> 共有メンバーによる編集／削除フラグ */
  private boolean is_editable;

  /** <code>rowspan</code> rowspan */
  private int rowspan;

  /** <code>common_category_name</code> 共有カテゴリ名 */
  private ALStringField common_category_name;

  // add start
  // 承諾／仮承諾／辞退対応
  /** 表示対象者の状態 */
  private String status;

  /** 表示対象者の参加必須フラグ */
  private String required = "";

  /** 表示対象者の重要フラグ */
  private String priority = "";

  /** 表示対象者のダミー未回答フラグ */
  private String dummyNonResponse = "";

  /** 作成ユーザーID */
  private String create_user_id;

  // add end

  // add start 要件No.26 スケジュール個別色換え
  /** 個別色（色コード） */
  private String individualColor;

  // add end

  // add start 要件No.16 スケジュール画面（月単位／週単位／日単位）右クリックメニュー
  /** <code>is_share</code> 共有かどうか */
  private boolean is_share;

  // add end

  // add start No.4 スケジュール印刷（週単位）
  /** <code>temporaryFlag</code> 仮予定フラグ */
  private String temporaryFlag;

  /** <code>columnCount</code> 重複列数 */
  private int columnCount;

  /** <code>sortNo</code> 重複順 */
  private int sortNo;

  // add end

  // add start 要件No.18 会議案内ファイル添付
  /** 添付ファイル有無 */
  private boolean has_files;

  // add end

  // add start 結合試験障害16-01対応
  /** 主催者フラグ（右クリック機能用のフラグ） */
  private boolean is_organizer;

  // add end

  /*
   *
   */
  @Override
  public void initField() {
    name = new ALStringField();
    type = new ALStringField();
    place = new ALStringField();
    schedule_id = new ALNumberField();
    parent_id = new ALNumberField();
    start_date = new ALDateTimeField(format);
    end_date = new ALDateTimeField(format);
    common_category_name = new ALStringField();
    is_owner = true;
    is_tmpreserve = false;
    is_duplicate = false;
    is_public = true;
    is_hidden = false;
    is_loginuser = true;
    is_member = true;
    is_confirm = false;
    is_repeat = false;
    is_dummy = false;
    // add start No.4 スケジュール印刷（週単位）
    temporaryFlag = "";
    columnCount = 0;
    sortNo = 0;
    // add end
    // add start 要件No.18 会議案内ファイル添付
    has_files = false;
    // add end
    // add start 要件No.26 スケジュール個別色換え
    individualColor = "";
    // add end
    // add start 結合試験障害16-01対応
    is_organizer = false;
    // add end
  }

  /**
   * 終了時間を取得します。
   * 
   * @return
   */
  public ALDateTimeField getEndDate() {
    return end_date;
  }

  /**
   * 開始時間を取得します。
   * 
   * @return
   */
  public ALDateTimeField getStartDate() {
    return start_date;
  }

  /**
   * 終了時間を設定します。
   * 
   * @param date
   */
  public void setEndDate(Date date) {
    end_date.setValue(date);
  }

  /**
   * 開始時間を設定します。
   * 
   * @param date
   */
  public void setStartDate(Date date) {
    start_date.setValue(date);
  }

  /**
   * 予定を取得します。
   * 
   * @return
   */
  public ALStringField getName() {
    return name;
  }

  /**
   * 予定を取得します。
   * 
   * @return
   */
  public ALStringField getPlace() {
    return place;
  }

  /**
   * 詳細を表示するかどうか
   * 
   * @return
   */
  public boolean isShowDetail() {
    return (is_loginuser || is_public || is_owner || is_member);
  }

  /**
   * 予定を設定します。
   * 
   * @param string
   */
  public void setName(String string) {
    name.setValue(string);
  }

  /**
   * 場所を設定します。
   * 
   * @param string
   */
  public void setPlace(String string) {
    place.setValue(string);
  }

  /**
   * フォーマットを設定します。
   * 
   * @param string
   */
  public void setFormat(String string) {
    format = string;
  }

  /**
   * スケジュールIDを取得します。
   * 
   * @return
   */
  public ALNumberField getScheduleId() {
    return schedule_id;
  }

  /**
   * スケジュールIDを設定します。
   * 
   * @param number
   */
  public void setScheduleId(int number) {
    schedule_id.setValue(number);
  }

  /**
   * 親スケジュール ID を取得します。
   * 
   * @return
   */
  public ALNumberField getParentId() {
    return parent_id;
  }

  /**
   * 親スケジュール ID を設定します。
   * 
   * @param number
   */
  public void setParentId(int number) {
    parent_id.setValue(number);
  }

  /**
   * オーナーかどうかを設定します。
   * 
   * @param bool
   */
  public void setOwner(boolean bool) {
    is_owner = bool;
  }

  /**
   * オーナーかどうか
   * 
   * @return
   */
  public boolean isOwner() {
    return is_owner;
  }

  /**
   * 仮スケジュールかどうか
   * 
   * @return
   */
  @Deprecated
  public boolean isTmpreserve() {
    return is_tmpreserve;
  }

  /**
   * 公開するかどうか
   * 
   * @return
   */
  public boolean isPublic() {
    return is_public;
  }

  /**
   * 仮スケジュールかどうかを設定します。
   * 
   * @param bool
   */
  @Deprecated
  public void setTmpreserve(boolean bool) {
    is_tmpreserve = bool;
  }

  /**
   * 確認済みスケジュールかどうか
   * 
   * @return
   */
  public boolean isConfirm() {
    return is_confirm;
  }

  /**
   * 確認済みスケジュールかどうかを設定します。
   * 
   * @param bool
   */
  public void setConfirm(boolean bool) {
    is_confirm = bool;
  }

  /**
   * 重複スケジュールかどうか
   * 
   * @return
   */
  public boolean isDuplicate() {
    return is_duplicate;
  }

  /**
   * 重複スケジュールかどうかを設定島します。
   * 
   * @param bool
   */
  public void setDuplicate(boolean bool) {
    is_duplicate = bool;
  }

  /**
   * 公開するかどうかを設定します。
   * 
   * @param bool
   */
  public void setPublic(boolean bool) {
    is_public = bool;
  }

  /**
   * 表示するかどうか
   * 
   * @return
   */
  public boolean isHidden() {
    return is_hidden;
  }

  /**
   * 表示するかどうかを設定します。
   * 
   * @param bool
   */
  public void setHidden(boolean bool) {
    is_hidden = bool;
  }

  /**
   * 非公開かどうか
   * 
   */
  public boolean isPrivate() {
    return !is_public && is_hidden;
  }

  /**
   * ログインユーザーかどうか
   * 
   * @return
   */
  public boolean isLoginuser() {
    return is_loginuser;
  }

  /**
   * ログインユーザーかどうかを設定します。
   * 
   * @param b
   */
  public void setLoginuser(boolean b) {
    is_loginuser = b;
  }

  /**
   * 共有メンバーかどうか
   * 
   * @return
   */
  public boolean isMember() {
    return is_member;
  }

  /**
   * 共有メンバーかどうかを設定します。
   * 
   * @param b
   */
  public void setMember(boolean b) {
    is_member = b;
  }

  /**
   * 繰り返しかどうか
   * 
   * @return
   */
  public boolean isRepeat() {
    return is_repeat;
  }

  /**
   * 繰り返しかどうかを設定します。
   * 
   * @param bool
   */
  public void setRepeat(boolean bool) {
    is_repeat = bool;
  }

  /**
   * ダミーかどうか
   * 
   * @return
   */
  public boolean isDummy() {
    return is_dummy;
  }

  /**
   * ダミーかどうかを設定します。
   * 
   * @param bool
   */
  public void setDummy(boolean bool) {
    is_dummy = bool;
  }

  /**
   * 
   * @return
   */
  @Override
  public Object clone() {
    try {
      return (super.clone());
    } catch (CloneNotSupportedException e) {
      throw (new InternalError(e.getMessage()));
    }
  }

  /**
   * rowspanを設定します。
   * 
   * @param number
   */
  public void setRowspan(int number) {
    rowspan = number;
  }

  /**
   * rowspanを取得します。
   * 
   * @return
   */
  public int getRowspan() {
    return rowspan;
  }

  /**
   * 繰り返しパターンを取得します。
   * 
   * @return
   */
  public String getPattern() {
    return ptn;
  }

  /**
   * 繰り返しパターンを設定します。
   * 
   * @param string
   */
  public void setPattern(String string) {
    ptn = string;
  }

  /**
   * 共有メンバーによる編集／削除フラグを取得する．
   * 
   * @return
   */
  public boolean isEditable() {
    return is_editable;
  }

  /**
   * 共有メンバーによる編集／削除フラグを設定する．
   * 
   * @param string
   */
  public void setEditFlag(boolean bool) {
    is_editable = bool;
  }

  /**
   * 日付を取得します。
   * 
   * @return
   */
  public String getDate() {
    if (start_date.getValue().equals(end_date.getValue())) {
      return start_date.toString();
    } else if ((start_date.getYear().equals(end_date.getYear()) && start_date.getMonth().equals(end_date.getMonth()) && start_date.getDay().equals(
      end_date.getDay()))
      || is_repeat) {
      return new StringBuffer().append(start_date.toString()).append('-').append(end_date.toString()).toString();
    } else {
      return new StringBuffer().append(start_date.toString()).append('-').append("24:00").toString();
    }
  }

  /**
   * 日付を取得します。
   * 
   * @return
   */
  public String getDate2() {
    if (start_date.getHour().equals(end_date.getHour()) && start_date.getMinute().equals(end_date.getMinute())) {
      return start_date.toString();
    } else if ((start_date.getYear().equals(end_date.getYear()) && start_date.getMonth().equals(end_date.getMonth()) && start_date.getDay().equals(
      end_date.getDay()))
      || is_repeat) {
      return new StringBuffer().append(start_date.toString()).append('～').append(end_date.toString()).toString();
    } else {
      return new StringBuffer().append(start_date.toString()).append('～').append("24:00").toString();
    }
  }

  // add start No.4 スケジュール印刷（週単位）
  /**
   * 時間を0埋めした日付を取得します。
   * 
   * @return
   */
  public String getPaddingDate() {
    ALDateTimeField paddingStartDate = new ALDateTimeField("HH:mm");
    ALDateTimeField paddingEndDate = new ALDateTimeField("HH:mm");
    paddingStartDate.setValue(start_date.getValue());
    paddingEndDate.setValue(end_date.getValue());

    if (paddingStartDate.getValue().compareTo(paddingEndDate.getValue()) == 0) {
      return new StringBuffer().append(paddingStartDate.toString()).append('-').append(paddingEndDate.toString()).toString();
    } else if ((paddingStartDate.getYear().equals(paddingEndDate.getYear()) && paddingStartDate.getMonth().equals(paddingEndDate.getMonth()) && paddingStartDate
      .getDay()
      .equals(paddingEndDate.getDay()))
      || is_repeat) {
      return new StringBuffer().append(paddingStartDate.toString()).append('-').append(paddingEndDate.toString()).toString();
    } else {
      return new StringBuffer().append(paddingStartDate.toString()).append('-').append("24:00").toString();
    }
  }

  // add end

  /**
   * 
   * 
   * @return
   */
  public ALStringField getCommonCategoryName() {
    return common_category_name;
  }

  /**
   * 
   * @param string
   */
  public void setCommonCategoryName(String string) {
    common_category_name.setValue(string);
  }

  public void setType(String str) {
    this.type.setValue(str);
  }

  public String getType() {
    return this.type.toString();
  }

  // add start
  // 承諾／仮承諾／拒否対応
  /**
   * 表示対象者の状態を設定します。
   * 
   * @param value
   *          状態
   */
  public void setStatus(String status) {
    this.status = status;
  }

  /**
   * 表示対象者の状態を返します。
   * 
   * @return 状態
   */
  public String getStatus() {
    return status;
  }

  /**
   * 表示対象者の状態が所有者か判定します。
   * 
   * @return 所有者の場合true、そうでない場合false。
   */
  public boolean isOwnerStatus() {
    return ScheduleConst.SCHEDULEMAP_STATUS_OWNER.equals(status);
  }

  /**
   * 表示対象者の状態が未回答か判定します。
   * 
   * @return 未回答の場合true、そうでない場合false。
   */
  public boolean isNonResponce() {
    return ScheduleConst.SCHEDULEMAP_STATUS_NON_RES.equals(status);
  }

  /**
   * 表示対象者の状態が承諾か判定します。
   * 
   * @return 承諾の場合true、そうでない場合false。
   */
  public boolean isConsent() {
    return ScheduleConst.SCHEDULEMAP_STATUS_CONSENT.equals(status);
  }

  /**
   * 表示対象者の状態が仮承諾か判定します。
   * 
   * @return 仮承諾の場合true、そうでない場合false。
   */
  public boolean isProvisional() {
    return ScheduleConst.SCHEDULEMAP_STATUS_PROVISIONAL.equals(status);
  }

  /**
   * 表示対象者の状態が削除（辞退して削除）か判定します。
   * 
   * @return 削除（辞退して削除）の場合true、そうでない場合false。
   */
  public boolean isRemove() {
    return ScheduleConst.SCHEDULEMAP_STATUS_REMOVE.equals(status);
  }

  /**
   * 表示対象者の状態が辞退か判定します。
   * 
   * @return 辞退の場合true、そうでない場合false。
   */
  public boolean isVeto() {
    return ScheduleConst.SCHEDULEMAP_STATUS_VETO.equals(status);
  }

  /**
   * 表示対象者の状態がダミースケジュールか判定します。
   * 
   * @return ダミースケジュールの場合true、そうでない場合false。
   */
  public boolean isDummyStatus() {
    return ScheduleConst.SCHEDULEMAP_STATUS_DUMMY.equals(status);
  }

  /**
   * 表示対象者の重要フラグを設定します。
   * 
   * @param value
   *          重要フラグ
   */
  public void setPriority(String value) {
    priority = value;
  }

  /**
   * 表示対象者の重要フラグを取得します。
   * 
   * @return 重要フラグ
   */
  public String getPriority() {
    return priority;
  }

  /**
   * 表示対象者にとって重要スケジュールか判定します。
   * 
   * @return 重要スケジュールの場合true、そうでない場合false。
   */
  public boolean hasPriority() {
    return ScheduleConst.SCHEDULEMAP_PRIORITY_T.equals(priority);
  }

  /**
   * 表示対象者の必須フラグを設定します。
   * 
   * @param value
   *          必須フラグ
   */
  public void setRequired(String value) {
    required = value;
  }

  /**
   * 表示対象者の必須フラグを取得します。
   * 
   * @return 必須フラグ
   */
  public String getRequired() {
    return required;
  }

  /**
   * 表示対象者が参加必須メンバーか判定します。
   * 
   * @return 参加必須メンバーの場合true、参加任意メンバーの場合false。
   */
  public boolean isRequired() {
    return ScheduleConst.SCHEDULEMAP_REQUIRED_T.equals(required);
  }

  /**
   * 表示対象者のダミー未回答フラグを設定します。
   * 
   * @param value
   *          ダミー未回答フラグ
   */
  public void setDummyNonResponse(String value) {
    dummyNonResponse = value;
  }

  /**
   * 表示対象者のダミー未回答を取得します。
   * 
   * @return ダミー未回答フラグ
   */
  public String getDummyNonResponse() {
    return dummyNonResponse;
  }

  /**
   * ダミー未回答か判定します。
   * 
   * @return ダミー未回答の場合true、そうでない場合false。
   */
  public boolean isDummyNonResponse() {
    return ScheduleConst.SCHEDULEMAP_DUMMY_NON_RES_T.equals(dummyNonResponse);
  }

  /**
   * 作成ユーザーIDを取得します。
   * 
   * @return 作成ユーザーID
   */
  public String getCreateUserId() {
    return create_user_id;
  }

  /**
   * 作成ユーザーIDを設定します。
   * 
   * @param value
   *          作成ユーザーID
   */
  public void setCreateUserId(String value) {
    create_user_id = value;
  }

  // add end

  // add start 要件No.16 スケジュール画面（月単位／週単位／日単位）右クリックメニュー
  public boolean isShare() {
    return is_share;
  }

  public void setShare(boolean is_share) {
    this.is_share = is_share;
  }

  // add end

  // add start No.4 スケジュール印刷（週単位）
  /**
   * 仮予定フラグを取得します。
   * 
   * @return 仮予定フラグ
   */
  public String getTemporaryFlag() {
    return temporaryFlag;
  }

  /**
   * 仮予定フラグを設定します。
   * 
   * @param value
   *          仮予定フラグ
   */
  public void setTemporaryFlag(String value) {
    temporaryFlag = value;
  }

  /**
   * 仮予定かどうかを返します。
   * 
   * スケジュール.仮予定フラグが"T"、または、スケジュールマップ.状態が"P"（仮承諾）の場合にtrueを返します。
   * 
   * @param 仮予定の場合true
   *          、仮予定でない場合false
   */
  public boolean isTemporary() {
    return (ScheduleConst.SCHEDULE_TEMPORARY_FLAG_T.equals(temporaryFlag) || isProvisional());
  }

  /**
   * 重複予定の列数を取得します。
   * 
   * @return columnCount
   */
  public int getColumnCount() {
    return columnCount;
  }

  /**
   * 重複予定の列数を設定します。
   * 
   * @param columnCount
   *          セットする 列数
   */
  public void setColumnCount(int columnCount) {
    this.columnCount = columnCount;
  }

  /**
   * 重複予定のソート番号を取得します。
   * 
   * @return sortNo
   */
  public int getSortNo() {
    return sortNo;
  }

  /**
   * 重複予定のソート番号を設定します。
   * 
   * @param sortNo
   *          セットする ソート番号
   */
  public void setSortNo(int sortNo) {
    this.sortNo = sortNo;
  }

  // add end

  // add start 要件No.26 スケジュール個別色換え
  /**
   * 個別色を返します。
   * 
   * @return 個別色（色コード）
   */
  public String getIndividualColor() {
    if (individualColor == null) {
      return "";
    } else {
      return individualColor;
    }
  }

  /**
   * 個別色を設定します。
   * 
   * @param value
   *          色コード
   */
  public void setIndividualColor(String value) {
    individualColor = value;
  }

  // add end

  // add start 要件No.18 会議案内ファイル添付
  /**
   * 添付ファイル有無を取得します。
   * 
   * @param 添付ファイル有りの場合true
   */
  public boolean hasFiles() {
    return has_files;
  }

  /**
   * 添付ファイル有無を設定します。
   * 
   * @param value
   *          添付ファイル有りの場合true
   */
  public void setFiles(boolean value) {
    this.has_files = value;
  }

  // add end

  // add start 結合試験障害16-01対応
  /**
   * 主催者フラグ（右クリック機能用のフラグ）を取得します。
   * 
   * @param 主催者の場合true
   */
  public boolean isOrganizer() {
    return is_organizer;
  }

  /**
   * 主催者フラグ（右クリック機能用のフラグ）を設定します。
   * 
   * @param value
   *          主催者の場合true
   */
  public void setOrganizer(boolean value) {
    this.is_organizer = value;
  }
  // add end
}
