/*
 * Aipo is a groupware program developed by Aimluck,Inc.
 * http://aipo.com/
 *
 * Copyright(C) 2012 avanza Co.,Ltd. All rights reserved.
 * http://www.avnz.co.jp/
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

package com.aimluck.eip.schedule;

import java.util.Calendar;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

import com.aimluck.commons.field.ALDateTimeField;

/**
 * 1日スケジュール用のユーザー別期間スケジュールのコンテナです。
 * 
 */
public class AjaxSpanScheduleUserOneDayContainer {

  /** ユーザー別期間予定マップ */
  private Map<Integer, AjaxTermScheduleDayContainer> userDayConMap = null;

  /** 基準日 */
  Calendar targetDateCalendar = null;

  /**
   * コンストラクタ
   */
  public AjaxSpanScheduleUserOneDayContainer(ALDateTimeField targetDate,
      List<Integer> userIdList) {
    // 基準日の初期化
    targetDateCalendar = Calendar.getInstance();
    if (targetDate != null) {
      targetDateCalendar.set(Calendar.YEAR, Integer.parseInt(targetDate
        .getYear()));
      targetDateCalendar.set(Calendar.MONTH, Integer.parseInt(targetDate
        .getMonth()) - 1);
      targetDateCalendar.set(Calendar.DAY_OF_MONTH, Integer.parseInt(targetDate
        .getDay()));
    }
    targetDateCalendar.set(Calendar.HOUR_OF_DAY, 0);
    targetDateCalendar.set(Calendar.MINUTE, 0);
    targetDateCalendar.set(Calendar.SECOND, 0);
    targetDateCalendar.set(Calendar.MILLISECOND, 0);

    // ユーザー別期間予定マップの初期化
    userDayConMap = new LinkedHashMap<Integer, AjaxTermScheduleDayContainer>();
    for (Integer userId : userIdList) {
      AjaxTermScheduleDayContainer sdCon = new AjaxTermScheduleDayContainer();
      sdCon.initField();
      sdCon.setDate(targetDateCalendar.getTime());
      userDayConMap.put(userId, sdCon);
    }
  }

  /**
   * 期間予定をコンテナに格納します。
   * 
   * @param userId
   *          予定所有ユーザーのユーザーID
   * @param rd
   *          予定データ
   */
  public void addSpanResultData(Integer userId, AjaxScheduleResultData rd) {
    AjaxTermScheduleDayContainer con = userDayConMap.get(userId);
    con.setHasTerm(true);
    con.setTermResultData(rd);
  }

  /**
   * ユーザー別期間予定マップを取得します。
   * 
   * @return
   * 
   * @uml.property name="dayList"
   */
  public Map<Integer, AjaxTermScheduleDayContainer> getUserDayConMap() {
    return userDayConMap;
  }

  /**
   * 表示すべき期間予定行が存在するかどうかを返します
   * 
   * @return
   */
  public boolean hasVisibleSpanRow() {
    AjaxTermScheduleDayContainer dayContainer = null;
    for (Integer userId : userDayConMap.keySet()) {
      dayContainer = userDayConMap.get(userId);
      if (dayContainer.isHasTerm()) {
        AjaxScheduleResultData rd = dayContainer.getTermResultData();
        if (rd != null
          && (!rd.isPrivate() || rd.isLoginuser() || rd.isMember())) {
          return true;
        }
      }
    }
    return false;
  }

  /**
   * 指定ユーザーの期間予定がコンテナに追加できるか（現mapに登録済みでないか）を返します。
   * 
   * @param userId
   * @return 追加できる（未登録）場合true、追加できない（登録済み）場合false
   */
  public boolean canAddSpan(Integer userId) {
    boolean result = true;

    if (userDayConMap.containsKey(userId)) {
      AjaxTermScheduleDayContainer dayContainer = userDayConMap.get(userId);
      if (dayContainer.isHasTerm()) {
        AjaxScheduleResultData rd = dayContainer.getTermResultData();
        if (rd != null
          && (!rd.isPrivate() || rd.isLoginuser() || rd.isMember())) {
          result = false;
        }
      }
    }

    return result;
  }
}
