/*
 * Aipo is a groupware program developed by Aimluck,Inc.
 * http://aipostyle.com/
 *
 * Copyright(C) 2012 avanza Co.,Ltd. All rights reserved.
 * http://www.avnz.co.jp/
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program. If not, see <http://www.gnu.org/licenses/>.
 */
package com.aimluck.eip.modules.screens;

import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.List;

import javax.servlet.http.HttpServletResponse;

import org.apache.jetspeed.services.logging.JetspeedLogFactoryService;
import org.apache.jetspeed.services.logging.JetspeedLogger;
import org.apache.turbine.modules.screens.RawScreen;
import org.apache.turbine.util.RunData;
import org.apache.velocity.VelocityContext;
import org.apache.velocity.context.Context;

import com.aimluck.eip.common.ALEipUser;
import com.aimluck.eip.fileupload.MultiFileUploadFormData;
import com.aimluck.eip.fileupload.beans.FileuploadBean;
import com.aimluck.eip.modules.actions.common.ALAction;
import com.aimluck.eip.util.ALEipUtils;

/**
 * 複数添付ファイルをアップロードを処理するクラスです。 <br />
 * 
 */
public class MultiFileUploadFlashScreen extends RawScreen implements ALAction {

  /** <code>loginUserName</code> ログインユーザー名 */
  private String loginUserName;

  private static final JetspeedLogger logger = JetspeedLogFactoryService.getLogger(MultiFileUploadFlashScreen.class.getName());

  private static final String CONTENT_TYPE = "text/plain; charset=utf-8";

  /**
   * 複数添付ファイルアップロード処理
   * 
   * @param rundata
   *          JetSpeedランデータ
   * @throws Exception
   */
  @Override
  protected void doOutput(RunData rundata) throws Exception {

    ALEipUser loginuser = ALEipUtils.getALEipUser(rundata);
    loginUserName = loginuser.getName().getValue();

    PrintWriter out = null;
    VelocityContext context = new VelocityContext();
    List<String> resultList = new ArrayList<String>(0);

    // レスポンスのコンテンツタイプを決定
    ALEipUtils.setupContext(rundata, context);
    HttpServletResponse response = rundata.getResponse();
    out = response.getWriter();
    response.setContentType(CONTENT_TYPE);

    try {

      List<FileuploadBean> uploadList = null;

      MultiFileUploadFormData formData = new MultiFileUploadFormData();
      uploadList = formData.doUpload(rundata, context);

      for (FileuploadBean bean : uploadList) {
        if (bean.isUploadSuccess()) {
          // アップロード成功の場合
          // フォルダ名
          String folderName = bean.getFolderName();
          // 添付ファイルID
          int fileId = bean.getFileId();
          // 添付ファイル名
          String fileName = bean.getFileNameEscape();
          // フォルダ名+添付ファイルIDを「：」区切り（ファイル名に使用できない文字）で渡す
          // クライアント側(javascript)で文字列を分解して処理
          resultList.add(folderName + ":" + fileId + ":" + fileName + ":" + "Complete");
        } else {
          // アップロード失敗の場合
          resultList.add(bean.getFileNameEscape() + ":" + bean.getResultMessage());
        }
      }

    } catch (Exception e) {
      logger.error("ファイルのアップロード中に例外が発生しました。ログインユーザー:" + loginUserName, e);
      resultList.add(":ファイルアップロードに失敗しました。");
    }

    // 結果リストを「/」区切りの結果文字列に変換
    String result = "";
    int index = 0;
    for (String row : resultList) {
      if (index > 0) {
        result += "/";
      }
      result += row;
      index++;
    }

    // 結果文字列をレスポンスへ出力
    out.print(result);
    out.close();
  }

  /**
   * @param arg0
   * @return
   */
  @Override
  protected String getContentType(RunData rundata) {
    return CONTENT_TYPE;
  }

  /**
   * @param msg
   */
  @Override
  public void addErrorMessage(String msg) {
  }

  /**
   * @param msgs
   */
  @Override
  public void addErrorMessages(List<String> msgs) {
  }

  /**
   * @param obj
   */
  @Override
  public void addResultData(Object obj) {
  }

  /**
   * @return
   */
  @Override
  public String getMode() {
    return null;
  }

  /**
   * @param rundata
   * @param context
   */
  @Override
  public void putData(RunData rundata, Context context) {
  }

  /**
   * @param msgs
   */
  @Override
  public void setErrorMessages(List<String> msgs) {
  }

  /**
   * @param mode
   */
  @Override
  public void setMode(String mode) {
  }

  /**
   * @param obj
   */
  @Override
  public void setResultData(Object obj) {
  }

  /**
   * @param objList
   */
  @Override
  public void setResultDataList(List<Object> objList) {
  }
}
