/*
 * Aipo is a groupware program developed by Aimluck,Inc.
 * http://aipostyle.com/
 * 
 * Copyright(C) 2011 avanza Co.,Ltd. All rights reserved.
 * http://www.avnz.co.jp/
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program. If not, see <http://www.gnu.org/licenses/>.
 */
package com.aimluck.eip.account;

import java.util.ArrayList;
import java.util.List;
import java.util.jar.Attributes;

import org.apache.jetspeed.services.logging.JetspeedLogFactoryService;
import org.apache.jetspeed.services.logging.JetspeedLogger;
import org.apache.turbine.util.RunData;
import org.apache.velocity.context.Context;

import com.aimluck.eip.account.util.AccountUtils;
import com.aimluck.eip.cayenne.om.account.AvzMGroupsend;
import com.aimluck.eip.cayenne.om.account.AvzMGroupsendPosition;
import com.aimluck.eip.common.ALAbstractSelectData;
import com.aimluck.eip.common.ALDBErrorException;
import com.aimluck.eip.common.ALData;
import com.aimluck.eip.common.ALEipUser;
import com.aimluck.eip.common.ALPageNotFoundException;
import com.aimluck.eip.modules.actions.common.ALAction;
import com.aimluck.eip.orm.Database;
import com.aimluck.eip.orm.query.ResultList;
import com.aimluck.eip.orm.query.SelectQuery;
import com.aimluck.eip.util.ALEipUtils;

/**
 * グループ送信情報の検索データを管理するクラスです。 <BR>
 * 
 */
public class AccountGroupSendSelectData extends
    ALAbstractSelectData<AvzMGroupsend, AvzMGroupsend> implements ALData {

  /** logger */
  private static final JetspeedLogger logger =
    JetspeedLogFactoryService.getLogger(AccountGroupSendSelectData.class
      .getName());

  /** 所属者リスト */
  public List<ALEipUser> memberList = new ArrayList<ALEipUser>(0);

  /**
   * 初期処理
   * 
   * @param action
   *            アクションクラス
   * @param rundata
   *            JetSpeedランデータ
   * @param context
   *            JetSpeedコンテキスト
   * @see com.aimluck.eip.common.ALAbstractSelectData#init(com.aimluck.eip.modules.actions.common.ALAction,
   *      org.apache.turbine.util.RunData, org.apache.velocity.context.Context)
   */
  @Override
  public void init(ALAction action, RunData rundata, Context context)
      throws ALPageNotFoundException, ALDBErrorException {
    super.init(action, rundata, context);
  }

  /**
   * 一覧データを取得します。 <BR>
   * 
   * @param rundata
   *            JetSpeedランデータ
   * @param context
   *            JetSpeedコンテキスト
   * @return 結果リスト
   * @see com.aimluck.eip.common.ALAbstractListData#selectData(org.apache.turbine.util.RunData,
   *      org.apache.velocity.context.Context)
   */
  @Override
  public ResultList<AvzMGroupsend> selectList(RunData rundata, Context context) {
    try {

      SelectQuery<AvzMGroupsend> query = getSelectQuery(rundata, context);
      buildSelectQueryForListView(query);

      ResultList<AvzMGroupsend> list = query.getResultList();
      return list;
    } catch (Exception ex) {
      logger.error("グループ送信情報の一覧取得に失敗しました。", ex);
      return null;
    }
  }

  /**
   * 検索条件を設定した SelectQuery を返します。 <BR>
   * 
   * @param rundata
   *            JetSpeedランデータ
   * @param context
   *            JetSpeedコンテキスト
   * @return SQLオブジェクト
   */
  private SelectQuery<AvzMGroupsend> getSelectQuery(RunData rundata,
      Context context) {
    SelectQuery<AvzMGroupsend> query = Database.query(AvzMGroupsend.class);
    query.orderAscending(AvzMGroupsend.AVZ_MGROUPSEND_POSITION_ARRAY_PROPERTY
      + "."
      + AvzMGroupsendPosition.POSITION_PROPERTY);
    return buildSelectQueryForFilter(query, rundata, context);
  }

  /**
   * ResultData に値を格納して返します。（一覧データ） <BR>
   * 
   * @param obj
   *            DBから取得したグループ送信情報
   * @return 画面表示用データ
   * @see com.aimluck.eip.common.ALAbstractSelectData#getListData(java.lang.Object)
   */
  @Override
  protected Object getResultData(AvzMGroupsend obj) {

    AvzMGroupsend record = obj;

    AccountGroupSendResultData rd = new AccountGroupSendResultData();
    rd.initField();
    rd.setGroupsendId(record.getGroupsendId());
    rd.setGroupsendName(record.getGroupsendName());
    if (AvzMGroupsend.GROUPSEND_CATEGORY_POST.equals(record.getCategory())) {
      rd.setCategory(AccountUtils.GROUPSEND_CATEGORY_POST_NAME);
    } else {
      rd.setCategory("");
    }
    return rd;
  }

  /**
   * 詳細データを取得します。 <BR>
   * 
   * @param rundata
   *            JetSpeedランデータ
   * @param context
   *            JetSpeedコンテキスト
   * @return ＤＢから取得したグループ送信情報
   * @see com.aimluck.eip.common.ALAbstractSelectData#selectDetail(org.apache.turbine.util.RunData,
   *      org.apache.velocity.context.Context)
   */
  @Override
  public AvzMGroupsend selectDetail(RunData rundata, Context context)
      throws ALPageNotFoundException {
    try {
      AvzMGroupsend groupsend = AccountUtils.getAvzMGroupsend(rundata, context);
      memberList = ALEipUtils.getUsers(groupsend.getGroupsendId().toString());

      return groupsend;
    } catch (Exception e) {
      logger.error("グループ送信情報の詳細取得に失敗しました。", e);
      throw new ALPageNotFoundException();
    }
  }

  /**
   * ResultData に値を格納して返します。（詳細データ） <BR>
   * 
   * @param obj
   *            DBから取得したグループ送信情報
   * @return 画面表示用グループ送信情報
   * @see com.aimluck.eip.common.ALAbstractSelectData#getResultDataDetail(java.lang.Object)
   */
  @Override
  protected Object getResultDataDetail(AvzMGroupsend obj) {
    return getResultData(obj);
  }

  /**
   * ※未使用
   */
  @Override
  protected Attributes getColumnMap() {
    Attributes map = new Attributes();
    return map;
  }

  /**
   * ※未使用
   */
  @Override
  public String getAclPortletFeature() {
    return null;
  }

  /**
   * あるグループに所属するメンバーのリストを取得します
   * 
   * @param groupname
   *            グループ送信ＩＤ
   * @return 所属メンバーリスト
   */
  public List<ALEipUser> getMemberListByGroup() {
    return memberList;
  }
}
