/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.builder;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PushbackInputStream;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.Iterator;
import java.util.Map;
import javax.activation.DataHandler;
import javax.xml.namespace.QName;
import javax.xml.parsers.FactoryConfigurationError;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.apache.axiom.attachments.Attachments;
import org.apache.axiom.attachments.lifecycle.LifecycleManager;
import org.apache.axiom.attachments.lifecycle.impl.LifecycleManagerImpl;
import org.apache.axiom.attachments.utils.IOUtils;
import org.apache.axiom.om.OMAttribute;
import org.apache.axiom.om.OMContainer;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMException;
import org.apache.axiom.om.OMFactory;
import org.apache.axiom.om.OMNamespace;
import org.apache.axiom.om.OMNode;
import org.apache.axiom.om.OMText;
import org.apache.axiom.om.impl.builder.StAXBuilder;
import org.apache.axiom.om.impl.builder.StAXOMBuilder;
import org.apache.axiom.om.impl.builder.XOPAwareStAXOMBuilder;
import org.apache.axiom.om.util.StAXUtils;
import org.apache.axiom.soap.SOAPBody;
import org.apache.axiom.soap.SOAPEnvelope;
import org.apache.axiom.soap.SOAPFactory;
import org.apache.axiom.soap.SOAPProcessingException;
import org.apache.axiom.soap.impl.builder.MTOMStAXSOAPModelBuilder;
import org.apache.axiom.soap.impl.builder.StAXSOAPModelBuilder;
import org.apache.axis2.AxisFault;
import org.apache.axis2.builder.Builder;
import org.apache.axis2.context.MessageContext;
import org.apache.axis2.description.AxisMessage;
import org.apache.axis2.description.AxisOperation;
import org.apache.axis2.description.Parameter;
import org.apache.axis2.engine.AxisConfiguration;
import org.apache.axis2.java.security.AccessController;
import org.apache.axis2.transport.http.HTTPConstants;
import org.apache.axis2.util.JavaUtils;
import org.apache.axis2.util.MultipleEntryHashMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.ws.commons.schema.XmlSchemaAll;
import org.apache.ws.commons.schema.XmlSchemaComplexType;
import org.apache.ws.commons.schema.XmlSchemaElement;
import org.apache.ws.commons.schema.XmlSchemaGroupBase;
import org.apache.ws.commons.schema.XmlSchemaParticle;
import org.apache.ws.commons.schema.XmlSchemaSequence;
import org.apache.ws.commons.schema.XmlSchemaType;
import org.apache.ws.commons.schema.constants.Constants;

public class BuilderUtil {
    private static final Log log = LogFactory.getLog((Class)BuilderUtil.class);
    public static final int BOM_SIZE = 4;

    public static SOAPEnvelope buildsoapMessage(MessageContext messageContext, MultipleEntryHashMap requestParameterMap, SOAPFactory soapFactory) throws AxisFault {
        SOAPEnvelope soapEnvelope = soapFactory.getDefaultEnvelope();
        SOAPBody body = soapEnvelope.getBody();
        XmlSchemaElement xmlSchemaElement = null;
        AxisOperation axisOperation = messageContext.getAxisOperation();
        if (axisOperation != null) {
            AxisMessage axisMessage = axisOperation.getMessage("In");
            xmlSchemaElement = axisMessage.getSchemaElement();
            if (xmlSchemaElement == null) {
                OMElement bodyFirstChild = soapFactory.createOMElement(messageContext.getAxisOperation().getName(), (OMContainer)body);
                BuilderUtil.createSOAPMessageWithoutSchema(soapFactory, messageContext, bodyFirstChild, requestParameterMap);
            } else {
                XmlSchemaComplexType complexType;
                XmlSchemaParticle particle;
                String targetNamespace = xmlSchemaElement.getQName().getNamespaceURI();
                QName bodyFirstChildQName = targetNamespace != null && !"".equals(targetNamespace) ? new QName(targetNamespace, xmlSchemaElement.getName()) : new QName(xmlSchemaElement.getName());
                OMElement bodyFirstChild = soapFactory.createOMElement(bodyFirstChildQName, (OMContainer)body);
                XmlSchemaType schemaType = xmlSchemaElement.getSchemaType();
                if (schemaType instanceof XmlSchemaComplexType && ((particle = (complexType = (XmlSchemaComplexType)schemaType).getParticle()) instanceof XmlSchemaSequence || particle instanceof XmlSchemaAll)) {
                    XmlSchemaGroupBase xmlSchemaGroupBase = (XmlSchemaGroupBase)particle;
                    Iterator iterator = xmlSchemaGroupBase.getItems().getIterator();
                    while (iterator.hasNext()) {
                        Object value;
                        OMNamespace ns;
                        XmlSchemaElement innerElement = (XmlSchemaElement)iterator.next();
                        QName qName = innerElement.getQName();
                        if (qName == null && innerElement.getSchemaTypeName().equals(Constants.XSD_ANYTYPE)) {
                            BuilderUtil.createSOAPMessageWithoutSchema(soapFactory, messageContext, bodyFirstChild, requestParameterMap);
                            break;
                        }
                        long minOccurs = innerElement.getMinOccurs();
                        boolean nillable = innerElement.isNillable();
                        String name = qName != null ? qName.getLocalPart() : innerElement.getName();
                        OMNamespace oMNamespace = ns = qName == null || qName.getNamespaceURI() == null || qName.getNamespaceURI().length() == 0 ? null : soapFactory.createOMNamespace(qName.getNamespaceURI(), null);
                        while ((value = requestParameterMap.get(name)) != null) {
                            BuilderUtil.addRequestParameter(soapFactory, bodyFirstChild, ns, name, value);
                            --minOccurs;
                        }
                        if (minOccurs <= 0L) continue;
                        if (nillable) {
                            OMNamespace xsi = soapFactory.createOMNamespace("http://www.w3.org/2001/XMLSchema-instance", "xsi");
                            OMAttribute omAttribute = soapFactory.createOMAttribute("nil", xsi, "true");
                            soapFactory.createOMElement(name, ns, (OMContainer)bodyFirstChild).addAttribute(omAttribute);
                            continue;
                        }
                        throw new AxisFault("Required element " + qName + " defined in the schema can not be found in the request");
                    }
                }
            }
        }
        return soapEnvelope;
    }

    private static void createSOAPMessageWithoutSchema(SOAPFactory soapFactory, MessageContext messageContext, OMElement bodyFirstChild, MultipleEntryHashMap requestParameterMap) {
        if (requestParameterMap != null) {
            Iterator requestParamMapIter = requestParameterMap.keySet().iterator();
            while (requestParamMapIter.hasNext()) {
                String key = (String)requestParamMapIter.next();
                Object value = requestParameterMap.get(key);
                if (value == null) continue;
                BuilderUtil.addRequestParameter(soapFactory, bodyFirstChild, null, key, value);
            }
        }
    }

    private static void addRequestParameter(SOAPFactory soapFactory, OMElement bodyFirstChild, OMNamespace ns, String key, Object parameter) {
        if (parameter instanceof DataHandler) {
            DataHandler dataHandler = (DataHandler)parameter;
            OMText dataText = bodyFirstChild.getOMFactory().createOMText((Object)dataHandler, true);
            soapFactory.createOMElement(key, ns, (OMContainer)bodyFirstChild).addChild((OMNode)dataText);
        } else {
            String textValue = parameter.toString();
            soapFactory.createOMElement(key, ns, (OMContainer)bodyFirstChild).setText(textValue);
        }
    }

    public static StAXBuilder getPOXBuilder(InputStream inStream, String charSetEnc) throws XMLStreamException {
        XMLStreamReader xmlreader = StAXUtils.createXMLStreamReader((InputStream)inStream, (String)charSetEnc);
        StAXOMBuilder builder = new StAXOMBuilder(xmlreader);
        return builder;
    }

    public static Reader getReader(InputStream is, String charSetEncoding) throws IOException {
        final PushbackInputStream is2 = BuilderUtil.getPushbackInputStream(is);
        final String encoding = BuilderUtil.getCharSetEncoding(is2, charSetEncoding);
        InputStreamReader inputStreamReader = null;
        try {
            inputStreamReader = (InputStreamReader)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() throws UnsupportedEncodingException {
                    return new InputStreamReader((InputStream)is2, encoding);
                }
            });
        }
        catch (PrivilegedActionException e) {
            throw (UnsupportedEncodingException)e.getException();
        }
        return new BufferedReader(inputStreamReader);
    }

    public static PushbackInputStream getPushbackInputStream(InputStream is) {
        return new PushbackInputStream(is, 4);
    }

    public static String getCharSetEncoding(PushbackInputStream is2, String defaultEncoding) throws IOException {
        int unread;
        String encoding;
        byte[] bom = new byte[4];
        int n = is2.read(bom, 0, bom.length);
        if (bom[0] == -17 && bom[1] == -69 && bom[2] == -65) {
            encoding = "UTF-8";
            if (log.isDebugEnabled()) {
                log.debug((Object)("char set encoding set from BOM =" + encoding));
            }
            unread = n - 3;
        } else if (bom[0] == -2 && bom[1] == -1) {
            encoding = "UTF-16BE";
            if (log.isDebugEnabled()) {
                log.debug((Object)("char set encoding set from BOM =" + encoding));
            }
            unread = n - 2;
        } else if (bom[0] == -1 && bom[1] == -2) {
            encoding = "UTF-16LE";
            if (log.isDebugEnabled()) {
                log.debug((Object)("char set encoding set from BOM =" + encoding));
            }
            unread = n - 2;
        } else if (bom[0] == 0 && bom[1] == 0 && bom[2] == -2 && bom[3] == -1) {
            encoding = "UTF-32BE";
            if (log.isDebugEnabled()) {
                log.debug((Object)("char set encoding set from BOM =" + encoding));
            }
            unread = n - 4;
        } else if (bom[0] == -1 && bom[1] == -2 && bom[2] == 0 && bom[3] == 0) {
            encoding = "UTF-32LE";
            if (log.isDebugEnabled()) {
                log.debug((Object)("char set encoding set from BOM =" + encoding));
            }
            unread = n - 4;
        } else {
            encoding = defaultEncoding;
            if (log.isDebugEnabled()) {
                log.debug((Object)("char set encoding set from default =" + encoding));
            }
            unread = n;
        }
        if (unread > 0) {
            is2.unread(bom, n - unread, unread);
        }
        return encoding;
    }

    public static String getEnvelopeNamespace(String contentType) {
        String soapNS = "http://schemas.xmlsoap.org/soap/envelope/";
        if (contentType != null) {
            if (contentType.indexOf("application/soap+xml") > -1) {
                soapNS = "http://www.w3.org/2003/05/soap-envelope";
            } else if (contentType.indexOf("text/xml") > -1) {
                soapNS = "http://schemas.xmlsoap.org/soap/envelope/";
            }
        }
        return soapNS;
    }

    public static String getCharSetEncoding(String contentType) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Input contentType (" + contentType + ")"));
        }
        if (contentType == null) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"CharSetEncoding defaulted (UTF-8)");
            }
            return "UTF-8";
        }
        int index = contentType.indexOf(HTTPConstants.CHAR_SET_ENCODING);
        if (index == -1) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"CharSetEncoding defaulted (UTF-8)");
            }
            return "UTF-8";
        }
        int indexOfEq = contentType.indexOf("=", index);
        int indexOfSemiColon = contentType.indexOf(";", indexOfEq);
        String value = indexOfSemiColon > 0 ? contentType.substring(indexOfEq + 1, indexOfSemiColon) : contentType.substring(indexOfEq + 1, contentType.length()).trim();
        if (value.indexOf(34) != -1) {
            value = value.replaceAll("\"", "");
        }
        value = value.trim();
        if (log.isDebugEnabled()) {
            log.debug((Object)("CharSetEncoding from content-type (" + value + ")"));
        }
        return value;
    }

    public static StAXBuilder getAttachmentsBuilder(MessageContext msgContext, InputStream inStream, String contentTypeString, boolean isSOAP) throws OMException, XMLStreamException, FactoryConfigurationError {
        XMLStreamReader streamReader;
        MTOMStAXSOAPModelBuilder builder = null;
        Attachments attachments = BuilderUtil.createAttachmentsMap(msgContext, inStream, contentTypeString);
        String charSetEncoding = BuilderUtil.getCharSetEncoding(attachments.getSOAPPartContentType());
        if (charSetEncoding == null || "null".equalsIgnoreCase(charSetEncoding)) {
            charSetEncoding = "UTF-8";
        }
        msgContext.setProperty("CHARACTER_SET_ENCODING", charSetEncoding);
        try {
            PushbackInputStream pis = BuilderUtil.getPushbackInputStream(attachments.getSOAPPartInputStream());
            String actualCharSetEncoding = BuilderUtil.getCharSetEncoding(pis, charSetEncoding);
            streamReader = StAXUtils.createXMLStreamReader((InputStream)pis, (String)actualCharSetEncoding);
        }
        catch (IOException e) {
            throw new XMLStreamException(e);
        }
        msgContext.setProperty("Attachments", attachments);
        msgContext.setAttachmentMap(attachments);
        String soapEnvelopeNamespaceURI = BuilderUtil.getEnvelopeNamespace(contentTypeString);
        if (isSOAP) {
            if (attachments.getAttachmentSpecType().equals("application/xop+xml")) {
                builder = new MTOMStAXSOAPModelBuilder(streamReader, attachments, soapEnvelopeNamespaceURI);
                msgContext.setDoingMTOM(true);
            } else if (attachments.getAttachmentSpecType().equals("text/xml")) {
                builder = new StAXSOAPModelBuilder(streamReader, soapEnvelopeNamespaceURI);
            } else if (attachments.getAttachmentSpecType().equals("application/soap+xml")) {
                builder = new StAXSOAPModelBuilder(streamReader, soapEnvelopeNamespaceURI);
            }
        } else if (attachments.getAttachmentSpecType().equals("application/xop+xml")) {
            XOPAwareStAXOMBuilder stAXOMBuilder = new XOPAwareStAXOMBuilder(streamReader, attachments);
            builder = stAXOMBuilder;
        } else if (attachments.getAttachmentSpecType().equals("text/xml")) {
            builder = new StAXOMBuilder(streamReader);
        } else if (attachments.getAttachmentSpecType().equals("application/soap+xml")) {
            builder = new StAXOMBuilder(streamReader);
        }
        return builder;
    }

    protected static Attachments createAttachmentsMap(MessageContext msgContext, InputStream inStream, String contentTypeString) {
        int contentLength;
        String attachmentSizeThreshold;
        String attachmentRepoDir;
        boolean fileCacheForAttachments;
        block9: {
            String contentLengthValue;
            fileCacheForAttachments = BuilderUtil.isAttachmentsCacheEnabled(msgContext);
            attachmentRepoDir = null;
            attachmentSizeThreshold = null;
            if (fileCacheForAttachments) {
                Parameter attachmentRepoDirParameter;
                Object attachmentRepoDirProperty = msgContext.getProperty("attachmentDIR");
                attachmentRepoDir = attachmentRepoDirProperty != null ? (String)attachmentRepoDirProperty : ((attachmentRepoDirParameter = msgContext.getParameter("attachmentDIR")) != null ? (String)attachmentRepoDirParameter.getValue() : null);
                Object attachmentSizeThresholdProperty = msgContext.getProperty("sizeThreshold");
                if (attachmentSizeThresholdProperty != null && attachmentSizeThresholdProperty instanceof String) {
                    attachmentSizeThreshold = (String)attachmentSizeThresholdProperty;
                } else {
                    Parameter attachmentSizeThresholdParameter = msgContext.getParameter("sizeThreshold");
                    attachmentSizeThreshold = attachmentSizeThresholdParameter.getValue().toString();
                }
            }
            contentLength = 0;
            Map headers = (Map)msgContext.getProperty("TRANSPORT_HEADERS");
            if (headers != null && (contentLengthValue = (String)headers.get("Content-Length")) != null) {
                try {
                    contentLength = new Integer(contentLengthValue);
                }
                catch (NumberFormatException e) {
                    if (!log.isDebugEnabled()) break block9;
                    log.debug((Object)("Content-Length is not a valid number.  Will assume it is not set:" + e));
                }
            }
        }
        if (log.isDebugEnabled()) {
            if (contentLength > 0) {
                log.debug((Object)("Creating an Attachments map.  The content-length is" + contentLength));
            } else {
                log.debug((Object)"Creating an Attachments map.");
            }
        }
        return BuilderUtil.createAttachments(msgContext, inStream, contentTypeString, fileCacheForAttachments, attachmentRepoDir, attachmentSizeThreshold, contentLength);
    }

    public static boolean isAttachmentsCacheEnabled(MessageContext msgContext) {
        boolean fileCacheForAttachments;
        Object cacheAttachmentProperty = msgContext.getProperty("cacheAttachments");
        String cacheAttachmentString = null;
        if (cacheAttachmentProperty != null && cacheAttachmentProperty instanceof String) {
            cacheAttachmentString = (String)cacheAttachmentProperty;
            fileCacheForAttachments = "true".equals(cacheAttachmentString);
        } else {
            Parameter parameter_cache_attachment = msgContext.getParameter("cacheAttachments");
            cacheAttachmentString = parameter_cache_attachment != null ? (String)parameter_cache_attachment.getValue() : null;
        }
        fileCacheForAttachments = "true".equals(cacheAttachmentString);
        return fileCacheForAttachments;
    }

    public static Attachments createAttachments(MessageContext msgContext, InputStream inStream, String contentTypeString, boolean fileCacheForAttachments, String attachmentRepoDir, String attachmentSizeThreshold, int contentLength) {
        LifecycleManager manager;
        block3: {
            manager = null;
            try {
                AxisConfiguration configuration = msgContext.getRootContext().getAxisConfiguration();
                manager = (LifecycleManager)configuration.getParameterValue("attachmentsLifecycleManager");
                if (manager == null) {
                    manager = new LifecycleManagerImpl();
                    configuration.addParameter("attachmentsLifecycleManager", manager);
                }
            }
            catch (Exception e) {
                if (!log.isDebugEnabled()) break block3;
                log.debug((Object)"Exception getting Attachments LifecycleManager", (Throwable)e);
            }
        }
        return new Attachments(manager, inStream, contentTypeString, fileCacheForAttachments, attachmentRepoDir, attachmentSizeThreshold, contentLength);
    }

    public static StAXBuilder getBuilder(Reader in) throws XMLStreamException {
        XMLStreamReader xmlreader = StAXUtils.createXMLStreamReader((Reader)in);
        StAXSOAPModelBuilder builder = new StAXSOAPModelBuilder(xmlreader, null);
        return builder;
    }

    public static StAXBuilder getBuilder(InputStream inStream) throws XMLStreamException {
        XMLStreamReader xmlReader = StAXUtils.createXMLStreamReader((InputStream)inStream);
        return new StAXOMBuilder(xmlReader);
    }

    public static StAXBuilder getBuilder(InputStream inStream, String charSetEnc) throws XMLStreamException {
        XMLStreamReader xmlReader = StAXUtils.createXMLStreamReader((InputStream)inStream, (String)charSetEnc);
        try {
            StAXSOAPModelBuilder builder = new StAXSOAPModelBuilder(xmlReader);
            return builder;
        }
        catch (OMException e) {
            log.info((Object)"OMException in getSOAPBuilder", (Throwable)e);
            try {
                log.info((Object)("Remaining input stream :[" + new String(IOUtils.getStreamAsByteArray((InputStream)inStream), charSetEnc) + "]"));
            }
            catch (IOException e1) {
                // empty catch block
            }
            throw e;
        }
    }

    public static StAXBuilder getSOAPBuilder(InputStream inStream) throws XMLStreamException {
        XMLStreamReader xmlReader = StAXUtils.createXMLStreamReader((InputStream)inStream);
        try {
            StAXSOAPModelBuilder builder = new StAXSOAPModelBuilder(xmlReader);
            return builder;
        }
        catch (OMException e) {
            log.info((Object)"OMException in getSOAPBuilder", (Throwable)e);
            try {
                log.info((Object)("Remaining input stream :[" + new String(IOUtils.getStreamAsByteArray((InputStream)inStream)) + "]"));
            }
            catch (IOException iOException) {
                // empty catch block
            }
            throw e;
        }
    }

    public static StAXBuilder getSOAPBuilder(InputStream inStream, String charSetEnc) throws XMLStreamException {
        XMLStreamReader xmlReader = StAXUtils.createXMLStreamReader((InputStream)inStream, (String)charSetEnc);
        try {
            StAXSOAPModelBuilder builder = new StAXSOAPModelBuilder(xmlReader);
            return builder;
        }
        catch (OMException e) {
            log.info((Object)"OMException in getSOAPBuilder", (Throwable)e);
            try {
                log.info((Object)("Remaining input stream :[" + new String(IOUtils.getStreamAsByteArray((InputStream)inStream), charSetEnc) + "]"));
            }
            catch (IOException e1) {
                // empty catch block
            }
            throw e;
        }
    }

    public static StAXBuilder getBuilder(SOAPFactory soapFactory, InputStream in, String charSetEnc) throws XMLStreamException {
        XMLStreamReader xmlreader = StAXUtils.createXMLStreamReader((InputStream)in, (String)charSetEnc);
        StAXOMBuilder builder = new StAXOMBuilder((OMFactory)soapFactory, xmlreader);
        return builder;
    }

    public static Builder getBuilderFromSelector(String type, MessageContext msgContext) throws AxisFault {
        AxisConfiguration configuration = msgContext.getConfigurationContext().getAxisConfiguration();
        Builder builder = configuration.getMessageBuilder(type);
        if (builder == null) {
            builder = configuration.getMessageBuilder(type.toLowerCase());
        }
        if (builder != null) {
            String acceptHeader;
            Map transportHeaders;
            Object contentNegotiation = configuration.getParameterValue("httpContentNegotiation");
            if (JavaUtils.isTrueExplicitly(contentNegotiation) && (transportHeaders = (Map)msgContext.getProperty("TRANSPORT_HEADERS")) != null && (acceptHeader = (String)transportHeaders.get("Accept")) != null) {
                int index = acceptHeader.indexOf(";");
                if (index > 0) {
                    acceptHeader = acceptHeader.substring(0, index);
                }
                String[] strings = acceptHeader.split(",");
                for (int i = 0; i < strings.length; ++i) {
                    String accept = strings[i].trim();
                    if ("text/xml".equals(accept) || configuration.getMessageFormatter(accept) == null) continue;
                    type = strings[i];
                    break;
                }
            }
            msgContext.setProperty("messageType", type);
        }
        return builder;
    }

    public static void validateSOAPVersion(String soapNamespaceURIFromTransport, SOAPEnvelope envelope) {
        OMNamespace envelopeNamespace;
        String namespaceName;
        if (soapNamespaceURIFromTransport != null && !soapNamespaceURIFromTransport.equals(namespaceName = (envelopeNamespace = envelope.getNamespace()).getNamespaceURI())) {
            throw new SOAPProcessingException("Transport level information does not match with SOAP Message namespace URI", envelopeNamespace.getPrefix() + ":" + "VersionMismatch");
        }
    }

    public static void validateCharSetEncoding(String charsetEncodingFromTransport, String charsetEncodingFromXML, String soapNamespaceURI) throws AxisFault {
        if (!(charsetEncodingFromXML == null || "".equals(charsetEncodingFromXML) || charsetEncodingFromTransport == null || charsetEncodingFromXML.equalsIgnoreCase(charsetEncodingFromTransport) || BuilderUtil.isValidPair(charsetEncodingFromXML, charsetEncodingFromTransport))) {
            String faultCode = "http://www.w3.org/2003/05/soap-envelope".equals(soapNamespaceURI) ? "Sender" : "Client";
            throw new AxisFault("Character Set Encoding from transport information [" + charsetEncodingFromTransport + "] does not match with " + "character set encoding in the received SOAP message [" + charsetEncodingFromXML + "]", faultCode);
        }
    }

    private static boolean isValidPair(String enc1, String enc2) {
        enc1 = enc1.toLowerCase();
        enc2 = enc2.toLowerCase();
        if (enc1.endsWith("be") || enc1.endsWith("le")) {
            enc1 = enc1.substring(0, enc1.length() - 2);
        }
        if (enc2.endsWith("be") || enc2.endsWith("le")) {
            enc2 = enc2.substring(0, enc2.length() - 2);
        }
        return enc1.equals(enc2);
    }
}

