/*
 * The MIT License

   Conograph (powder auto-indexing program)

Copyright (c) <2012> <Ryoko Oishi-Tomiyasu, KEK>

Permission is hereby granted, free of charge, to any person obtaining a copy
of this software and associated documentation files (the "Software"), to deal
in the Software without restriction, including without limitation the rights
to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
copies of the Software, and to permit persons to whom the Software is
furnished to do so, subject to the following conditions:

The above copyright notice and this permission notice shall be included in
all copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
THE SOFTWARE.
 *
 */
#ifndef IBRAVAISLATTICE_HH_
#define IBRAVAISLATTICE_HH_

#include"../RietveldAnalysisTypes.hh"
#include"enumBravaisLattice.hh"
#include"../symmetric_operation/MillerIndex.hh"
#include"../symmetric_operation/XYZCoord.hh"
#include"../symmetric_operation/S1.hh"

// Class of Bravais Lattice.
class IBravaisLattice
{
public:
	virtual const string& Name() const = 0;
	virtual const XYZCoord<S1>* putTranslationVector(Int4&) const = 0;
	virtual Int4 putSTFactorBlavaisLatticeCoef(const MillerIndex3&) const = 0;
	virtual ~IBravaisLattice(){};

	template<class T>
	Int4 putEquivalentPosition(const XYZCoord<T>&, vector< XYZCoord<T> >&) const;

};

template<class T>
Int4 IBravaisLattice::putEquivalentPosition(const XYZCoord<T>& xyz, vector< XYZCoord<T> >& xyz_equiv) const
{
	Int4 num; 
	const XYZCoord<S1>* trans_vec = putTranslationVector(num);

	xyz_equiv.resize(num);
	for(Int4 k=0; k<num; k++) xyz_equiv[k] = xyz + trans_vec[k];
	return num; 
}
#endif /*IBRAVAISLATTICE_H_*/
