/*
 * The MIT License

   Conograph (powder auto-indexing program)

Copyright (c) <2012> <Ryoko Oishi-Tomiyasu, KEK>

Permission is hereby granted, free of charge, to any person obtaining a copy
of this software and associated documentation files (the "Software"), to deal
in the Software without restriction, including without limitation the rights
to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
copies of the Software, and to permit persons to whom the Software is
furnished to do so, subject to the following conditions:

The above copyright notice and this permission notice shall be included in
all copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
THE SOFTWARE.
 *
 */
#ifndef PUTXYZ_STR_S1_HH_
#define PUTXYZ_STR_S1_HH_

#include "../RietveldAnalysisTypes.hh"
#include "../utility_data_structure/VecDat3.hh"
#include "../utility_data_structure/index_set.hh"
#include "StringS1.hh"
#include "SymmetricOperation.hh"
#include "XYZCoord.hh"

XYZCoord<StringS1> putXYZ(const VecDat3<Double>& pos, const Mat_DP_constr& pos_constr);

const XYZCoord<StringS1>& putXYZ();

inline string toString(const SymmetricOperation& rhs)
{
	const XYZCoord<StringS1> ans = putXYZ() * rhs;
	return ans[0].toString()+","+ans[1].toString()+","+ans[2].toString();
}

#endif /*PUTXYZ_STR_S1_HH_*/

