/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.server.spi.config.jsonwriter;

import com.google.api.server.spi.EndpointMethod;
import com.google.api.server.spi.ObjectMapperUtil;
import com.google.api.server.spi.TypeLoader;
import com.google.api.server.spi.config.ApiAuthConfig;
import com.google.api.server.spi.config.ApiCacheControlConfig;
import com.google.api.server.spi.config.ApiClassConfig;
import com.google.api.server.spi.config.ApiConfig;
import com.google.api.server.spi.config.ApiConfigException;
import com.google.api.server.spi.config.ApiConfigWriter;
import com.google.api.server.spi.config.ApiFrontendLimitsConfig;
import com.google.api.server.spi.config.ApiKey;
import com.google.api.server.spi.config.ApiMethodConfig;
import com.google.api.server.spi.config.ApiNamespaceConfig;
import com.google.api.server.spi.config.ApiParameterConfig;
import com.google.api.server.spi.config.ResourcePropertySchema;
import com.google.api.server.spi.config.ResourceSchema;
import com.google.api.server.spi.config.annotationreader.ApiAnnotationIntrospector;
import com.google.api.server.spi.config.jsonwriter.JacksonResourceSchemaProvider;
import com.google.api.server.spi.config.jsonwriter.ResourceSchemaProvider;
import com.google.api.server.spi.config.validation.ApiConfigValidator;
import com.google.api.server.spi.config.validation.InvalidReturnTypeException;
import com.google.api.server.spi.config.validation.PropertyParameterNameConflictException;
import com.google.appengine.repackaged.com.google.common.annotations.VisibleForTesting;
import com.google.appengine.repackaged.com.google.common.base.Function;
import com.google.appengine.repackaged.com.google.common.collect.ImmutableListMultimap;
import com.google.appengine.repackaged.com.google.common.collect.Iterables;
import com.google.appengine.repackaged.com.google.common.collect.Maps;
import com.google.appengine.repackaged.com.google.common.collect.Multimaps;
import com.google.appengine.repackaged.org.codehaus.jackson.JsonGenerationException;
import com.google.appengine.repackaged.org.codehaus.jackson.JsonNode;
import com.google.appengine.repackaged.org.codehaus.jackson.map.JsonMappingException;
import com.google.appengine.repackaged.org.codehaus.jackson.map.ObjectMapper;
import com.google.appengine.repackaged.org.codehaus.jackson.node.ArrayNode;
import com.google.appengine.repackaged.org.codehaus.jackson.node.ObjectNode;
import java.io.IOException;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class JsonConfigWriter
implements ApiConfigWriter {
    private static final double DEFAULT_LILY_DEADLINE = 10.0;
    public static final String MAP_SCHEMA_NAME = "JsonMap";
    public static final String ANY_SCHEMA_NAME = "_any";
    private final TypeLoader typeLoader;
    private final ApiConfigValidator validator;
    private final ResourceSchemaProvider resourceSchemaProvider = new JacksonResourceSchemaProvider();
    private static final ObjectMapper objectMapper = ObjectMapperUtil.createStandardObjectMapper();

    public JsonConfigWriter() throws ClassNotFoundException {
        this(JsonConfigWriter.class.getClassLoader(), new ApiConfigValidator());
    }

    public JsonConfigWriter(ClassLoader classLoader, ApiConfigValidator validator) throws ClassNotFoundException {
        this.typeLoader = new TypeLoader(classLoader);
        this.validator = validator;
    }

    @Override
    public Map<ApiKey, String> writeConfig(Iterable<? extends ApiConfig> configs) throws ApiConfigException {
        ImmutableListMultimap apisByKey = Multimaps.index(configs, (Function)new Function<ApiConfig, ApiKey>(){

            public ApiKey apply(ApiConfig config) {
                return config.getApiKey();
            }
        });
        LinkedHashMap results = Maps.newLinkedHashMap();
        for (ApiKey apiKey : apisByKey.keySet()) {
            Collection apiConfigs = apisByKey.get((Object)apiKey);
            this.validator.validate(apiConfigs);
            results.put(apiKey, this.generateForApi(apiConfigs));
        }
        return results;
    }

    @Override
    public String getFileExtension() {
        return "api";
    }

    private String generateForApi(Iterable<? extends ApiConfig> apiConfigs) throws ApiConfigException {
        ObjectNode root = objectMapper.createObjectNode();
        ApiConfig apiConfig = (ApiConfig)Iterables.get(apiConfigs, (int)0);
        this.convertApi(root, apiConfig);
        this.convertApiAuth(root, apiConfig.getAuthConfig());
        this.convertApiFrontendLimits(root, apiConfig.getFrontendLimitsConfig());
        this.convertApiCacheControl(root, apiConfig.getCacheControlConfig());
        this.convertApiNamespace(root, apiConfig.getNamespaceConfig());
        this.convertApiMethods(apiConfigs, root);
        return this.toString(root);
    }

    private String toString(ObjectNode node) throws ApiConfigException {
        try {
            return objectMapper.writerWithDefaultPrettyPrinter().writeValueAsString(node);
        }
        catch (JsonGenerationException e) {
            throw new ApiConfigException(e);
        }
        catch (JsonMappingException e) {
            throw new ApiConfigException(e);
        }
        catch (IOException e) {
            throw new ApiConfigException(e);
        }
    }

    private void setNodePropertyNoConflict(ObjectNode node, String key, JsonNode value, String errorMessage) {
        if (!node.path(key).isMissingNode()) {
            throw new IllegalArgumentException(errorMessage);
        }
        node.put(key, value);
    }

    private void setNodePropertyNoConflict(ObjectNode node, String key, JsonNode value) {
        this.setNodePropertyNoConflict(node, key, value, "Multiple values for same key '" + key + "'");
    }

    private void convertApi(ObjectNode root, ApiConfig config) {
        root.put("extends", this.getParentApiFile());
        root.put("abstract", config.getIsAbstract());
        root.put("root", config.getRoot());
        root.put("name", config.getName());
        if (config.getCanonicalName() != null) {
            root.put("canonicalName", config.getCanonicalName());
        }
        root.put("version", config.getVersion());
        if (config.getTitle() != null) {
            root.put("title", config.getTitle());
        }
        if (config.getDescription() != null) {
            root.put("description", config.getDescription());
        }
        if (config.getDocumentationLink() != null) {
            root.put("documentation", config.getDocumentationLink());
        }
        root.put("defaultVersion", config.getIsDefaultVersion());
        ObjectNode adapter = objectMapper.createObjectNode();
        adapter.put("bns", config.getBackendRoot());
        adapter.put("deadline", 10.0);
        adapter.put("type", "lily");
        root.put("adapter", adapter);
    }

    protected String getParentApiFile() {
        return "thirdParty.api";
    }

    private void convertApiAuth(ObjectNode root, ApiAuthConfig config) {
        ObjectNode authConfig = objectMapper.createObjectNode();
        authConfig.put("allowCookieAuth", config.getAllowCookieAuth());
        List<String> blockedRegions = config.getBlockedRegions();
        if (!blockedRegions.isEmpty()) {
            ArrayNode blockedRegionsNode = objectMapper.createArrayNode();
            for (String region : blockedRegions) {
                blockedRegionsNode.add(region);
            }
            authConfig.put("blockedRegions", blockedRegionsNode);
        }
        root.put("auth", authConfig);
    }

    private void convertApiFrontendLimits(ObjectNode root, ApiFrontendLimitsConfig config) {
        ObjectNode frontendLimitsConfig = objectMapper.createObjectNode();
        frontendLimitsConfig.put("unregisteredUserQps", config.getUnregisteredUserQps());
        frontendLimitsConfig.put("unregisteredQps", config.getUnregisteredQps());
        frontendLimitsConfig.put("unregisteredDaily", config.getUnregisteredDaily());
        this.convertApiFrontendLimitRules(frontendLimitsConfig, config.getRules());
        root.put("frontendLimits", frontendLimitsConfig);
    }

    private void convertApiCacheControl(ObjectNode root, ApiCacheControlConfig config) {
        ObjectNode cacheControlConfig = objectMapper.createObjectNode();
        cacheControlConfig.put("type", config.getType());
        cacheControlConfig.put("maxAge", config.getMaxAge());
        root.put("cacheControl", cacheControlConfig);
    }

    private void convertApiNamespace(ObjectNode root, ApiNamespaceConfig config) {
        if (!config.getOwnerDomain().isEmpty()) {
            root.put("ownerDomain", config.getOwnerDomain());
        }
        if (!config.getOwnerName().isEmpty()) {
            root.put("ownerName", config.getOwnerName());
        }
        if (!config.getPackagePath().isEmpty()) {
            root.put("packagePath", config.getPackagePath());
        }
    }

    private void convertApiFrontendLimitRules(ObjectNode frontendLimitsConfig, List<ApiFrontendLimitsConfig.FrontendLimitsRule> rules) {
        ArrayNode rulesConfig = objectMapper.createArrayNode();
        for (ApiFrontendLimitsConfig.FrontendLimitsRule rule : rules) {
            ObjectNode ruleConfig = objectMapper.createObjectNode();
            ruleConfig.put("match", rule.getMatch());
            ruleConfig.put("qps", rule.getQps());
            ruleConfig.put("userQps", rule.getUserQps());
            ruleConfig.put("daily", rule.getDaily());
            ruleConfig.put("analyticsId", rule.getAnalyticsId());
            rulesConfig.add(ruleConfig);
        }
        frontendLimitsConfig.put("rules", rulesConfig);
    }

    private void convertApiMethods(Iterable<? extends ApiConfig> configs, ObjectNode root) throws IllegalArgumentException, SecurityException, ApiConfigException {
        ObjectNode methodsNode = objectMapper.createObjectNode();
        ObjectNode descriptorNode = objectMapper.createObjectNode();
        ObjectNode descriptorSchemasNode = objectMapper.createObjectNode();
        ObjectNode descriptorMethodsNode = objectMapper.createObjectNode();
        descriptorNode.put("schemas", descriptorSchemasNode);
        descriptorNode.put("methods", descriptorMethodsNode);
        for (ApiConfig apiConfig : configs) {
            this.convertApiMethods(methodsNode, descriptorSchemasNode, descriptorMethodsNode, apiConfig);
        }
        root.put("methods", methodsNode);
        root.put("descriptor", descriptorNode);
    }

    private void convertApiMethods(ObjectNode methodsNode, ObjectNode descriptorSchemasNode, ObjectNode descriptorMethodsNode, ApiConfig apiConfig) throws IllegalArgumentException, SecurityException, ApiConfigException {
        ApiClassConfig.MethodConfigMap methodConfigs = apiConfig.getApiClassConfig().getMethods();
        for (Map.Entry methodConfig : methodConfigs.entrySet()) {
            EndpointMethod endpointMethod = (EndpointMethod)methodConfig.getKey();
            ApiMethodConfig config = (ApiMethodConfig)methodConfig.getValue();
            this.convertApiMethod(methodsNode, descriptorSchemasNode, descriptorMethodsNode, endpointMethod, config, apiConfig);
        }
    }

    private void convertApiMethod(ObjectNode methodsNode, ObjectNode descriptorSchemasNode, ObjectNode descriptorMethodsNode, EndpointMethod endpointMethod, ApiMethodConfig config, ApiConfig apiConfig) throws IllegalArgumentException, SecurityException, ApiConfigException {
        Method method = endpointMethod.getMethod();
        ObjectNode methodNode = objectMapper.createObjectNode();
        this.setNodePropertyNoConflict(methodsNode, config.getFullMethodName(), methodNode);
        methodNode.put("path", config.getPath());
        methodNode.put("httpMethod", config.getHttpMethod());
        methodNode.put("authLevel", objectMapper.convertValue((Object)config.getAuthLevel(), JsonNode.class));
        methodNode.put("scopes", objectMapper.convertValue(config.getScopes(), JsonNode.class));
        methodNode.put("audiences", objectMapper.convertValue(config.getAudiences(), JsonNode.class));
        methodNode.put("clientIds", objectMapper.convertValue(config.getClientIds(), JsonNode.class));
        methodNode.put("rosyMethod", config.getFullJavaName());
        ObjectNode descriptorMethodNode = objectMapper.createObjectNode();
        this.setNodePropertyNoConflict(descriptorMethodsNode, config.getFullJavaName(), descriptorMethodNode);
        this.convertMethodRequest(endpointMethod, methodNode, descriptorSchemasNode, descriptorMethodNode, config, apiConfig);
        this.convertMethodResponse(endpointMethod, methodNode, descriptorSchemasNode, descriptorMethodNode, config);
    }

    private void convertMethodRequest(EndpointMethod endpointMethod, ObjectNode apiMethodNode, ObjectNode descriptorSchemasNode, ObjectNode descriptorMethodNode, ApiMethodConfig config, ApiConfig apiConfig) throws IllegalArgumentException, SecurityException, ApiConfigException {
        ObjectNode requestNode = objectMapper.createObjectNode();
        this.convertMethodRequestParameters(endpointMethod, requestNode, descriptorSchemasNode, descriptorMethodNode, config, apiConfig);
        apiMethodNode.put("request", requestNode);
    }

    private void convertMethodRequestParameters(EndpointMethod endpointMethod, ObjectNode requestNode, ObjectNode descriptorSchemasNode, ObjectNode descriptorMethodNode, ApiMethodConfig config, ApiConfig apiConfig) throws IllegalArgumentException, SecurityException, ApiConfigException {
        ObjectNode parametersNode = objectMapper.createObjectNode();
        Method method = endpointMethod.getMethod();
        Collection<String> pathParameters = config.getPathParameters();
        List<ApiParameterConfig> parameterConfigs = config.getParameterConfigs();
        for (ApiParameterConfig parameterConfig : parameterConfigs) {
            switch (parameterConfig.getClassification()) {
                case INJECTED: {
                    break;
                }
                case API_PARAMETER: {
                    this.convertSimpleParameter(parameterConfig, parametersNode);
                    break;
                }
                case RESOURCE: {
                    this.convertComplexParameter(parameterConfig, method, descriptorSchemasNode, descriptorMethodNode, apiConfig, parameterConfigs);
                    break;
                }
                case UNKNOWN: {
                    throw new IllegalArgumentException("Unclassifiable parameter type found.");
                }
            }
        }
        if (parametersNode.size() != 0) {
            requestNode.put("parameters", parametersNode);
        }
        if (descriptorMethodNode.get("request") != null) {
            requestNode.put("body", "autoTemplate(backendRequest)");
            requestNode.put("bodyName", "resource");
        } else {
            requestNode.put("body", "empty");
        }
    }

    private void convertSimpleParameter(ApiParameterConfig config, ObjectNode parametersNode) {
        Object type;
        ObjectNode parameterNode = objectMapper.createObjectNode();
        if (config.isRepeated()) {
            parameterNode.put("repeated", true);
            type = config.getRepeatedItemSerializedType();
        } else {
            type = config.getSchemaBaseType();
        }
        if (config.isEnum()) {
            ObjectNode enumValuesNode = objectMapper.createObjectNode();
            for (Object enumConstant : ((Class)type).getEnumConstants()) {
                ObjectNode enumNode = objectMapper.createObjectNode();
                enumValuesNode.put(enumConstant.toString(), enumNode);
            }
            parameterNode.put("enum", enumValuesNode);
            type = String.class;
        }
        parameterNode.put("type", this.typeLoader.getParameterTypes().get(type));
        parameterNode.put("required", !config.getNullable() && config.getDefaultValue() == null);
        String defaultValue = config.getDefaultValue();
        if (defaultValue != null) {
            Class parameterClass = (Class)type;
            try {
                objectMapper.convertValue((Object)defaultValue, parameterClass);
            }
            catch (IllegalArgumentException e) {
                throw new IllegalArgumentException(String.format("'%s' is not a valid default value for type '%s'", defaultValue, type));
            }
            parameterNode.put("default", defaultValue);
        }
        parametersNode.put(config.getName(), parameterNode);
    }

    private void convertComplexParameter(ApiParameterConfig config, Method method, ObjectNode descriptorSchemasNode, ObjectNode descriptorMethodNode, ApiConfig apiConfig, List<ApiParameterConfig> parameterConfigs) throws ApiConfigException {
        ObjectNode schemaTypeNode = objectMapper.createObjectNode();
        Type type = config.getSchemaBaseType();
        String schemaTypeName = this.addTypeToNode(descriptorSchemasNode, type, null, schemaTypeNode, apiConfig, parameterConfigs);
        String requestTypeName = this.addTypeToSchema(descriptorSchemasNode, type, apiConfig, parameterConfigs);
        ObjectNode requestTypeNode = objectMapper.createObjectNode();
        this.addTypeToNode(descriptorSchemasNode, type, null, requestTypeNode, apiConfig, parameterConfigs);
        this.setNodePropertyNoConflict(descriptorMethodNode, "request", requestTypeNode);
    }

    private void convertMethodResponse(EndpointMethod serviceMethod, ObjectNode methodNode, ObjectNode descriptorSchemasNode, ObjectNode descriptorMethodNode, ApiMethodConfig config) throws ApiConfigException {
        ObjectNode responseNode = objectMapper.createObjectNode();
        methodNode.put("response", responseNode);
        if (this.methodHasResourceInResponse(serviceMethod)) {
            responseNode.put("body", "autoTemplate(backendResponse)");
            Type returnType = ApiAnnotationIntrospector.getSchemaType(serviceMethod.getReturnType(), config.getApiClassConfig().getApiConfig());
            descriptorMethodNode.put("response", this.convertMethodResponseType(descriptorSchemasNode, returnType, config));
        } else {
            responseNode.put("body", "empty");
        }
    }

    private ObjectNode convertMethodResponseType(ObjectNode descriptorSchemasNode, Type returnType, ApiMethodConfig config) throws ApiConfigException {
        ObjectNode returnTypeNode = objectMapper.createObjectNode();
        String responseTypeName = this.addTypeToNode(descriptorSchemasNode, returnType, null, returnTypeNode, config.getApiClassConfig().getApiConfig(), null);
        if (this.typeLoader.isSchemaType(returnType) || TypeLoader.isEnumType(returnType)) {
            throw new InvalidReturnTypeException(config, returnType);
        }
        if (TypeLoader.getArrayItemType(returnType) != null && returnType != byte[].class) {
            ObjectNode propertiesNode = objectMapper.createObjectNode();
            propertiesNode.put("items", returnTypeNode);
            ObjectNode arrayWrapperNode = objectMapper.createObjectNode();
            arrayWrapperNode.put("id", responseTypeName);
            arrayWrapperNode.put("type", "object");
            arrayWrapperNode.put("properties", propertiesNode);
            descriptorSchemasNode.put(responseTypeName, arrayWrapperNode);
            returnTypeNode = objectMapper.createObjectNode();
            returnTypeNode.put("$ref", responseTypeName);
        }
        return returnTypeNode;
    }

    private boolean methodHasResourceInResponse(EndpointMethod serviceMethod) {
        Type returnType = serviceMethod.getReturnType();
        return returnType != Void.TYPE && returnType != Void.class;
    }

    @VisibleForTesting
    String addTypeToSchema(ObjectNode schemasNode, Type type, ApiConfig apiConfig, List<ApiParameterConfig> parameterConfigs) throws ApiConfigException {
        return this.addTypeToSchema(schemasNode, type, null, apiConfig, parameterConfigs);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @VisibleForTesting
    String addTypeToSchema(ObjectNode schemasNode, Type type, Type enclosingType, ApiConfig apiConfig, List<ApiParameterConfig> parameterConfigs) throws ApiConfigException {
        if (this.typeLoader.isSchemaType(type)) {
            return this.typeLoader.getSchemaTypes().get(type);
        }
        if (type == Object.class) {
            if (schemasNode.has(ANY_SCHEMA_NAME)) return ANY_SCHEMA_NAME;
            ObjectNode anySchema = objectMapper.createObjectNode();
            anySchema.put("id", ANY_SCHEMA_NAME);
            anySchema.put("type", "any");
            schemasNode.put(ANY_SCHEMA_NAME, anySchema);
            return ANY_SCHEMA_NAME;
        }
        if (this.typeLoader.isMapType(type)) {
            if (schemasNode.has(MAP_SCHEMA_NAME)) return MAP_SCHEMA_NAME;
            ObjectNode mapSchema = objectMapper.createObjectNode();
            mapSchema.put("id", MAP_SCHEMA_NAME);
            mapSchema.put("type", "object");
            schemasNode.put(MAP_SCHEMA_NAME, mapSchema);
            return MAP_SCHEMA_NAME;
        }
        String typeName = apiConfig.getSimpleName(type);
        JsonNode existing = schemasNode.get(typeName);
        if (existing != null && existing.isObject()) {
            return typeName;
        }
        ObjectNode schemaNode = objectMapper.createObjectNode();
        if (type instanceof ParameterizedType) {
            Type collectionType = ((ParameterizedType)type).getRawType();
            if (this.typeLoader.isSchemaType(collectionType)) {
                return this.typeLoader.getSchemaTypes().get(collectionType);
            }
            if (!this.typeLoader.getClassTypes().get("CollectionResponses").isAssignableFrom((Class)collectionType)) throw new IllegalArgumentException("Parameterized type " + type + " not supported.");
            this.addBeanTypeToSchema(schemasNode, apiConfig.getSimpleName(type), schemaNode, type, apiConfig, parameterConfigs);
            return typeName;
        } else {
            if (!(type instanceof Class)) throw new IllegalArgumentException(String.format("Object type %s not supported.", type));
            Class c = (Class)type;
            if (c.isEnum()) {
                schemasNode.put(typeName, schemaNode);
                schemaNode.put("id", typeName);
                schemaNode.put("type", "string");
                ArrayNode enumNode = objectMapper.createArrayNode();
                for (Object enumConstant : c.getEnumConstants()) {
                    enumNode.add(enumConstant.toString());
                }
                schemaNode.put("enum", enumNode);
                return typeName;
            } else {
                Type serializedType = ApiAnnotationIntrospector.getSchemaType(c, apiConfig);
                if (!c.equals(serializedType)) {
                    return this.addTypeToSchema(schemasNode, serializedType, enclosingType, apiConfig, parameterConfigs);
                }
                this.addBeanTypeToSchema(schemasNode, typeName, schemaNode, c, apiConfig, parameterConfigs);
            }
        }
        return typeName;
    }

    private void addBeanTypeToSchema(ObjectNode schemasNode, String typeName, ObjectNode schemaNode, Type type, ApiConfig apiConfig, List<ApiParameterConfig> parameterConfigs) throws ApiConfigException {
        schemasNode.put(typeName, schemaNode);
        schemaNode.put("id", typeName);
        schemaNode.put("type", "object");
        ObjectNode propertiesNode = objectMapper.createObjectNode();
        this.addBeanProperties(schemasNode, propertiesNode, type, apiConfig, parameterConfigs);
        schemaNode.put("properties", propertiesNode);
    }

    protected void addBeanProperties(ObjectNode schemasNode, ObjectNode node, Type beanType, ApiConfig apiConfig, List<ApiParameterConfig> parameterConfigs) throws ApiConfigException {
        Class beanClass = beanType instanceof ParameterizedType ? (Class)((ParameterizedType)beanType).getRawType() : (Class)beanType;
        ResourceSchema schema = this.resourceSchemaProvider.getResourceSchema(beanClass, apiConfig);
        for (Map.Entry<String, ResourcePropertySchema> entry : schema.getProperties().entrySet()) {
            String propertyName = entry.getKey();
            JsonConfigWriter.validatePropertyName(propertyName, parameterConfigs);
            ObjectNode propertyNode = objectMapper.createObjectNode();
            Type propertyType = entry.getValue().getJavaType();
            if (propertyType == null) continue;
            this.addTypeToNode(schemasNode, propertyType, beanType, propertyNode, apiConfig, parameterConfigs);
            node.put(propertyName, propertyNode);
        }
    }

    private static void validatePropertyName(String propertyName, List<ApiParameterConfig> parameterConfigs) throws ApiConfigException {
        if (propertyName.equals("id")) {
            return;
        }
        if (parameterConfigs != null) {
            for (ApiParameterConfig parameter : parameterConfigs) {
                if (!propertyName.equals(parameter.getName())) continue;
                throw new PropertyParameterNameConflictException(parameter);
            }
        }
    }

    protected String addTypeToNode(ObjectNode schemasNode, Type type, Type enclosingType, ObjectNode node, ApiConfig apiConfig, List<ApiParameterConfig> parameterConfigs) throws ApiConfigException {
        Type itemType = TypeLoader.getArrayItemType(type);
        if (this.typeLoader.getSchemaTypes().containsKey(type)) {
            String basicTypeName = this.typeLoader.getSchemaTypes().get(type);
            this.addElementTypeToNode(schemasNode, type, basicTypeName, node, apiConfig);
            return basicTypeName;
        }
        if (itemType != null) {
            ObjectNode items = objectMapper.createObjectNode();
            node.put("type", "array");
            node.put("items", items);
            String itemTypeName = this.addTypeToNode(schemasNode, itemType, enclosingType, items, apiConfig, parameterConfigs);
            String arraySuffix = "Collection";
            StringBuilder sb = new StringBuilder(itemTypeName.length() + arraySuffix.length());
            sb.append(itemTypeName).append(arraySuffix);
            sb.setCharAt(0, Character.toUpperCase(sb.charAt(0)));
            return sb.toString();
        }
        if (type instanceof TypeVariable) {
            if (enclosingType instanceof ParameterizedType) {
                Type[] typeArgs = ((ParameterizedType)enclosingType).getActualTypeArguments();
                Type actualArg = typeArgs.length > 0 ? typeArgs[0] : null;
                return this.addTypeToNode(schemasNode, actualArg, null, node, apiConfig, parameterConfigs);
            }
            throw new IllegalArgumentException(String.format("Object type %s not supported.", type));
        }
        String typeName = this.addTypeToSchema(schemasNode, type, enclosingType, apiConfig, parameterConfigs);
        this.addElementTypeToNode(schemasNode, type, typeName, node, apiConfig);
        return typeName;
    }

    private void addElementTypeToNode(ObjectNode schemasNode, Type type, String typeName, ObjectNode node, ApiConfig apiConfig) {
        if (schemasNode.has(typeName)) {
            node.put("$ref", typeName);
        } else {
            node.put("type", typeName);
            String format = this.schemaFormatForType(type, apiConfig);
            if (format != null) {
                node.put("format", format);
            }
        }
    }

    private String schemaFormatForType(Type type, ApiConfig apiConfig) {
        Type serializedType = ApiAnnotationIntrospector.getSchemaType(type, apiConfig);
        if (!type.equals(serializedType)) {
            return this.schemaFormatForType(serializedType, apiConfig);
        }
        return this.typeLoader.getSchemaFormats().get(type);
    }
}

