/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.server.spi.config.annotationreader;

import com.google.api.server.spi.config.AnnotationBoolean;
import com.google.api.server.spi.config.ApiClassConfig;
import com.google.api.server.spi.config.AuthLevel;
import com.google.api.server.spi.config.annotationreader.AnnotationUtil;
import java.util.Arrays;

public class ApiClassAnnotationConfig {
    private final ApiClassConfig config;

    public ApiClassAnnotationConfig(ApiClassConfig config) {
        this.config = config;
    }

    public void setResourceIfNotEmpty(String resource) {
        if (!resource.isEmpty()) {
            this.config.setResource(resource);
        }
    }

    public void setAuthLevelIfSpecified(AuthLevel authLevel) {
        if (authLevel != AuthLevel.UNSPECIFIED) {
            this.config.setAuthLevel(authLevel);
        }
    }

    public void setScopesIfSpecified(String[] scopes) {
        if (!AnnotationUtil.isUnspecified(scopes)) {
            this.config.setScopes(Arrays.asList(scopes));
        }
    }

    public void setAudiencesIfSpecified(String[] audiences) {
        if (!AnnotationUtil.isUnspecified(audiences)) {
            this.config.setAudiences(Arrays.asList(audiences));
        }
    }

    public void setClientIdsIfSpecified(String[] clientIds) {
        if (!AnnotationUtil.isUnspecified(clientIds)) {
            this.config.setClientIds(Arrays.asList(clientIds));
        }
    }

    public void setUseDatastoreIfSpecified(AnnotationBoolean useDatastore) {
        if (useDatastore == AnnotationBoolean.TRUE) {
            this.config.setUseDatastore(true);
        } else if (useDatastore == AnnotationBoolean.FALSE) {
            this.config.setUseDatastore(false);
        }
    }
}

