/*
 * Decompiled with CFR 0.152.
 */
package javax.mail.util;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import javax.mail.internet.SharedInputStream;

public class SharedByteArrayInputStream
extends ByteArrayInputStream
implements SharedInputStream {
    protected int start;

    public SharedByteArrayInputStream(byte[] buf) {
        this(buf, 0, buf.length);
    }

    public SharedByteArrayInputStream(byte[] buf, int offset, int length) {
        super(buf, offset, length);
        this.start = offset;
    }

    @Override
    public long getPosition() {
        return this.pos - this.start;
    }

    @Override
    public InputStream newStream(long offset, long end) {
        if (offset < 0L) {
            throw new IllegalArgumentException("Starting position must be non-negative");
        }
        if (end == -1L) {
            end = this.count - this.start;
        }
        return new SharedByteArrayInputStream(this.buf, this.start + (int)offset, (int)(end - offset));
    }
}

