/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.api.datastore;

import com.google.appengine.api.blobstore.BlobKey;
import com.google.appengine.api.datastore.Blob;
import com.google.appengine.api.datastore.Category;
import com.google.appengine.api.datastore.DataTypeUtils;
import com.google.appengine.api.datastore.Email;
import com.google.appengine.api.datastore.EmbeddedEntity;
import com.google.appengine.api.datastore.Entity;
import com.google.appengine.api.datastore.GeoPt;
import com.google.appengine.api.datastore.IMHandle;
import com.google.appengine.api.datastore.Key;
import com.google.appengine.api.datastore.KeyTranslator;
import com.google.appengine.api.datastore.Link;
import com.google.appengine.api.datastore.PhoneNumber;
import com.google.appengine.api.datastore.PostalAddress;
import com.google.appengine.api.datastore.PropertyContainer;
import com.google.appengine.api.datastore.Rating;
import com.google.appengine.api.datastore.RawValue;
import com.google.appengine.api.datastore.ShortBlob;
import com.google.appengine.api.datastore.Text;
import com.google.appengine.api.users.User;
import com.google.appengine.repackaged.com.google.common.collect.Maps;
import com.google.storage.onestore.v3.OnestoreEntity;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;

public final class DataTypeTranslator {
    private static final StringType STRING_TYPE = new StringType();
    private static final Map<Class<?>, Type<?>> typeMap = Maps.newHashMap();
    private static final Map<Class<? extends Comparable<?>>, Integer> comparableTypeMap;
    private static final AsComparableFunction NOT_COMPARABLE;
    private static final AsComparableFunction COMP_BYTE_ARRAY_FUNC;
    private static final AsComparableFunction COMP_RAW_VALUE_FUNC;
    private static final AsComparableFunction INT_64_COMP_FUNC;
    private static final AsComparableFunction DOUBLE_COMP_FUNC;
    private static final AsComparableFunction BOOLEAN_COMP_FUNC;

    public static void addPropertiesToPb(Map<String, Object> map, OnestoreEntity.EntityProto proto) {
        for (Map.Entry<String, Object> entry : map.entrySet()) {
            String key = entry.getKey();
            boolean indexed = !(entry.getValue() instanceof Entity.UnindexedValue);
            Object value = PropertyContainer.unwrapValue(entry.getValue());
            if (value instanceof Collection) {
                Collection values = (Collection)value;
                if (values.isEmpty()) {
                    DataTypeTranslator.addProperty(proto, key, null, indexed, false);
                    continue;
                }
                for (Object listValue : values) {
                    DataTypeTranslator.addProperty(proto, key, listValue, indexed, true);
                }
                continue;
            }
            DataTypeTranslator.addProperty(proto, key, value, indexed, false);
        }
    }

    private static void addProperty(OnestoreEntity.EntityProto entity, String name, Object value, boolean indexed, boolean multiple) {
        Pair<Type<?>, OnestoreEntity.Property> pair = DataTypeTranslator.createProperty(name, value, multiple);
        Type<?> type = pair.first();
        OnestoreEntity.Property property = pair.second();
        if (!indexed || type != null && type.getComparableFunction() == NOT_COMPARABLE) {
            entity.addRawProperty(property);
        } else {
            entity.addProperty(property);
        }
    }

    private static Pair<Type<?>, OnestoreEntity.Property> createProperty(String name, Object value, boolean multiple) {
        OnestoreEntity.Property property = new OnestoreEntity.Property();
        property.setName(name);
        property.setMultiple(multiple);
        if (value == null) {
            return Pair.of(null, property);
        }
        Pair<Type<?>, OnestoreEntity.PropertyValue> newValue = DataTypeTranslator.createPropertyValue(value);
        Type type = (Type)((Pair)newValue).first;
        OnestoreEntity.Property.Meaning meaning = type.getMeaning();
        if (meaning != OnestoreEntity.Property.Meaning.NO_MEANING) {
            property.setMeaning(meaning);
        }
        property.setValue((OnestoreEntity.PropertyValue)((Pair)newValue).second);
        return new Pair(type, property);
    }

    private static Pair<Type<?>, OnestoreEntity.PropertyValue> createPropertyValue(Object value) {
        if (value == null) {
            return Pair.of(null, null);
        }
        OnestoreEntity.PropertyValue newValue = new OnestoreEntity.PropertyValue();
        Type<?> type = DataTypeTranslator.getType(value.getClass());
        type.setPropertyValue(newValue, value);
        return new Pair(type, newValue);
    }

    public static void extractIndexedPropertiesFromPb(OnestoreEntity.EntityProto proto, Map<String, Object> map) {
        for (OnestoreEntity.Property property : proto.propertys()) {
            DataTypeTranslator.addPropertyValueToMap(property, map, true);
        }
    }

    private static void extractUnindexedPropertiesFromPb(OnestoreEntity.EntityProto proto, Map<String, Object> map) {
        for (OnestoreEntity.Property property : proto.rawPropertys()) {
            DataTypeTranslator.addPropertyValueToMap(property, map, false);
        }
    }

    public static void extractPropertiesFromPb(OnestoreEntity.EntityProto proto, Map<String, Object> map) {
        DataTypeTranslator.extractIndexedPropertiesFromPb(proto, map);
        DataTypeTranslator.extractUnindexedPropertiesFromPb(proto, map);
    }

    public static void extractImplicitPropertiesFromPb(OnestoreEntity.EntityProto proto, Map<String, Object> map) {
        for (OnestoreEntity.Property property : DataTypeTranslator.getImplicitProperties(proto)) {
            DataTypeTranslator.addPropertyValueToMap(property, map, true);
        }
    }

    private static Iterable<OnestoreEntity.Property> getImplicitProperties(OnestoreEntity.EntityProto proto) {
        return Collections.singleton(DataTypeTranslator.buildImplicitKeyProperty(proto));
    }

    private static OnestoreEntity.Property buildImplicitKeyProperty(OnestoreEntity.EntityProto proto) {
        OnestoreEntity.Property keyProp = new OnestoreEntity.Property();
        keyProp.setName("__key__");
        OnestoreEntity.PropertyValue propVal = new OnestoreEntity.PropertyValue();
        ReferenceType.setPropertyValue(propVal, proto.getKey());
        keyProp.setValue(propVal);
        return keyProp;
    }

    public static Collection<OnestoreEntity.Property> findIndexedPropertiesOnPb(OnestoreEntity.EntityProto proto, String propertyName) {
        if (propertyName.equals("__key__")) {
            return Collections.singleton(DataTypeTranslator.buildImplicitKeyProperty(proto));
        }
        ArrayList<OnestoreEntity.Property> multipleProps = new ArrayList<OnestoreEntity.Property>();
        OnestoreEntity.Property singleProp = DataTypeTranslator.addPropertiesWithName(proto.propertys(), propertyName, multipleProps);
        if (singleProp != null) {
            return Collections.singleton(singleProp);
        }
        return multipleProps;
    }

    private static OnestoreEntity.Property addPropertiesWithName(Iterable<OnestoreEntity.Property> props, String propName, Collection<OnestoreEntity.Property> matchingMultipleProps) {
        for (OnestoreEntity.Property prop : props) {
            if (!prop.getName().equals(propName)) continue;
            if (!prop.isMultiple()) {
                return prop;
            }
            matchingMultipleProps.add(prop);
        }
        return null;
    }

    private static void addPropertyValueToMap(OnestoreEntity.Property property, Map<String, Object> map, boolean indexed) {
        String name = property.getName();
        Object value = DataTypeTranslator.getPropertyValue(property);
        if (property.isMultiple()) {
            ArrayList<Object> results = (ArrayList<Object>)PropertyContainer.unwrapValue(map.get(name));
            if (results == null) {
                results = new ArrayList<Object>();
                map.put(name, indexed ? results : new Entity.UnindexedValue(results));
            }
            results.add(value);
        } else {
            map.put(name, indexed ? value : new Entity.UnindexedValue(value));
        }
    }

    public static Object getPropertyValue(OnestoreEntity.Property property) {
        OnestoreEntity.PropertyValue value = property.getValue();
        for (Type<?> type : typeMap.values()) {
            if (!type.hasPropertyValue(value) || type.getMeaning() != property.getMeaningEnum()) continue;
            return type.getPropertyValue(value);
        }
        return null;
    }

    public static Comparable<Object> getComparablePropertyValue(OnestoreEntity.Property property) {
        OnestoreEntity.PropertyValue value = property.getValue();
        OnestoreEntity.Property.Meaning meaning = property.getMeaningEnum();
        for (Type<?> type : typeMap.values()) {
            if (!type.hasPropertyValue(value) || meaning != OnestoreEntity.Property.Meaning.INDEX_VALUE && meaning != type.getMeaning() || type.getComparableFunction() == null) continue;
            return DataTypeTranslator.toComparableObject(type.getComparableFunction().asComparable(value));
        }
        return null;
    }

    static Comparable<Object> getComparablePropertyValue(Object value) {
        Pair<Type<?>, OnestoreEntity.PropertyValue> newValue = DataTypeTranslator.createPropertyValue(value);
        if (((Pair)newValue).first != null) {
            return DataTypeTranslator.toComparableObject(((Type)((Pair)newValue).first).getComparableFunction().asComparable((OnestoreEntity.PropertyValue)((Pair)newValue).second));
        }
        return null;
    }

    private static <T> Comparable<Object> toComparableObject(Comparable<T> original) {
        return original;
    }

    public static int getTypeRank(Class<? extends Comparable> datastoreType) {
        return comparableTypeMap.get(datastoreType);
    }

    static OnestoreEntity.Property toProperty(String propertyName, Object value) {
        return DataTypeTranslator.createProperty(propertyName, value, false).second();
    }

    private static <T> Type<T> getType(Class<T> clazz) {
        if (typeMap.containsKey(clazz)) {
            return typeMap.get(clazz);
        }
        throw new UnsupportedOperationException("Unsupported data type: " + clazz.getName());
    }

    static Map<Class<?>, Type<?>> getTypeMap() {
        return typeMap;
    }

    private DataTypeTranslator() {
    }

    static {
        typeMap.put(RawValue.class, new RawValueType());
        typeMap.put(Float.class, new DoubleType());
        typeMap.put(Double.class, new DoubleType());
        typeMap.put(Byte.class, new Int64Type());
        typeMap.put(Short.class, new Int64Type());
        typeMap.put(Integer.class, new Int64Type());
        typeMap.put(Long.class, new Int64Type());
        typeMap.put(Date.class, new DateType());
        typeMap.put(Rating.class, new RatingType());
        typeMap.put(String.class, STRING_TYPE);
        typeMap.put(Link.class, new LinkType());
        typeMap.put(ShortBlob.class, new ShortBlobType());
        typeMap.put(Category.class, new CategoryType());
        typeMap.put(PhoneNumber.class, new PhoneNumberType());
        typeMap.put(PostalAddress.class, new PostalAddressType());
        typeMap.put(Email.class, new EmailType());
        typeMap.put(IMHandle.class, new IMHandleType());
        typeMap.put(BlobKey.class, new BlobKeyType());
        typeMap.put(Blob.class, new BlobType());
        typeMap.put(Text.class, new TextType());
        typeMap.put(EmbeddedEntity.class, new EmbeddedEntityType());
        typeMap.put(Boolean.class, new BoolType());
        typeMap.put(User.class, new UserType());
        typeMap.put(Key.class, new ReferenceType());
        typeMap.put(GeoPt.class, new GeoPtType());
        assert (((Object)typeMap.keySet()).equals(DataTypeUtils.getSupportedTypes())) : "Warning:  DataTypeUtils and DataTypeTranslator do not agree about supported classes: " + typeMap.keySet() + " vs. " + DataTypeUtils.getSupportedTypes();
        comparableTypeMap = new HashMap();
        comparableTypeMap.put(ComparableByteArray.class, 3);
        comparableTypeMap.put(Long.class, 1);
        comparableTypeMap.put(Double.class, 4);
        comparableTypeMap.put(Boolean.class, 2);
        comparableTypeMap.put(User.class, 8);
        comparableTypeMap.put(Key.class, 12);
        comparableTypeMap.put(GeoPt.class, 5);
        NOT_COMPARABLE = null;
        COMP_BYTE_ARRAY_FUNC = new AsComparableFunction(){

            public Comparable<ComparableByteArray> asComparable(OnestoreEntity.PropertyValue pv) {
                return new ComparableByteArray(pv.getStringValueAsBytes());
            }
        };
        COMP_RAW_VALUE_FUNC = new AsComparableFunction(){

            @Override
            public Comparable<?> asComparable(OnestoreEntity.PropertyValue pv) {
                if (pv.hasStringValue()) {
                    return new ComparableByteArray(pv.getStringValueAsBytes());
                }
                return (Comparable)new RawValue(pv).getValue();
            }
        };
        INT_64_COMP_FUNC = new AsComparableFunction(){

            public Comparable<Long> asComparable(OnestoreEntity.PropertyValue pv) {
                return pv.getInt64Value();
            }
        };
        DOUBLE_COMP_FUNC = new AsComparableFunction(){

            public Comparable<Double> asComparable(OnestoreEntity.PropertyValue pv) {
                return pv.getDoubleValue();
            }
        };
        BOOLEAN_COMP_FUNC = new AsComparableFunction(){

            public Comparable<Boolean> asComparable(OnestoreEntity.PropertyValue pv) {
                return pv.isBooleanValue();
            }
        };
    }

    public static final class ComparableByteArray
    implements Comparable<ComparableByteArray> {
        private final byte[] bytes;

        public ComparableByteArray(byte[] bytes) {
            this.bytes = bytes;
        }

        @Override
        public int compareTo(ComparableByteArray other) {
            byte[] otherBytes = other.bytes;
            for (int i = 0; i < Math.min(this.bytes.length, otherBytes.length); ++i) {
                int v1 = this.bytes[i] & 0xFF;
                int v2 = otherBytes[i] & 0xFF;
                if (v1 == v2) continue;
                return v1 - v2;
            }
            return this.bytes.length - otherBytes.length;
        }

        public boolean equals(Object obj) {
            if (obj == null) {
                return false;
            }
            return Arrays.equals(this.bytes, ((ComparableByteArray)obj).bytes);
        }

        public int hashCode() {
            int result = 1;
            for (byte b : this.bytes) {
                result = 31 * result + b;
            }
            return result;
        }
    }

    private static class Pair<T, U> {
        private final T first;
        private final U second;

        Pair(T t, U u) {
            this.first = t;
            this.second = u;
        }

        T first() {
            return this.first;
        }

        U second() {
            return this.second;
        }

        public static <T, U> Pair<T, U> of(T t, U u) {
            return new Pair<T, U>(t, u);
        }
    }

    private static class GeoPtType
    extends Type<GeoPt> {
        private final AsComparableFunction POINT_VALUE_COMP_FUNC = new AsComparableFunction(){

            public Comparable<GeoPt> asComparable(OnestoreEntity.PropertyValue pv) {
                return GeoPtType.this.getPropertyValue(pv);
            }
        };

        private GeoPtType() {
            super(OnestoreEntity.Property.Meaning.GEORSS_POINT);
        }

        @Override
        public AsComparableFunction getComparableFunction() {
            return this.POINT_VALUE_COMP_FUNC;
        }

        @Override
        public void setPropertyValue(OnestoreEntity.PropertyValue propertyValue, Object value) {
            GeoPt geoPt = (GeoPt)value;
            OnestoreEntity.PropertyValue.PointValue pv = new OnestoreEntity.PropertyValue.PointValue().setX(geoPt.getLatitude()).setY(geoPt.getLongitude());
            propertyValue.setPointValue(pv);
        }

        @Override
        public GeoPt getPropertyValue(OnestoreEntity.PropertyValue propertyValue) {
            OnestoreEntity.PropertyValue.PointValue pv = propertyValue.getPointValue();
            return new GeoPt((float)pv.getX(), (float)pv.getY());
        }

        @Override
        public boolean hasPropertyValue(OnestoreEntity.PropertyValue propertyValue) {
            return propertyValue.hasPointValue();
        }
    }

    private static class IMHandleType
    extends CustomStringType<IMHandle> {
        private IMHandleType() {
            super(OnestoreEntity.Property.Meaning.GD_IM);
        }

        @Override
        protected String asDatastoreString(Object value) {
            return ((IMHandle)value).toDatastoreString();
        }

        @Override
        protected IMHandle fromDatastoreString(String datastoreString) {
            return IMHandle.fromDatastoreString(datastoreString);
        }
    }

    private static class PhoneNumberType
    extends CustomStringType<PhoneNumber> {
        private PhoneNumberType() {
            super(OnestoreEntity.Property.Meaning.GD_PHONENUMBER);
        }

        @Override
        protected String asDatastoreString(Object value) {
            return ((PhoneNumber)value).getNumber();
        }

        @Override
        protected PhoneNumber fromDatastoreString(String datastoreString) {
            return new PhoneNumber(datastoreString);
        }
    }

    private static class PostalAddressType
    extends CustomStringType<PostalAddress> {
        private PostalAddressType() {
            super(OnestoreEntity.Property.Meaning.GD_POSTALADDRESS);
        }

        @Override
        protected String asDatastoreString(Object value) {
            return ((PostalAddress)value).getAddress();
        }

        @Override
        protected PostalAddress fromDatastoreString(String datastoreString) {
            return new PostalAddress(datastoreString);
        }
    }

    private static class EmailType
    extends CustomStringType<Email> {
        private EmailType() {
            super(OnestoreEntity.Property.Meaning.GD_EMAIL);
        }

        @Override
        protected String asDatastoreString(Object value) {
            return ((Email)value).getEmail();
        }

        @Override
        protected Email fromDatastoreString(String datastoreString) {
            return new Email(datastoreString);
        }
    }

    private static class RatingType
    extends CustomInt64Type<Rating> {
        private RatingType() {
            super(OnestoreEntity.Property.Meaning.GD_RATING);
        }

        @Override
        protected Long asDatastoreLong(Object value) {
            return ((Rating)value).getRating();
        }

        @Override
        protected Rating fromDatastoreLong(Long datastoreLong) {
            if (datastoreLong == null) {
                throw new NullPointerException("rating value cannot be null");
            }
            return new Rating(datastoreLong.intValue());
        }
    }

    private static class CategoryType
    extends CustomStringType<Category> {
        private CategoryType() {
            super(OnestoreEntity.Property.Meaning.ATOM_CATEGORY);
        }

        @Override
        protected String asDatastoreString(Object value) {
            return ((Category)value).getCategory();
        }

        @Override
        protected Category fromDatastoreString(String datastoreString) {
            return new Category(datastoreString);
        }
    }

    private static abstract class CustomInt64Type<T>
    extends Type<T> {
        private static final Int64Type INT64_TYPE = new Int64Type();

        private CustomInt64Type(OnestoreEntity.Property.Meaning meaning) {
            super(meaning);
        }

        @Override
        public final void setPropertyValue(OnestoreEntity.PropertyValue propertyValue, Object value) {
            INT64_TYPE.setPropertyValue(propertyValue, this.asDatastoreLong(value));
        }

        @Override
        public final T getPropertyValue(OnestoreEntity.PropertyValue propertyValue) {
            return this.fromDatastoreLong(INT64_TYPE.getPropertyValue(propertyValue));
        }

        @Override
        public final AsComparableFunction getComparableFunction() {
            return INT64_TYPE.getComparableFunction();
        }

        @Override
        public final boolean hasPropertyValue(OnestoreEntity.PropertyValue propertyValue) {
            return INT64_TYPE.hasPropertyValue(propertyValue);
        }

        protected abstract Long asDatastoreLong(Object var1);

        protected abstract T fromDatastoreLong(Long var1);
    }

    private static abstract class CustomStringType<T>
    extends Type<T> {
        private CustomStringType(OnestoreEntity.Property.Meaning meaning) {
            super(meaning);
        }

        @Override
        public final void setPropertyValue(OnestoreEntity.PropertyValue propertyValue, Object value) {
            STRING_TYPE.setPropertyValue(propertyValue, this.asDatastoreString(value));
        }

        @Override
        public final T getPropertyValue(OnestoreEntity.PropertyValue propertyValue) {
            return this.fromDatastoreString(STRING_TYPE.getPropertyValue(propertyValue));
        }

        @Override
        public final AsComparableFunction getComparableFunction() {
            return STRING_TYPE.getComparableFunction();
        }

        @Override
        public final boolean hasPropertyValue(OnestoreEntity.PropertyValue propertyValue) {
            return STRING_TYPE.hasPropertyValue(propertyValue);
        }

        protected abstract String asDatastoreString(Object var1);

        protected abstract T fromDatastoreString(String var1);
    }

    private static class ShortBlobType
    extends Type<ShortBlob> {
        private ShortBlobType() {
            super(OnestoreEntity.Property.Meaning.BYTESTRING);
        }

        @Override
        public void setPropertyValue(OnestoreEntity.PropertyValue propertyValue, Object value) {
            propertyValue.setStringValueAsBytes(((ShortBlob)value).getBytes());
        }

        @Override
        public ShortBlob getPropertyValue(OnestoreEntity.PropertyValue propertyValue) {
            return new ShortBlob(propertyValue.getStringValueAsBytes());
        }

        @Override
        public AsComparableFunction getComparableFunction() {
            return COMP_BYTE_ARRAY_FUNC;
        }

        @Override
        public boolean hasPropertyValue(OnestoreEntity.PropertyValue propertyValue) {
            return propertyValue.hasStringValue();
        }
    }

    private static class LinkType
    extends Type<Link> {
        private LinkType() {
            super(OnestoreEntity.Property.Meaning.ATOM_LINK);
        }

        @Override
        public void setPropertyValue(OnestoreEntity.PropertyValue propertyValue, Object value) {
            Link link = (Link)value;
            propertyValue.setStringValue(link.getValue());
        }

        @Override
        public Link getPropertyValue(OnestoreEntity.PropertyValue propertyValue) {
            return new Link(propertyValue.getStringValue());
        }

        @Override
        public AsComparableFunction getComparableFunction() {
            return COMP_BYTE_ARRAY_FUNC;
        }

        @Override
        public boolean hasPropertyValue(OnestoreEntity.PropertyValue propertyValue) {
            return propertyValue.hasStringValue();
        }
    }

    private static class DateType
    extends Type<Date> {
        private DateType() {
            super(OnestoreEntity.Property.Meaning.GD_WHEN);
        }

        @Override
        public void setPropertyValue(OnestoreEntity.PropertyValue propertyValue, Object value) {
            Date date = (Date)value;
            propertyValue.setInt64Value(date.getTime() * 1000L);
        }

        @Override
        public Date getPropertyValue(OnestoreEntity.PropertyValue propertyValue) {
            return new Date(propertyValue.getInt64Value() / 1000L);
        }

        @Override
        public AsComparableFunction getComparableFunction() {
            return INT_64_COMP_FUNC;
        }

        @Override
        public boolean hasPropertyValue(OnestoreEntity.PropertyValue propertyValue) {
            return propertyValue.hasInt64Value();
        }
    }

    private static class BlobKeyType
    extends CustomStringType<BlobKey> {
        private BlobKeyType() {
            super(OnestoreEntity.Property.Meaning.BLOBKEY);
        }

        @Override
        protected String asDatastoreString(Object value) {
            return ((BlobKey)value).getKeyString();
        }

        @Override
        protected BlobKey fromDatastoreString(String datastoreString) {
            return new BlobKey(datastoreString);
        }
    }

    private static class TextType
    extends Type<Text> {
        private TextType() {
            super(OnestoreEntity.Property.Meaning.TEXT);
        }

        @Override
        public void setPropertyValue(OnestoreEntity.PropertyValue propertyValue, Object value) {
            Text text = (Text)value;
            propertyValue.setStringValue(text.getValue());
        }

        @Override
        public Text getPropertyValue(OnestoreEntity.PropertyValue propertyValue) {
            return new Text(propertyValue.getStringValue());
        }

        @Override
        public boolean hasPropertyValue(OnestoreEntity.PropertyValue propertyValue) {
            return propertyValue.hasStringValue();
        }

        @Override
        public AsComparableFunction getComparableFunction() {
            return NOT_COMPARABLE;
        }
    }

    private static class EmbeddedEntityType
    extends Type<EmbeddedEntity> {
        private EmbeddedEntityType() {
            super(OnestoreEntity.Property.Meaning.ENTITY_PROTO);
        }

        @Override
        public void setPropertyValue(OnestoreEntity.PropertyValue propertyValue, Object value) {
            EmbeddedEntity structProp = (EmbeddedEntity)value;
            OnestoreEntity.EntityProto proto = new OnestoreEntity.EntityProto();
            if (structProp.getKey() != null) {
                proto.setKey(KeyTranslator.convertToPb(structProp.getKey()));
            }
            DataTypeTranslator.addPropertiesToPb(structProp.getPropertyMap(), proto);
            propertyValue.setStringValueAsBytes(proto.toByteArray());
        }

        @Override
        public EmbeddedEntity getPropertyValue(OnestoreEntity.PropertyValue propertyValue) {
            OnestoreEntity.EntityProto proto = new OnestoreEntity.EntityProto();
            proto.mergeFrom(propertyValue.getStringValueAsBytes());
            EmbeddedEntity result = new EmbeddedEntity();
            if (proto.hasKey() && !proto.getKey().getApp().isEmpty()) {
                result.setKey(KeyTranslator.createFromPb(proto.getKey()));
            }
            DataTypeTranslator.extractPropertiesFromPb(proto, result.getPropertyMap());
            return result;
        }

        @Override
        public boolean hasPropertyValue(OnestoreEntity.PropertyValue propertyValue) {
            return propertyValue.hasStringValue();
        }

        @Override
        public AsComparableFunction getComparableFunction() {
            return NOT_COMPARABLE;
        }
    }

    private static class BlobType
    extends Type<Blob> {
        private BlobType() {
            super(OnestoreEntity.Property.Meaning.BLOB);
        }

        @Override
        public void setPropertyValue(OnestoreEntity.PropertyValue propertyValue, Object value) {
            Blob blob = (Blob)value;
            propertyValue.setStringValueAsBytes(blob.getBytes());
        }

        @Override
        public Blob getPropertyValue(OnestoreEntity.PropertyValue propertyValue) {
            byte[] bytes = propertyValue.getStringValueAsBytes();
            return new Blob(bytes);
        }

        @Override
        public boolean hasPropertyValue(OnestoreEntity.PropertyValue propertyValue) {
            return propertyValue.hasStringValue();
        }

        @Override
        public AsComparableFunction getComparableFunction() {
            return NOT_COMPARABLE;
        }
    }

    private static class ReferenceType
    extends Type<Key> {
        private final AsComparableFunction COMP_FUNC = new AsComparableFunction(){

            public Comparable<Key> asComparable(OnestoreEntity.PropertyValue pv) {
                return ReferenceType.this.getPropertyValue(pv);
            }
        };

        private ReferenceType() {
        }

        @Override
        public void setPropertyValue(OnestoreEntity.PropertyValue propertyValue, Object value) {
            OnestoreEntity.Reference keyRef = KeyTranslator.convertToPb((Key)value);
            ReferenceType.setPropertyValue(propertyValue, keyRef);
        }

        private static void setPropertyValue(OnestoreEntity.PropertyValue propertyValue, OnestoreEntity.Reference keyRef) {
            OnestoreEntity.PropertyValue.ReferenceValue refValue = new OnestoreEntity.PropertyValue.ReferenceValue();
            refValue.setApp(keyRef.getApp());
            if (keyRef.hasNameSpace()) {
                refValue.setNameSpace(keyRef.getNameSpace());
            }
            OnestoreEntity.Path path = keyRef.getPath();
            for (OnestoreEntity.Path.Element element : path.elements()) {
                OnestoreEntity.PropertyValue.ReferenceValuePathElement newElement = new OnestoreEntity.PropertyValue.ReferenceValuePathElement();
                newElement.setType(element.getType());
                if (element.hasName()) {
                    newElement.setName(element.getName());
                }
                if (element.hasId()) {
                    newElement.setId(element.getId());
                }
                refValue.addPathElement(newElement);
            }
            propertyValue.setReferenceValue(refValue);
        }

        @Override
        public Key getPropertyValue(OnestoreEntity.PropertyValue propertyValue) {
            OnestoreEntity.Reference reference = new OnestoreEntity.Reference();
            OnestoreEntity.PropertyValue.ReferenceValue refValue = propertyValue.getReferenceValue();
            reference.setApp(refValue.getApp());
            if (refValue.hasNameSpace()) {
                reference.setNameSpace(refValue.getNameSpace());
            }
            OnestoreEntity.Path path = new OnestoreEntity.Path();
            for (OnestoreEntity.PropertyValue.ReferenceValuePathElement element : refValue.pathElements()) {
                OnestoreEntity.Path.Element newElement = new OnestoreEntity.Path.Element();
                newElement.setType(element.getType());
                if (element.hasName()) {
                    newElement.setName(element.getName());
                }
                if (element.hasId()) {
                    newElement.setId(element.getId());
                }
                path.addElement(newElement);
            }
            reference.setPath(path);
            return KeyTranslator.createFromPb(reference);
        }

        @Override
        public boolean hasPropertyValue(OnestoreEntity.PropertyValue propertyValue) {
            return propertyValue.hasReferenceValue();
        }

        @Override
        public AsComparableFunction getComparableFunction() {
            return this.COMP_FUNC;
        }
    }

    private static class UserType
    extends Type<User> {
        private final AsComparableFunction USER_COMP_FUNC = new AsComparableFunction(){

            public Comparable<User> asComparable(OnestoreEntity.PropertyValue pv) {
                return UserType.this.getPropertyValue(pv);
            }
        };

        private UserType() {
        }

        @Override
        public void setPropertyValue(OnestoreEntity.PropertyValue propertyValue, Object value) {
            User user = (User)value;
            OnestoreEntity.PropertyValue.UserValue userValue = new OnestoreEntity.PropertyValue.UserValue();
            userValue.setEmail(user.getEmail());
            userValue.setAuthDomain(user.getAuthDomain());
            userValue.setGaiaid(0L);
            propertyValue.setUserValue(userValue);
        }

        @Override
        public User getPropertyValue(OnestoreEntity.PropertyValue propertyValue) {
            OnestoreEntity.PropertyValue.UserValue userValue = propertyValue.getUserValue();
            String userId = userValue.hasObfuscatedGaiaid() ? userValue.getObfuscatedGaiaid() : null;
            return new User(userValue.getEmail(), userValue.getAuthDomain(), userId);
        }

        @Override
        public boolean hasPropertyValue(OnestoreEntity.PropertyValue propertyValue) {
            return propertyValue.hasUserValue();
        }

        @Override
        public AsComparableFunction getComparableFunction() {
            return this.USER_COMP_FUNC;
        }
    }

    private static class BoolType
    extends Type<Boolean> {
        private BoolType() {
        }

        @Override
        public void setPropertyValue(OnestoreEntity.PropertyValue propertyValue, Object value) {
            if (value != null) {
                propertyValue.setBooleanValue((Boolean)value);
            }
        }

        @Override
        public Boolean getPropertyValue(OnestoreEntity.PropertyValue propertyValue) {
            return propertyValue.isBooleanValue();
        }

        @Override
        public boolean hasPropertyValue(OnestoreEntity.PropertyValue propertyValue) {
            return propertyValue.hasBooleanValue();
        }

        @Override
        public AsComparableFunction getComparableFunction() {
            return BOOLEAN_COMP_FUNC;
        }
    }

    private static class DoubleType
    extends Type<Double> {
        private DoubleType() {
        }

        @Override
        public void setPropertyValue(OnestoreEntity.PropertyValue propertyValue, Object value) {
            if (value != null) {
                propertyValue.setDoubleValue(((Number)value).doubleValue());
            }
        }

        @Override
        public Double getPropertyValue(OnestoreEntity.PropertyValue propertyValue) {
            return propertyValue.hasDoubleValue() ? Double.valueOf(propertyValue.getDoubleValue()) : null;
        }

        @Override
        public boolean hasPropertyValue(OnestoreEntity.PropertyValue propertyValue) {
            return propertyValue.hasDoubleValue();
        }

        @Override
        public AsComparableFunction getComparableFunction() {
            return DOUBLE_COMP_FUNC;
        }
    }

    private static class Int64Type
    extends Type<Long> {
        private Int64Type() {
        }

        @Override
        public void setPropertyValue(OnestoreEntity.PropertyValue propertyValue, Object value) {
            if (value != null) {
                propertyValue.setInt64Value(((Number)value).longValue());
            }
        }

        @Override
        public Long getPropertyValue(OnestoreEntity.PropertyValue propertyValue) {
            return propertyValue.getInt64Value();
        }

        @Override
        public boolean hasPropertyValue(OnestoreEntity.PropertyValue propertyValue) {
            return propertyValue.hasInt64Value();
        }

        @Override
        public AsComparableFunction getComparableFunction() {
            return INT_64_COMP_FUNC;
        }
    }

    private static class RawValueType
    extends Type<RawValue> {
        private RawValueType() {
        }

        @Override
        public void setPropertyValue(OnestoreEntity.PropertyValue propertyValue, Object value) {
            throw new UnsupportedOperationException();
        }

        @Override
        public RawValue getPropertyValue(OnestoreEntity.PropertyValue propertyValue) {
            return new RawValue(propertyValue);
        }

        @Override
        public AsComparableFunction getComparableFunction() {
            return COMP_RAW_VALUE_FUNC;
        }

        @Override
        public boolean hasPropertyValue(OnestoreEntity.PropertyValue propertyValue) {
            return true;
        }

        @Override
        public OnestoreEntity.Property.Meaning getMeaning() {
            return OnestoreEntity.Property.Meaning.INDEX_VALUE;
        }
    }

    private static class StringType
    extends Type<String> {
        private StringType() {
        }

        @Override
        public void setPropertyValue(OnestoreEntity.PropertyValue propertyValue, Object value) {
            propertyValue.setStringValue((String)value);
        }

        @Override
        public String getPropertyValue(OnestoreEntity.PropertyValue propertyValue) {
            return propertyValue.getStringValue();
        }

        @Override
        public boolean hasPropertyValue(OnestoreEntity.PropertyValue propertyValue) {
            return propertyValue.hasStringValue();
        }

        @Override
        public AsComparableFunction getComparableFunction() {
            return COMP_BYTE_ARRAY_FUNC;
        }
    }

    static abstract class Type<T> {
        private final OnestoreEntity.Property.Meaning meaning;

        protected Type(OnestoreEntity.Property.Meaning meaning) {
            this.meaning = meaning;
        }

        protected Type() {
            this(OnestoreEntity.Property.Meaning.NO_MEANING);
        }

        public abstract AsComparableFunction getComparableFunction();

        public OnestoreEntity.Property.Meaning getMeaning() {
            return this.meaning;
        }

        public abstract void setPropertyValue(OnestoreEntity.PropertyValue var1, Object var2);

        public abstract T getPropertyValue(OnestoreEntity.PropertyValue var1);

        public abstract boolean hasPropertyValue(OnestoreEntity.PropertyValue var1);
    }

    private static interface AsComparableFunction {
        public Comparable<?> asComparable(OnestoreEntity.PropertyValue var1);
    }
}

