/*
 * Decompiled with CFR 0.152.
 */
package mediautil.image.jpeg;

import mediautil.image.jpeg.BasicJpegIo;

class Header
extends BasicJpegIo {
    int minorVersion;
    int dllVersion;
    boolean intelByteOrder;
    int sectorSize;
    static final int SECTORSIZEOFF = 30;
    int miniSectorSize;
    static final int MINISECTORSIZEOFF = 32;
    int sectsFat;
    static final int SECTSFATOFF = 44;
    int sectDirStart;
    static final int SECTDIRSTARTOFF = 48;
    int miniSectorCutoff;
    static final int MINISECTORCUTOFFOFF = 56;
    int sectMiniFatStart;
    static final int SECTMINIFATSTARTOFF = 60;
    int sectsMiniFat;
    static final int SECTSMINIFATOFF = 64;
    int sectDifStart;
    static final int SECTDIFSTARTOFF = 68;
    int sectsDif;
    static final int SECTSDIFOFF = 72;
    int[] fat;
    static final int FATOFF = 76;
    static final int FIRST_FAT_SIZE = 109;

    Header() {
    }

    void fill(byte[] data, int offset) {
        this.data = data;
        this.intel = true;
        this.intelByteOrder = true;
        this.sectorSize = 1 << this.s2n(30 + offset, 2);
        this.miniSectorSize = 1 << this.s2n(32 + offset, 2);
        this.sectsFat = this.s2n(44 + offset, 4);
        this.sectDirStart = this.s2n(48 + offset, 4);
        this.miniSectorCutoff = this.s2n(56 + offset, 4);
        this.sectMiniFatStart = this.s2n(60 + offset, 4);
        this.sectsMiniFat = this.s2n(64 + offset, 4);
        this.sectDifStart = this.s2n(68 + offset, 4);
        this.sectsDif = this.s2n(72 + offset, 4);
        this.fat = new int[109];
        for (int i = 0; i < 109; ++i) {
            this.fat[i] = this.s2n(76 + offset + 4 * i, 4);
        }
    }

    public String toString() {
        String result = "Sector size " + this.sectorSize + ", mini sector size " + this.miniSectorSize + ", sectors in FAT " + this.sectsFat + ", directory sector " + this.sectDirStart + ", max size of mini stream " + this.miniSectorCutoff + ", mini FAT starts " + this.sectMiniFatStart + ", sectors in mini FAT " + this.sectsMiniFat + ", first DIF and numbers " + this.sectDifStart + ':' + this.sectsDif;
        return result;
    }
}

