/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.repackaged.org.apache.commons.httpclient;

import com.google.appengine.repackaged.org.apache.commons.httpclient.ConnectMethod;
import com.google.appengine.repackaged.org.apache.commons.httpclient.HostConfiguration;
import com.google.appengine.repackaged.org.apache.commons.httpclient.HttpConnection;
import com.google.appengine.repackaged.org.apache.commons.httpclient.HttpConnectionManager;
import com.google.appengine.repackaged.org.apache.commons.httpclient.HttpException;
import com.google.appengine.repackaged.org.apache.commons.httpclient.HttpMethodDirector;
import com.google.appengine.repackaged.org.apache.commons.httpclient.HttpState;
import com.google.appengine.repackaged.org.apache.commons.httpclient.params.HttpClientParams;
import com.google.appengine.repackaged.org.apache.commons.httpclient.params.HttpConnectionManagerParams;
import com.google.appengine.repackaged.org.apache.commons.httpclient.params.HttpParams;
import java.io.IOException;
import java.net.Socket;

public class ProxyClient {
    private HttpState state = new HttpState();
    private HttpClientParams params = null;
    private HostConfiguration hostConfiguration = new HostConfiguration();

    public ProxyClient() {
        this(new HttpClientParams());
    }

    public ProxyClient(HttpClientParams httpClientParams) {
        if (httpClientParams == null) {
            throw new IllegalArgumentException("Params may not be null");
        }
        this.params = httpClientParams;
    }

    public synchronized HttpState getState() {
        return this.state;
    }

    public synchronized void setState(HttpState httpState) {
        this.state = httpState;
    }

    public synchronized HostConfiguration getHostConfiguration() {
        return this.hostConfiguration;
    }

    public synchronized void setHostConfiguration(HostConfiguration hostConfiguration) {
        this.hostConfiguration = hostConfiguration;
    }

    public synchronized HttpClientParams getParams() {
        return this.params;
    }

    public synchronized void setParams(HttpClientParams httpClientParams) {
        if (httpClientParams == null) {
            throw new IllegalArgumentException("Parameters may not be null");
        }
        this.params = httpClientParams;
    }

    public ConnectResponse connect() throws IOException, HttpException {
        HostConfiguration hostConfiguration = this.getHostConfiguration();
        if (hostConfiguration.getProxyHost() == null) {
            throw new IllegalStateException("proxy host must be configured");
        }
        if (hostConfiguration.getHost() == null) {
            throw new IllegalStateException("destination host must be configured");
        }
        if (hostConfiguration.getProtocol().isSecure()) {
            throw new IllegalStateException("secure protocol socket factory may not be used");
        }
        ConnectMethod connectMethod = new ConnectMethod(this.getHostConfiguration());
        connectMethod.getParams().setDefaults(this.getParams());
        DummyConnectionManager dummyConnectionManager = new DummyConnectionManager();
        dummyConnectionManager.setConnectionParams(this.getParams());
        HttpMethodDirector httpMethodDirector = new HttpMethodDirector(dummyConnectionManager, hostConfiguration, this.getParams(), this.getState());
        httpMethodDirector.executeMethod(connectMethod);
        ConnectResponse connectResponse = new ConnectResponse();
        connectResponse.setConnectMethod(connectMethod);
        if (connectMethod.getStatusCode() == 200) {
            connectResponse.setSocket(dummyConnectionManager.getConnection().getSocket());
        } else {
            dummyConnectionManager.getConnection().close();
        }
        return connectResponse;
    }

    static class DummyConnectionManager
    implements HttpConnectionManager {
        private HttpConnection httpConnection;
        private HttpParams connectionParams;

        DummyConnectionManager() {
        }

        public void closeIdleConnections(long l) {
        }

        public HttpConnection getConnection() {
            return this.httpConnection;
        }

        public void setConnectionParams(HttpParams httpParams) {
            this.connectionParams = httpParams;
        }

        public HttpConnection getConnectionWithTimeout(HostConfiguration hostConfiguration, long l) {
            this.httpConnection = new HttpConnection(hostConfiguration);
            this.httpConnection.setHttpConnectionManager(this);
            this.httpConnection.getParams().setDefaults(this.connectionParams);
            return this.httpConnection;
        }

        public HttpConnection getConnection(HostConfiguration hostConfiguration, long l) throws HttpException {
            return this.getConnectionWithTimeout(hostConfiguration, l);
        }

        public HttpConnection getConnection(HostConfiguration hostConfiguration) {
            return this.getConnectionWithTimeout(hostConfiguration, -1L);
        }

        public void releaseConnection(HttpConnection httpConnection) {
        }

        public HttpConnectionManagerParams getParams() {
            return null;
        }

        public void setParams(HttpConnectionManagerParams httpConnectionManagerParams) {
        }
    }

    public static class ConnectResponse {
        private ConnectMethod connectMethod;
        private Socket socket;

        private ConnectResponse() {
        }

        public ConnectMethod getConnectMethod() {
            return this.connectMethod;
        }

        private void setConnectMethod(ConnectMethod connectMethod) {
            this.connectMethod = connectMethod;
        }

        public Socket getSocket() {
            return this.socket;
        }

        private void setSocket(Socket socket) {
            this.socket = socket;
        }
    }
}

