/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.api.socket.dev;

import com.google.appengine.repackaged.com.google.common.annotations.VisibleForTesting;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.DatagramPacket;
import java.net.DatagramSocketImpl;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.SocketAddress;
import java.net.SocketException;

public class DatagramSocketImplAccessor {
    private static final Method DEFAULT_DATAGRAM_SOCKET_IMPL_FACTORY = DatagramSocketImplAccessor.fetchDatagramFactory();
    private static final Constructor<?> DATAGRAM_SOCKET_IMPL_CONSTRUCTOR = DatagramSocketImplAccessor.fetchDatagramConstructor();
    private static final Method CREATE = DatagramSocketImplAccessor.fetchMethod("create", new Class[0]);
    private static final Method BIND = DatagramSocketImplAccessor.fetchMethod("bind", Integer.TYPE, InetAddress.class);
    private static final Method SEND = DatagramSocketImplAccessor.fetchMethod("send", DatagramPacket.class);
    private static final Method PEEK_DATA = DatagramSocketImplAccessor.fetchMethod("peekData", DatagramPacket.class);
    private static final Method RECEIVE = DatagramSocketImplAccessor.fetchMethod("receive", DatagramPacket.class);
    private static final Method SET_TTL = DatagramSocketImplAccessor.fetchMethod("setTTL", Byte.TYPE);
    private static final Method GET_TTL = DatagramSocketImplAccessor.fetchMethod("getTTL", new Class[0]);
    private static final Method CLOSE = DatagramSocketImplAccessor.fetchMethod("close", new Class[0]);
    private static final Method SET_TIME_TO_LIVE = DatagramSocketImplAccessor.fetchMethod("setTimeToLive", Integer.TYPE);
    private static final Method GET_TIME_TO_LIVE = DatagramSocketImplAccessor.fetchMethod("getTimeToLive", new Class[0]);
    private static final Method JOIN = DatagramSocketImplAccessor.fetchMethod("join", InetAddress.class);
    private static final Method LEAVE = DatagramSocketImplAccessor.fetchMethod("leave", InetAddress.class);
    private static final Method JOIN_GROUP = DatagramSocketImplAccessor.fetchMethod("joinGroup", SocketAddress.class, NetworkInterface.class);
    private static final Method LEAVE_GROUP = DatagramSocketImplAccessor.fetchMethod("leaveGroup", SocketAddress.class, NetworkInterface.class);
    private static final Method GET_LOCAL_PORT = DatagramSocketImplAccessor.fetchMethod("getLocalPort", new Class[0]);
    private static final Method CONNECT = DatagramSocketImplAccessor.fetchMethod("connect", InetAddress.class, Integer.TYPE);
    private static final DatagramSocketImplAccessorFactory BASE_FACTORY;
    DatagramSocketImpl socketImpl;
    private static DatagramSocketImplAccessorFactory factory;

    public DatagramSocketImplAccessor(DatagramSocketImpl socketImpl) {
        this.socketImpl = socketImpl;
    }

    private static Constructor<?> fetchDatagramConstructor() {
        Constructor<?> constructor;
        try {
            constructor = Class.forName("java.net.PlainDatagramSocketImpl").getDeclaredConstructor(new Class[0]);
        }
        catch (SecurityException e) {
            throw new IllegalStateException(e);
        }
        catch (NoSuchMethodException e) {
            return null;
        }
        catch (ClassNotFoundException e) {
            return null;
        }
        constructor.setAccessible(true);
        return constructor;
    }

    private static Method fetchDatagramFactory() {
        Method createDatagramSocketImpl;
        try {
            createDatagramSocketImpl = Class.forName("java.net.DefaultDatagramSocketImplFactory").getDeclaredMethod("createDatagramSocketImpl", Boolean.TYPE);
        }
        catch (SecurityException e) {
            throw new IllegalStateException(e);
        }
        catch (NoSuchMethodException e) {
            return null;
        }
        catch (ClassNotFoundException e) {
            return null;
        }
        createDatagramSocketImpl.setAccessible(true);
        return createDatagramSocketImpl;
    }

    static Method fetchMethod(String name, Class<?> ... parameterTypes) {
        Method method;
        try {
            method = DatagramSocketImpl.class.getDeclaredMethod(name, parameterTypes);
        }
        catch (SecurityException e) {
            throw new IllegalStateException(e);
        }
        catch (NoSuchMethodException e) {
            throw new IllegalStateException(e);
        }
        method.setAccessible(true);
        return method;
    }

    private Object invokeSocketException(Method method, Object ... args) throws SocketException {
        try {
            return method.invoke((Object)this.socketImpl, args);
        }
        catch (IllegalArgumentException e) {
            throw new IllegalStateException(e);
        }
        catch (IllegalAccessException e) {
            throw new IllegalStateException(e);
        }
        catch (InvocationTargetException e) {
            if (e.getCause() instanceof SocketException) {
                throw (SocketException)e.getCause();
            }
            throw new IllegalStateException("Unexpected exception thrown by method: " + this.socketImpl.getClass().getSimpleName() + "#" + method.getName(), e.getCause());
        }
    }

    private Object invokeIOException(Method method, Object ... args) throws IOException {
        try {
            return method.invoke((Object)this.socketImpl, args);
        }
        catch (IllegalArgumentException e) {
            throw new IllegalStateException(e);
        }
        catch (IllegalAccessException e) {
            throw new IllegalStateException(e);
        }
        catch (InvocationTargetException e) {
            if (e.getCause() instanceof IOException) {
                throw (IOException)e.getCause();
            }
            throw new IllegalStateException("Unexpected exception thrown by method: " + this.socketImpl.getClass().getSimpleName() + "#" + method.getName(), e.getCause());
        }
    }

    private Object invoke(Method method, Object ... args) {
        try {
            return method.invoke((Object)this.socketImpl, args);
        }
        catch (IllegalArgumentException e) {
            throw new IllegalStateException(e);
        }
        catch (IllegalAccessException e) {
            throw new IllegalStateException(e);
        }
        catch (InvocationTargetException e) {
            throw new IllegalStateException("Unexpected exception thrown by method: " + this.socketImpl.getClass().getSimpleName() + "#" + method.getName(), e.getCause());
        }
    }

    private static DatagramSocketImpl newDatagramSocketImpl() {
        if (DEFAULT_DATAGRAM_SOCKET_IMPL_FACTORY != null) {
            try {
                return (DatagramSocketImpl)DEFAULT_DATAGRAM_SOCKET_IMPL_FACTORY.invoke(null, false);
            }
            catch (IllegalArgumentException e) {
                throw new IllegalStateException(e);
            }
            catch (IllegalAccessException e) {
                throw new IllegalStateException(e);
            }
            catch (InvocationTargetException e) {
                throw new IllegalStateException(e);
            }
        }
        try {
            return (DatagramSocketImpl)DATAGRAM_SOCKET_IMPL_CONSTRUCTOR.newInstance(new Object[0]);
        }
        catch (IllegalArgumentException e) {
            throw new IllegalStateException(e);
        }
        catch (InstantiationException e) {
            throw new IllegalStateException(e);
        }
        catch (IllegalAccessException e) {
            throw new IllegalStateException(e);
        }
        catch (InvocationTargetException e) {
            throw new IllegalStateException(e);
        }
    }

    @VisibleForTesting
    public static DatagramSocketImplAccessor newSocketImplAccessor() {
        return factory.newDatagramSocketImplAccessor();
    }

    static void setDatagramSocketImplAccessorFactory(DatagramSocketImplAccessorFactory factory) {
        DatagramSocketImplAccessor.factory = factory == null ? BASE_FACTORY : factory;
    }

    public void setOption(int optID, Object value) throws SocketException {
        this.socketImpl.setOption(optID, value);
    }

    public Object getOption(int optID) throws SocketException {
        return this.socketImpl.getOption(optID);
    }

    protected void create() throws SocketException {
        this.invokeSocketException(CREATE, new Object[0]);
    }

    protected void bind(int lport, InetAddress laddr) throws SocketException {
        this.invokeSocketException(BIND, lport, laddr);
    }

    protected void send(DatagramPacket p) throws IOException {
        this.invokeIOException(SEND, p);
    }

    protected int peek(InetAddress i) {
        throw new IllegalStateException("DatagramSocketImplAccessor#peek(InetAddress) is not implemented");
    }

    protected int peekData(DatagramPacket p) throws IOException {
        return (Integer)this.invokeIOException(PEEK_DATA, p);
    }

    protected void receive(DatagramPacket p) throws IOException {
        this.invokeIOException(RECEIVE, p);
    }

    protected void setTTL(byte ttl) throws IOException {
        this.invokeIOException(SET_TTL, ttl);
    }

    protected byte getTTL() throws IOException {
        return (Byte)this.invokeIOException(GET_TTL, new Object[0]);
    }

    protected void setTimeToLive(int ttl) throws IOException {
        this.invokeIOException(SET_TIME_TO_LIVE, ttl);
    }

    protected int getTimeToLive() throws IOException {
        return (Integer)this.invokeIOException(GET_TIME_TO_LIVE, new Object[0]);
    }

    protected void join(InetAddress inetaddr) throws IOException {
        this.invokeIOException(JOIN, inetaddr);
    }

    protected void leave(InetAddress inetaddr) throws IOException {
        this.invokeIOException(LEAVE, inetaddr);
    }

    protected void joinGroup(SocketAddress mcastaddr, NetworkInterface netIf) throws IOException {
        this.invokeIOException(JOIN_GROUP, mcastaddr, netIf);
    }

    protected void leaveGroup(SocketAddress mcastaddr, NetworkInterface netIf) throws IOException {
        this.invokeIOException(LEAVE_GROUP, mcastaddr, netIf);
    }

    protected void close() {
        this.invoke(CLOSE, new Object[0]);
    }

    public int getLocalPort() {
        return (Integer)this.invoke(GET_LOCAL_PORT, new Object[0]);
    }

    protected void connect(InetAddress address, int port) throws SocketException {
        this.invokeSocketException(CONNECT, address, port);
    }

    static {
        factory = BASE_FACTORY = new DatagramSocketImplAccessorFactory(){

            @Override
            public DatagramSocketImplAccessor newDatagramSocketImplAccessor() {
                return new DatagramSocketImplAccessor(DatagramSocketImplAccessor.newDatagramSocketImpl());
            }
        };
    }

    @VisibleForTesting
    static interface DatagramSocketImplAccessorFactory {
        public DatagramSocketImplAccessor newDatagramSocketImplAccessor();
    }
}

