/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.api.search.dev;

import com.google.appengine.api.search.dev.EvaluationException;
import com.google.appengine.api.search.dev.Expression;
import com.google.appengine.api.search.dev.ExpressionBuilder;
import com.google.appengine.api.search.dev.LuceneUtils;
import com.google.appengine.api.search.dev.NumericExpression;
import com.google.appengine.api.search.dev.SnippetExpressionQueryParser;
import com.google.appengine.repackaged.com.google.common.annotations.VisibleForTesting;
import com.google.apphosting.api.search.DocumentPb;
import java.io.IOException;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.PriorityQueue;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.lucene.analysis.standard.StandardTokenizer;
import org.apache.lucene.analysis.tokenattributes.OffsetAttribute;
import org.apache.lucene.analysis.tokenattributes.TermAttribute;
import org.apache.lucene.document.Document;

public class SnippetExpression
extends Expression {
    private static final String ELLIPSIS = "<b>...</b>";
    private static final String TOKEN_START = "<b>";
    private static final String TOKEN_END = "</b>";
    private static final int INVALID = 0x3FFFFFFF;
    private static final Pattern HTML_SPECIAL_CHARS_PATTERN = Pattern.compile("['\"&<>]");
    private final List<String> luceneFields;
    private final NumericExpression maxCharsExpression;
    private final NumericExpression maxSnippetsExpression;
    private final Map<String, Integer> tokenIds = new HashMap<String, Integer>();
    private final TokenState[] tokenStates;

    private SnippetExpression(List<String> tokens, List<String> luceneFields, NumericExpression maxCharsExpression, NumericExpression maxSnippetsExpression) {
        this.tokenStates = new TokenState[tokens.size()];
        int id = 0;
        for (String token : tokens) {
            this.tokenIds.put(token.toUpperCase(), id);
            this.tokenStates[id] = new TokenState(token);
            ++id;
        }
        this.luceneFields = luceneFields;
        this.maxCharsExpression = maxCharsExpression;
        this.maxSnippetsExpression = maxSnippetsExpression;
    }

    public static Expression makeSnippetExpression(String query, String fieldName, Set<DocumentPb.FieldValue.ContentType> fieldTypes, NumericExpression maxCharsExpression, NumericExpression maxSnippetsExpression) {
        ArrayList<String> luceneFields = new ArrayList<String>(fieldTypes.size());
        if (fieldTypes.contains(DocumentPb.FieldValue.ContentType.TEXT)) {
            luceneFields.add(LuceneUtils.makeLuceneFieldNameWithExtractedText(fieldName, DocumentPb.FieldValue.ContentType.TEXT));
        }
        if (fieldTypes.contains(DocumentPb.FieldValue.ContentType.HTML)) {
            luceneFields.add(LuceneUtils.makeLuceneFieldNameWithExtractedText(fieldName, DocumentPb.FieldValue.ContentType.HTML));
        }
        if (luceneFields.isEmpty()) {
            throw new IllegalArgumentException("Can only snippet TEXT and HTML fields");
        }
        List<String> tokens = new SnippetExpressionQueryParser(fieldName).parse(query);
        if (tokens == null) {
            return new ExpressionBuilder.EmptyExpression();
        }
        return new SnippetExpression(tokens, luceneFields, maxCharsExpression, maxSnippetsExpression);
    }

    private String findField(Document doc) throws EvaluationException {
        for (String luceneFieldName : this.luceneFields) {
            String[] values = doc.getValues(luceneFieldName);
            if (values.length == 0) continue;
            return values[0];
        }
        throw new EvaluationException("no text or html field found in the document");
    }

    @VisibleForTesting
    void addHtmlEscaped(StringBuilder result, String text, int start, int end) {
        if (start > end) {
            return;
        }
        Matcher matcher = HTML_SPECIAL_CHARS_PATTERN.matcher(text).region(start, end);
        while (matcher.find()) {
            int matchStart = matcher.start();
            result.append(text, start, matchStart);
            String replaceWith = null;
            switch (text.charAt(matchStart)) {
                case '\'': {
                    replaceWith = "&#39;";
                    break;
                }
                case '\"': {
                    replaceWith = "&quot;";
                    break;
                }
                case '&': {
                    replaceWith = "&amp;";
                    break;
                }
                case '<': {
                    replaceWith = "&lt;";
                    break;
                }
                case '>': {
                    replaceWith = "&gt;";
                    break;
                }
                default: {
                    throw new RuntimeException("internal error");
                }
            }
            result.append(replaceWith);
            start = matchStart + 1;
        }
        if (start < end) {
            result.append(text, start, end);
        }
    }

    private void addText(StringBuilder result, String text, int start, int end, int limit) {
        this.addHtmlEscaped(result, text, start, Math.min(end, limit));
    }

    private void addHighlighted(StringBuilder result, String text, int start, int end, int limit) {
        if (start > limit) {
            return;
        }
        result.append(TOKEN_START);
        this.addText(result, text, start, end, limit);
        result.append(TOKEN_END);
    }

    private String formatSnippet(String text, int startPos, int size, int maxChars, int maxSnippets) {
        StringBuilder result = new StringBuilder();
        PriorityQueue<TokenState> tokenMinHeap = new PriorityQueue<TokenState>();
        for (TokenState tokenState : this.tokenStates) {
            tokenState.startIteration();
            tokenMinHeap.add(tokenState);
        }
        int endPos = startPos + size;
        if (size < maxChars) {
            int extra = (maxChars - size) / 2;
            startPos -= extra;
            endPos += extra;
        }
        if (startPos < 0) {
            startPos = 0;
        }
        if (endPos - startPos > maxChars) {
            endPos = startPos + maxChars;
        }
        if (endPos > text.length()) {
            endPos = text.length();
        }
        if (startPos != 0) {
            result.append(ELLIPSIS);
        }
        int currentPos = startPos;
        while (true) {
            TokenState minToken = (TokenState)tokenMinHeap.poll();
            int tokenStartOffset = minToken.getCurrentOffset();
            int tokenEndOffset = minToken.getCurrentEndOffset();
            if (currentPos <= tokenEndOffset) {
                if (currentPos > tokenStartOffset) {
                    this.addHighlighted(result, text, currentPos, tokenEndOffset, endPos);
                    currentPos = tokenEndOffset;
                } else {
                    this.addText(result, text, currentPos, tokenStartOffset, endPos);
                    this.addHighlighted(result, text, tokenStartOffset, tokenEndOffset, endPos);
                    currentPos = tokenEndOffset;
                }
            }
            if (currentPos >= endPos) break;
            minToken.nextEndOffset();
            tokenMinHeap.add(minToken);
        }
        if (endPos != text.length()) {
            result.append(ELLIPSIS);
        }
        return result.toString();
    }

    @VisibleForTesting
    String makeSnippet(String text, int maxChars, int maxSnippets) {
        for (int i = 0; i < this.tokenStates.length; ++i) {
            this.tokenStates[i].reset();
        }
        StandardTokenizer tokenStream = new StandardTokenizer(new StringReader(text));
        OffsetAttribute offsetAttribute = (OffsetAttribute)tokenStream.getAttribute(OffsetAttribute.class);
        TermAttribute termAttribute = (TermAttribute)tokenStream.getAttribute(TermAttribute.class);
        try {
            while (tokenStream.incrementToken()) {
                String term = termAttribute.term().toUpperCase();
                Integer id = this.tokenIds.get(term);
                if (id == null) continue;
                int startOffset = offsetAttribute.startOffset();
                this.tokenStates[id].addOffset(startOffset);
            }
        }
        catch (IOException e) {
            throw new RuntimeException("internal error");
        }
        PriorityQueue<TokenState> tokenMinHeap = new PriorityQueue<TokenState>();
        int maxEndOffset = 0;
        int minSnippetSize = text.length();
        int minSnippetOffset = 0;
        for (TokenState tokenState : this.tokenStates) {
            int endOffset = tokenState.startIteration();
            if (endOffset == 0x3FFFFFFF) continue;
            maxEndOffset = Math.max(maxEndOffset, endOffset);
            tokenMinHeap.add(tokenState);
        }
        if (tokenMinHeap.peek() == null) {
            return "";
        }
        while (true) {
            TokenState minToken;
            int minOffset;
            int snippetSize;
            if (minSnippetSize > (snippetSize = maxEndOffset - (minOffset = (minToken = (TokenState)tokenMinHeap.poll()).getCurrentOffset()))) {
                minSnippetSize = snippetSize;
                minSnippetOffset = minOffset;
            }
            if ((maxEndOffset = Math.max(maxEndOffset, minToken.nextEndOffset())) == 0x3FFFFFFF) break;
            tokenMinHeap.add(minToken);
        }
        return this.formatSnippet(text, minSnippetOffset, minSnippetSize, maxChars, maxSnippets);
    }

    public String evalHtml(Document doc) throws EvaluationException {
        String fieldText = this.findField(doc);
        if (fieldText == null) {
            return null;
        }
        int maxChars = (int)this.maxCharsExpression.evalDouble(doc);
        int maxSnippets = (int)this.maxSnippetsExpression.evalDouble(doc);
        if (maxChars <= 0) {
            return null;
        }
        return this.makeSnippet(fieldText, maxChars, maxSnippets);
    }

    @Override
    public DocumentPb.FieldValue eval(Document doc) throws EvaluationException {
        String html = this.evalHtml(doc);
        if (html == null) {
            return null;
        }
        return SnippetExpression.makeValue(DocumentPb.FieldValue.ContentType.HTML, html);
    }

    @Override
    public List<Expression.Sorter> getSorters(final int sign, double defaultValueNumeric, final String defaultValueText) {
        ArrayList<Expression.Sorter> sorters = new ArrayList<Expression.Sorter>(1);
        sorters.add(new Expression.Sorter(){

            @Override
            public Object eval(Document doc) {
                try {
                    return SnippetExpression.this.evalHtml(doc);
                }
                catch (EvaluationException e) {
                    return defaultValueText;
                }
            }

            @Override
            public int compare(Object left, Object right) {
                String leftHtml = (String)left;
                String rightHtml = (String)right;
                return sign * leftHtml.compareToIgnoreCase(rightHtml);
            }
        });
        return sorters;
    }

    private static class TokenState
    implements Comparable<TokenState> {
        private final int size;
        private final List<Integer> tokenOffsets;
        private int currentTokenOffsetsPosition;
        private int currentOffset;

        public TokenState(String text) {
            this.size = text.length();
            this.tokenOffsets = new ArrayList<Integer>();
        }

        public void reset() {
            this.tokenOffsets.clear();
            this.currentOffset = 0x3FFFFFFF;
            this.currentTokenOffsetsPosition = 0x3FFFFFFF;
        }

        public void addOffset(int offset) {
            this.tokenOffsets.add(offset);
        }

        public int startIteration() {
            if (this.tokenOffsets.isEmpty()) {
                return 0x3FFFFFFF;
            }
            this.currentTokenOffsetsPosition = 0;
            this.currentOffset = this.tokenOffsets.get(this.currentTokenOffsetsPosition);
            return this.currentOffset + this.size;
        }

        public int getCurrentOffset() {
            return this.currentOffset;
        }

        public int getCurrentEndOffset() {
            return this.currentOffset + this.size;
        }

        public int nextEndOffset() {
            ++this.currentTokenOffsetsPosition;
            if (this.currentTokenOffsetsPosition < this.tokenOffsets.size()) {
                this.currentOffset = this.tokenOffsets.get(this.currentTokenOffsetsPosition);
                return this.currentOffset + this.size;
            }
            this.currentOffset = 0x3FFFFFFF;
            return this.currentOffset;
        }

        @Override
        public int compareTo(TokenState otherToken) {
            return this.currentOffset == otherToken.currentOffset ? 0 : (this.currentOffset < otherToken.currentOffset ? -1 : 1);
        }
    }
}

