/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.api.channel.dev;

import com.google.appengine.api.channel.ChannelServicePb;
import com.google.appengine.api.channel.dev.ChannelManager;
import com.google.appengine.api.channel.dev.LocalChannelFailureException;
import com.google.appengine.api.urlfetch.dev.LocalURLFetchService;
import com.google.appengine.tools.development.AbstractLocalRpcService;
import com.google.appengine.tools.development.LatencyPercentiles;
import com.google.appengine.tools.development.LocalRpcService;
import com.google.appengine.tools.development.LocalServiceContext;
import com.google.appengine.tools.development.ServiceProvider;
import com.google.apphosting.api.ApiBasePb;
import com.google.apphosting.api.ApiProxy;
import java.util.HashMap;
import java.util.Map;

@ServiceProvider(value=LocalRpcService.class)
public final class LocalChannelService
extends AbstractLocalRpcService {
    public static final int CHANNEL_TOKEN_DEFAULT_DURATION = 120;
    public static final String PACKAGE = "channel";
    private ChannelManager channelManager;
    private LocalURLFetchService fetchService;

    public void start() {
    }

    public void stop() {
        this.channelManager = null;
        if (this.fetchService != null) {
            this.fetchService.stop();
            this.fetchService = null;
        }
    }

    public ChannelManager getChannelManager() {
        return this.channelManager;
    }

    public void init(LocalServiceContext context, Map<String, String> properties) {
        this.fetchService = this.createFetchService(properties);
        this.channelManager = new ChannelManager(context.getLocalServerEnvironment(), this.fetchService);
    }

    public LocalURLFetchService createFetchService(Map<String, String> properties) {
        if (properties.get("appengine.dev.inbound-services") == null || !properties.get("appengine.dev.inbound-services").contains("channel_presence")) {
            return null;
        }
        LocalURLFetchService fetchService = new LocalURLFetchService();
        fetchService.init(null, new HashMap<String, String>());
        fetchService.setTimeoutInMs(30000);
        return fetchService;
    }

    public String getPackage() {
        return PACKAGE;
    }

    public ChannelServicePb.CreateChannelResponse createChannel(LocalRpcService.Status status, ChannelServicePb.CreateChannelRequest request) {
        if (!request.hasApplicationKey() || request.getApplicationKey().equals("")) {
            throw new ApiProxy.ApplicationException(ChannelServicePb.ChannelServiceError.ErrorCode.INVALID_CHANNEL_KEY.getValue());
        }
        ChannelServicePb.CreateChannelResponse response = new ChannelServicePb.CreateChannelResponse();
        int duration = request.hasDurationMinutes() ? request.getDurationMinutes() : 120;
        response.setToken(this.channelManager.createChannel(request.getApplicationKey(), duration));
        return response;
    }

    @LatencyPercentiles(latency50th=40)
    public ApiBasePb.VoidProto sendChannelMessage(LocalRpcService.Status status, ChannelServicePb.SendMessageRequest request) {
        if (!request.hasMessage() || request.getMessage().equals("")) {
            throw new ApiProxy.ApplicationException(ChannelServicePb.ChannelServiceError.ErrorCode.BAD_MESSAGE.getValue());
        }
        try {
            this.channelManager.sendMessage(request.getApplicationKey(), request.getMessage());
        }
        catch (LocalChannelFailureException e) {
            throw new ApiProxy.ApplicationException(ChannelServicePb.ChannelServiceError.ErrorCode.INVALID_CHANNEL_KEY.getValue());
        }
        ApiBasePb.VoidProto response = new ApiBasePb.VoidProto();
        return response;
    }
}

