/*
 * Decompiled with CFR 0.152.
 */
package com.google.apphosting.utils.config;

import com.google.apphosting.utils.config.AppEngineApplicationXml;
import com.google.apphosting.utils.config.AppEngineConfigException;
import com.google.apphosting.utils.config.XmlUtils;
import java.io.InputStream;
import java.util.logging.Logger;
import org.mortbay.xml.XmlParser;

public class AppEngineApplicationXmlReader {
    private static final String EMPTY_STRING = "";
    private static final Logger logger = Logger.getLogger(AppEngineApplicationXmlReader.class.getName());

    public AppEngineApplicationXml processXml(InputStream is) throws AppEngineConfigException {
        AppEngineApplicationXml.Builder builder = new AppEngineApplicationXml.Builder();
        String applicationId = EMPTY_STRING;
        for (Object o : XmlUtils.parse(is)) {
            if (!(o instanceof XmlParser.Node)) continue;
            XmlParser.Node node = (XmlParser.Node)o;
            if (node.getTag().equals("application")) {
                applicationId = XmlUtils.getText(node);
                continue;
            }
            throw new AppEngineConfigException("Unrecognized element <" + node.getTag() + "> in appengine-application.xml.");
        }
        if (applicationId.equals(EMPTY_STRING)) {
            throw new AppEngineConfigException("Missing or empty <application> element in appengine-application.xml.");
        }
        return builder.setApplicationId(applicationId).build();
    }
}

