/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.tools.development.testing;

import com.google.appengine.api.NamespaceManager;
import com.google.appengine.tools.development.ApiProxyLocal;
import com.google.appengine.tools.development.ApiProxyLocalFactory;
import com.google.appengine.tools.development.Clock;
import com.google.appengine.tools.development.LocalEnvironment;
import com.google.appengine.tools.development.LocalRpcService;
import com.google.appengine.tools.development.LocalServerEnvironment;
import com.google.appengine.tools.development.testing.LocalServiceTestConfig;
import com.google.appengine.tools.development.testing.TestLocalServerEnvironment;
import com.google.apphosting.api.ApiProxy;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.TimeZone;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.logging.Level;
import java.util.logging.Logger;

public class LocalServiceTestHelper {
    private static final String APPS_NAMESPACE_KEY = NamespaceManager.class.getName() + ".appsNamespace";
    private static ApiProxyLocal apiProxyLocal;
    static final String DEFAULT_APP_ID = "test";
    static final String DEFAULT_VERSION_ID = "1.0";
    private final Logger logger = Logger.getLogger(this.getClass().getName());
    private final List<LocalServiceTestConfig> configs;
    private String envAppId = "test";
    private String envVersionId = "1.0";
    private String envEmail;
    private boolean envIsLoggedIn;
    private boolean envIsAdmin;
    private String envAuthDomain;
    private RequestMillisTimer timer = RequestMillisTimer.DEFAULT;
    private ConcurrentMap<String, Object> envAttributes = new ConcurrentHashMap<String, Object>();
    private Clock clock;
    private boolean enforceApiDeadlines = false;
    private boolean simulateProdLatencies = false;
    private TimeZone timeZone = TimeZone.getTimeZone("UTC");
    private TimeZone originalDefaultTimeZone;

    public LocalServiceTestHelper(LocalServiceTestConfig ... configs) {
        this.configs = Arrays.asList(configs);
    }

    public LocalServiceTestHelper setEnvAppId(String envAppId) {
        this.envAppId = envAppId;
        return this;
    }

    public LocalServiceTestHelper setEnvVersionId(String envVersionId) {
        this.envVersionId = envVersionId;
        return this;
    }

    public LocalServiceTestHelper setEnvEmail(String envEmail) {
        this.envEmail = envEmail;
        return this;
    }

    public LocalServiceTestHelper setEnvIsLoggedIn(boolean envIsLoggedIn) {
        this.envIsLoggedIn = envIsLoggedIn;
        return this;
    }

    public LocalServiceTestHelper setEnvIsAdmin(boolean envIsAdmin) {
        this.envIsAdmin = envIsAdmin;
        return this;
    }

    public LocalServiceTestHelper setEnvAuthDomain(String envAuthDomain) {
        this.envAuthDomain = envAuthDomain;
        return this;
    }

    public LocalServiceTestHelper setRemainingMillisTimer(RequestMillisTimer timer) {
        this.timer = timer;
        return this;
    }

    public LocalServiceTestHelper setEnvRequestNamespace(String envRequestNamespace) {
        this.envAttributes.put(APPS_NAMESPACE_KEY, envRequestNamespace);
        return this;
    }

    public LocalServiceTestHelper setEnvAttributes(Map<String, Object> envAttributes) {
        this.envAttributes = new ConcurrentHashMap<String, Object>(envAttributes);
        return this;
    }

    public LocalServiceTestHelper setClock(Clock clock) {
        this.clock = clock;
        return this;
    }

    public LocalServiceTestHelper setEnforceApiDeadlines(boolean val) {
        this.enforceApiDeadlines = val;
        return this;
    }

    public LocalServiceTestHelper setSimulateProdLatencies(boolean val) {
        this.simulateProdLatencies = val;
        return this;
    }

    public LocalServiceTestHelper setTimeZone(TimeZone timeZone) {
        this.timeZone = timeZone;
        return this;
    }

    public final LocalServiceTestHelper setUp() {
        this.originalDefaultTimeZone = TimeZone.getDefault();
        TimeZone.setDefault(this.timeZone);
        ApiProxy.setEnvironmentForCurrentThread(this.newEnvironment());
        apiProxyLocal = new ApiProxyLocalFactory().create(this.newLocalServerEnvironment());
        if (this.clock != null) {
            apiProxyLocal.setClock(this.clock);
        }
        ApiProxy.setDelegate(apiProxyLocal);
        for (LocalServiceTestConfig config : this.configs) {
            config.setUp();
        }
        return this;
    }

    protected ApiProxy.Environment newEnvironment() {
        LocalEnvironment env = new LocalEnvironment(this.envAppId, this.envVersionId){

            @Override
            public String getEmail() {
                return LocalServiceTestHelper.this.envEmail;
            }

            @Override
            public boolean isLoggedIn() {
                return LocalServiceTestHelper.this.envIsLoggedIn;
            }

            @Override
            public boolean isAdmin() {
                return LocalServiceTestHelper.this.envIsAdmin;
            }

            @Override
            public String getAuthDomain() {
                return LocalServiceTestHelper.this.envAuthDomain;
            }

            @Override
            public long getRemainingMillis() {
                return LocalServiceTestHelper.this.timer.getRemainingMillis();
            }
        };
        env.getAttributes().putAll(this.envAttributes);
        return env;
    }

    static ApiProxy.Environment copyEnvironment(ApiProxy.Environment copyFrom) {
        return new TestEnvironment(copyFrom);
    }

    static ApiProxy.Environment newDefaultTestEnvironment() {
        return new TestEnvironment();
    }

    protected LocalServerEnvironment newLocalServerEnvironment() {
        return new TestLocalServerEnvironment(this.enforceApiDeadlines, this.simulateProdLatencies);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void tearDown() {
        try {
            RuntimeException firstException = null;
            for (LocalServiceTestConfig config : this.configs) {
                try {
                    config.tearDown();
                }
                catch (RuntimeException rte) {
                    if (firstException == null) {
                        firstException = rte;
                        continue;
                    }
                    this.logger.log(Level.SEVERE, "Received exception tearing down config of type " + config.getClass().getName(), rte);
                }
            }
            if (firstException != null) {
                throw firstException;
            }
            LocalServiceTestHelper.endRequest();
            ApiProxy.setDelegate(null);
            ApiProxy.setEnvironmentForCurrentThread(null);
            apiProxyLocal = null;
        }
        finally {
            TimeZone.setDefault(this.originalDefaultTimeZone);
        }
    }

    public static void endRequest() {
        ((LocalEnvironment)ApiProxy.getCurrentEnvironment()).callRequestEndListeners();
    }

    public static ApiProxyLocal getApiProxyLocal() {
        return apiProxyLocal;
    }

    public static LocalRpcService getLocalService(String serviceName) {
        return LocalServiceTestHelper.getApiProxyLocal().getService(serviceName);
    }

    private static class TestEnvironment
    extends LocalEnvironment {
        private String email;
        private boolean isLoggedIn;
        private boolean isAdmin;
        private String authDomain;

        private TestEnvironment() {
            super(LocalServiceTestHelper.DEFAULT_APP_ID, LocalServiceTestHelper.DEFAULT_VERSION_ID);
        }

        private TestEnvironment(String appId, String majorVersionId, String email, boolean isLoggedIn, boolean isAdmin, String authDomain, Map<String, Object> attributes) {
            super(appId, majorVersionId);
            this.email = email;
            this.isLoggedIn = isLoggedIn;
            this.isAdmin = isAdmin;
            this.authDomain = authDomain;
            this.attributes.putAll(attributes);
        }

        public TestEnvironment(ApiProxy.Environment copyFrom) {
            this(copyFrom.getAppId(), copyFrom.getVersionId(), copyFrom.getEmail(), copyFrom.isLoggedIn(), copyFrom.isAdmin(), copyFrom.getAuthDomain(), copyFrom.getAttributes());
        }

        @Override
        public String getEmail() {
            return this.email;
        }

        @Override
        public boolean isLoggedIn() {
            return this.isLoggedIn;
        }

        @Override
        public boolean isAdmin() {
            return this.isAdmin;
        }

        @Override
        public String getAuthDomain() {
            return this.authDomain;
        }
    }

    public static interface RequestMillisTimer {
        public static final RequestMillisTimer DEFAULT = new RequestMillisTimer(){

            @Override
            public long getRemainingMillis() {
                return Long.MAX_VALUE;
            }
        };

        public long getRemainingMillis();
    }
}

