/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.tools.development.testing;

import com.google.appengine.tools.development.DevAppServer;
import com.google.appengine.tools.development.testing.DevAppServerTest;
import com.google.appengine.tools.development.testing.DevAppServerTestConfig;
import com.google.appengine.tools.development.testing.DevAppServerTestHelper;
import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.junit.runners.BlockJUnit4ClassRunner;
import org.junit.runners.model.InitializationError;
import org.junit.runners.model.Statement;

public class DevAppServerTestRunner
extends BlockJUnit4ClassRunner {
    public DevAppServerTestRunner(Class<?> klass) throws InitializationError {
        super(DevAppServerTestRunner.startServerAndIsolateClass(klass));
    }

    private static Class<?> startServerAndIsolateClass(Class<?> klass) throws InitializationError {
        DevAppServerTest testAnno = klass.getAnnotation(DevAppServerTest.class);
        if (testAnno == null) {
            throw new InitializationError(String.format("Test uses %s but is not also annotated with %s.", DevAppServerTestRunner.class.getSimpleName(), DevAppServerTest.class.getSimpleName()));
        }
        try {
            DevAppServerTestConfig config = testAnno.value().newInstance();
            DevAppServer devServer = DevAppServerTestHelper.startServer(config);
            return devServer.getAppContext().getClassLoader().loadClass(klass.getName());
        }
        catch (InstantiationException e) {
            throw new InitializationError((Throwable)e);
        }
        catch (IllegalAccessException e) {
            throw new InitializationError((Throwable)e);
        }
        catch (ClassNotFoundException e) {
            throw new InitializationError((Throwable)e);
        }
    }

    protected void collectInitializationErrors(List<Throwable> errors) {
        try {
            this.rewriteAnnotationMap("fMethodsForAnnotations");
            this.rewriteAnnotationMap("fFieldsForAnnotations");
            super.collectInitializationErrors(errors);
        }
        catch (InitializationError initializationError) {
            errors.add(initializationError);
        }
    }

    private void rewriteAnnotationMap(String mapFieldName) throws InitializationError {
        try {
            Field annotationMapField = this.getTestClass().getClass().getDeclaredField(mapFieldName);
            annotationMapField.setAccessible(true);
            Map annotationMap = (Map)annotationMapField.get(this.getTestClass());
            HashMap copy = new HashMap(annotationMap);
            ClassLoader junitClassLoader = ((Object)((Object)this)).getClass().getClassLoader();
            for (Map.Entry entry : copy.entrySet()) {
                annotationMap.put(junitClassLoader.loadClass(((Class)entry.getKey()).getName()), entry.getValue());
            }
        }
        catch (NoSuchFieldException e) {
            throw new InitializationError((Throwable)e);
        }
        catch (IllegalAccessException e) {
            throw new InitializationError((Throwable)e);
        }
        catch (ClassNotFoundException e) {
            throw new InitializationError((Throwable)e);
        }
    }

    protected Statement withAfterClasses(Statement statement) {
        final Statement statementWithAfter = super.withAfterClasses(statement);
        return new Statement(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void evaluate() throws Throwable {
                Throwable exception = null;
                try {
                    statementWithAfter.evaluate();
                }
                catch (Throwable e) {
                    exception = e;
                }
                finally {
                    block13: {
                        try {
                            DevAppServerTestHelper.stopServer();
                        }
                        catch (Throwable e) {
                            if (exception != null) break block13;
                            exception = e;
                        }
                    }
                }
                if (exception != null) {
                    throw exception;
                }
            }
        };
    }
}

