/****************************************************************************
    BSch3V schematic capture
    Copyright (C) 1997-2005 H.Okada

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
*****************************************************************************/

/****************************************************************************
** XBSch}ʗvfC[WIuWFNg
****************************************************************************/
#ifndef XBSCHIMAGEOBJ_H
#define XBSCHIMAGEOBJ_H

#include "xbsch.h"
#include "xbschobj.h"

class SImageData;

#define IMAGEOBJ_MIN_MAGNIFICATION  5
#define IMAGEOBJ_MAX_MAGNIFICATION 200


class SXBSchImageObj :	public SXBSchObj
{
public:
	SXBSchImageObj(void);
	virtual ~SXBSchImageObj(void);

	bool readCe3(SReadCE3&,const SPoint* ,SXBSchDoc* );
	bool writeCe3(SWriteCE3& ,const SPoint* );


protected:
	SImageData*	m_pImageData;
	int m_drawMagnification;

protected:
	void DeleteImageData();


public:
	int		ImageWidth();
	int		ImageHeight();
	int		DrawMagnification(){return m_drawMagnification;}
	void	SetDrawMagnification(int n);
	const SImageData* ImageData(){return m_pImageData;}

	bool LoadDIB(const char* fname);
	

public:
	//ID̎擾
	unsigned id(){return ID_IMAGEOBJECT;}
	unsigned objectFilterValue(){return OBJMASK_IMAGE;} 
	//s
	SXBSchObj* duplicate();

	//W̐ݒ  m_p2ւ̐ݒ𖳌ɂĂ
	void setX2(int){}
	void setY2(int){}
	void setP2(const SPoint&){}
	//E]s
	void mirrorH(){}	//Ȃ
	//]s
	void rotate(){}		//Ȃ

	//L͈͂Ԃ
	SRect area();
	SRect rotateRect();


	//_w肵đIdvxԂ
	int qSelectWeight(const SPoint& p);
	//͈͂w肵đIs
	unsigned testSelection(const SRect& rc);
	//͈͂IăhbOIs
	unsigned testSelectionForDrag(const SRect& rc);
	//`悪KvǂԂ
	bool qRedraw(const SRect& rc);

	//PƑÎƂɃ~[\ǂԂ
	bool canMirrorSingleSelected() {return false;}
	//PƑÎƂɉ]\ǂԂ
	bool canRotateSingleSelected() {return false;}	
	//Agr[g̕ύX\ȏꍇtrueԂB
	bool canAttribute(){return true;}

};
#endif
