/****************************************************************************
    BSch3V schematic capture
    Copyright (C) 1997-2005 H.Okada

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
*****************************************************************************/

#ifndef COMPLIB_H
#define COMPLIB_H

#include "coord.h"

#include "SPtnObj.h"
#include "SPtnObjArc.h"
#include "SPtnObjCircle.h"
#include "SPtnObjLine.h"
#include "SPtnObjPolygon.h"
#include "SPtnObjText.h"


class SReadCE3;
class SWriteCE3;

#ifdef _BSCH
	extern bool g_notSaveBitPtn;
#endif

#define PIN_LENGTH 10


////////////////////////////////////////////////////////////////////
//iCuɊ֌W`


enum PIN_TYPE
{
	PIN_TYPE_NOMAL		=0x00,
	PIN_TYPE_SMALL		=0x01,
	PIN_TYPE_ZLENG		=0x02,
	PIN_TYPE_CLOCK		=0x04,
	PIN_TYPE_NEGATIVE	=0x08,
	PIN_TYPE_NUMHIDE	=0x10
};

enum PIN_LOC
{
	PIN_LOC_L			=0x0,
	PIN_LOC_T			=0x1,
	PIN_LOC_R			=0x2,
	PIN_LOC_B			=0x3
};
/*
enum VECTPTN
{
	VECTPTN_L			=1,
	VECTPTN_C			=2,
	VECTPTN_PG			=3,
	VECTPTN_AR			=4
};
*/



typedef SPtnObj* PSPtnObj;
typedef list<SPtnObj*> SPtnObjList;
typedef list<SPtnObj*>::iterator SPtnObjListIterator;

//LB3Cu̓ǂݍ݂Ŏgp^[NX
class SPtn
{
protected:
	unsigned char* readBmp(SReadCE3& rce3);//,int x,int y,int nBuffSize);
	//bool readLine(SReadCE3& rce3,int* vBuff,int vBuffCount,int* count);
	//bool readCircle(SReadCE3& rce3,int* vBuff,int vBuffCount,int* count);
	//bool readCircleFill(SReadCE3& rce3,int* vBuff,int vBuffCount,int* count);
	//bool readArc(SReadCE3& rce3,int* vBuff,int vBuffCount,int* count);
	//bool readPolygon(SReadCE3& rce3,int* vBuff,int vBuffCount,int* count);

	//bool writeLine(SWriteCE3& wce3,int* buff,int* count);
	//bool writeCircle(SWriteCE3& wce3,int* buff,int* count);
	//bool writeCircleFill(SWriteCE3& wce3,int* buff,int* count);
	//bool writeArc(SWriteCE3& wce3,int* buff,int* count);
	//bool writePolygon(SWriteCE3& wce3,int* buff,int* count);


public:
	char*			m_pszName;		//p^[
	SSize			m_size;			//TCY
	int				m_nBuffsize;	//obt@̃TCY
	PSPtnObj*		m_ppvPtn;		//xNgp^[IuWFNg̃|C^z
	int				m_vPtnCount;
	unsigned char*	m_pBuff;		//obt@ւ̃|C^
//	int*			m_pvBuff;		//xNg`ւ̃|C^
//	int				m_nvBuffsize;	//xNg`̃obt@̃TCY

	SPtn(){							//RXgN^
		m_pszName=NULL;
		m_nBuffsize=0;
		m_pBuff=NULL;
//		m_nvBuffsize=0;
//		m_pvBuff=NULL;
		m_size=SSize(0,0);
		m_vPtnCount=0;
		m_ppvPtn=NULL;
	}

	SPtn(const SPtn&);				//Rs[RXgN^
	SPtn& operator=(const SPtn&);	//Zq	

	virtual ~SPtn();				//fXgN^
	bool readCe3(SReadCE3& rce3);
	bool writeCe3(SWriteCE3& wce3,const char* pszName);
	void setSize(const SSize& sizePixel);
};



////////////////////////////////////////////////////////////////////
//sNX̒`
class SPin
{
protected:
	int			m_nBlock;	//m_nBlock̐sԍzǗĂ
	char**		m_ppszNum;	//sԍzւ̃|C^
	char*		m_pszName;	//sւ̃|C^
	int			m_nType;	//s̃^Cv
	int			m_nLTRB;	//ʒu LTRB
	int			m_nOffset;	//ʒu ItZbg
	unsigned	m_flags;	//t@CɕۑȂ쎞̃tO

	enum{
		FLAGS_NC = 0x0001
	};

protected:
	void deleteBuff();

public:
	SPin();					//RXgN^
	~SPin();
	SPin(const SPin&);				//Rs[RXgN^
	SPin& operator=(const SPin&);	//Zq

	
	void setBlock(int  nBlock);	//ubNZbgB
	void setPinName(const char* name);				//sZbgB
	void setPinNum(int nBlock,const char* name);	//sԍZbgB
	void setType(int type){ m_nType=type;}
	void setLtrb(int ltrb){ m_nLTRB=ltrb;}
	void setOffset(int offset){m_nOffset=offset;}
	const char* pinName() const {return m_pszName;}
	const char* pinNum(int nBlock) const;
	int type() const {return m_nType;}
	int ltrb() const {return m_nLTRB;}
	int offset() const {return m_nOffset;}
	int block() const { return m_nBlock;}

	bool nc() const { return m_flags &  FLAGS_NC;}
	void set_nc(bool itisNC);

	bool readCe3(SReadCE3& rce3,int block);
	bool writeCe3(SWriteCE3& rce3);
};

typedef SPin* PSPin;

typedef list<SPin*> SPinList;
typedef list<SPin*>::iterator SPinListIterator;


////////////////////////////////////////////////////////////////////
//iNX̒`
class SCompInfo
{
protected:
	void deleteBuff();

public:
	char*	m_pszRef;	//ftHgiԍ
	SSize	m_size;		//ĩTCY
	int		m_nBlock;	//pbP[W̃ubN
	SPtn*	m_pPtn;		//LB3ǂݍ񂾃p^[ւ̃|C^
	int		m_nPinCount;//s
	PSPin*	m_ppPin;	//LB3ǂݍ񂾃sNX̔zւ̃|C^
	string	m_note;		//m[g 2005/04/30
	string	m_mfr;		//ҋL 2009/02/01
	string	m_mfrpn;	//Ҍ^L 2009/02/01
	string	m_pkg;		//pbP[WL 2009/02/01

	SCompInfo(){		//RXgN^
		m_pszRef	=NULL;
		m_nBlock	=1;
		m_pPtn		=NULL;
		m_nPinCount	=0;
		m_ppPin		=NULL;
		m_note		="";
		m_mfr		="";
		m_mfrpn		="";
		m_pkg		="";
	}
	~SCompInfo();			//fXgN^

	SCompInfo(const SCompInfo&);			//Rs[RXgN^
	SCompInfo& operator=(const SCompInfo&);	//Zq

	bool readCe3(SReadCE3& rce3,string& name,string& ptnname);	//t@C̓ǂݍ
	bool writeCe3(SWriteCE3& wce3,const char* pszName);

	void setRef(const char* ref);		//ftHgiԍ̐ݒ
	void setSize(const SSize& size,bool createPtn);	//TCY̐ݒ p^[Lꍇ̓p^[̃TCYύX
	void setUsePattern(bool usepattern);
	void setBlock(int block);
	void addPin(SPin* ppin);
	void removePin(int ltrb,int offset,bool move);
	void insertNullPin(int ltrb,int offset);
	SPin* pinInfo(int ltrb,int offset);	//w肵ʒũs𓾂
};

////////////////////////////////////////////////////////////////////
//iCfbNXNX̒`
class SCompIndex
{
	char*				m_lpszName;	//i
public:
	SCompInfo*			m_pCompInfo;//Ή镔iNXւ̃|C^

	SCompIndex(){			//RXgN^
		m_lpszName	=NULL;
		m_pCompInfo =NULL;
	}
	~SCompIndex(){			//fXgN^
		delete[]m_lpszName;
	}
	void setName(const char* name);
	void setCompInfo(SCompInfo* pcinfo){m_pCompInfo = pcinfo;}

	SCompInfo* compInfo() const{return m_pCompInfo;}
	const char*	name() const{return m_lpszName;}			//i𓾂
	const char* number() const;			//iԍ𓾂

	const char* Mfr() const;			//҂𓾂		20090203
	const char* MfrPn() const;			//Ҍ^𓾂		20090203
	const char* Pkg() const;			//pbP[W𓾂		20090203

	SSize size() const;					//TCY𓾂
	SSize sizePlace(int dir) const;		//zu̐}ʏ̃TCY𓾂
	int	  block() const;				//pbP[W̃ubN𓾂
	SPtn*	pattern() const;			//p^[ւ̃|C^𓾂
	int	pinCount() const;				//s̐𓾂
	SPin* pin(int index) const;			//s̏𓾂
	//s̏𓾂
	//̏񂩂As̈ʒu(LTRBƁA_̃ItZbg)Ԃ
	SPin* pin(int index,int dir,int& nLtrb,SPoint& ptLoc) const;

};



typedef SCompIndex* PSCompIndex;

typedef list<SPtn*> SPtnList;
typedef list<SPtn*>::iterator SPtnListIterator;

typedef list<SCompInfo*> SCompInfoList;
typedef list<SCompInfo*>::iterator SCompInfoListIterator;

typedef list<SCompIndex*> SCompIndexList;
typedef list<SCompIndex*>::iterator SCompIndexListIterator;


////////////////////////////////////////////////////////////////////
//iCuNX
class SCompLib
{
public:
	char*			m_lpszLibraryName;		//Cu
	string			m_prop_string;
	SPtnList		m_listPtn;				//ǂݍ񂾃p^[̃Xg
	SCompInfoList	m_listCompInfo;			//ǂݍݍ񂾕iNX̃Xg
	SCompIndexList	m_listCompIndex;		//ǂݍݍ񂾕iCfbNX̃Xg
	PSCompIndex*	m_ppCompIndex;			//ǂݍݍ񂾕iCfbNX̃|C^z
	int				m_aux1;
	int				m_aux2;


public:
	SCompLib(){										//RXgN^
		m_lpszLibraryName=NULL;
		m_ppCompIndex=NULL;
		m_prop_string="";
		m_aux1 = 0;
		m_aux2 = 0;
		//m_nCount=0;
	}
	~SCompLib();										//fXgN^
	bool ReadLb3(SReadCE3& rce3,bool singleComponent = false);//LB3Cu̓ǂݍ
	void deleteContent();//e̔j

	bool writeLibraryFile(const char* lpszFileName);	//t@C
	bool readLibraryFile(const char* lpszFileName);		//t@Cǂݍ

	void setLibraryName(const char* name);				//Cu̐ݒ
	const char* libraryName() const ;					//Cu𓾂
	int count() const{return m_listCompIndex.size();}	//Ǘi𓾂
	SCompIndex* compIndex(int nIndexNum) const;			//nԖڂ̕ĩCfbNX𓾂

	static bool WriteAlias(SWriteCE3& wce3,const char*  alias,const char*  name);
	string uniqueName(const string& name);	//̕iƏdȂȂO

private:
	bool ReadLb3Ptn(SReadCE3& rce3);//p^[̓ǂݍ
	bool ReadLb3Comp(SReadCE3& rce3);
	bool ReadLb3Alias(SReadCE3& rce3);

	void clearPtnList();	//o[ϐp^[Xg̃NA


	bool isUniqueName(const string& name);	//̕iƏdĂȂǂ

	//bool WriteLb3Pin(SWriteCE3& wce3,const SPin& pin);							//s̏
	//bool WriteLb3Ptn(SWriteCE3& wce3,const SPtn& ptn,const char*  name);			//p^[̏
	//bool WriteLb3Comp(SWriteCE3& wce3,const SCompInfo& compinfo,SWriteCE3& wce3);	//ȉ
	
};


#endif
