#ifndef _MACRO_H_
#define _MACRO_H_

typedef unsigned char 	  u8;
typedef unsigned short 	  u16;
typedef unsigned char 	  uint8_t;

//extern u8 status;


#define	LOW				0
#define	HIGH			1


#define PCDDR	DDRC
#define PCSEL	PINC
#define PCINTIE


#define PBDDR	DDRB




enum {
	STARTUP=0,
	CHK_INPUT,
	DATA_SEND,
	CHK_DATA_SEND,
	POWER_DONW
};








typedef struct _tx_data_
{
    u8  serial[6];
    u8  data01;
	u8	data02;
	u8	data03;
	u8	data04;

}cc1101_tx_data;




typedef struct 
{ 
  unsigned int bit0:1; 
  unsigned int bit1:1; 
  unsigned int bit2:1; 
  unsigned int bit3:1; 
  unsigned int bit4:1; 
  unsigned int bit5:1; 
  unsigned int bit6:1; 
  unsigned int bit7:1; 
} _io_reg; 

#define REGISTER_BIT(rg,bt) ((volatile _io_reg*)&rg)->bit##bt 

#endif
