/****************************************************************************
    BSch3V schematic capture
    Copyright (C) 1997-2005 H.Okada

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
*****************************************************************************/
#include "stdafx.h"
#include "extensionmenu.h"

CExtensionMenu::CExtensionMenu()
{
	m_option[0]=0;
}

void CExtensionMenu::setOption(const char* option)
{
	int n=0;
	while(option[n]&&(n<15)){
		m_option[n]=option[n];
		n++;
	}
	m_option[n]=0;
}

CString CExtensionMenu::formatCmdline(const char* datapath)
{
	CString result="";
	CString path;
	path.Format("\"%s\"",datapath);

	if(m_cmd.IsEmpty()) return result;

	result = m_cmd;
	result.Replace("%f",path);
	return result;
}

BOOL CExtensionMenu::isReload()
{
	int n=0;
	while(m_option[n]){
		if(m_option[n]=='R') return TRUE;
		n++;
	}
	return FALSE;
}

