/****************************************************************************
    BSch3V schematic capture
    Copyright (C) 1997-2005 H.Okada

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
*****************************************************************************/

//////////////////////////////////////////////////////////////
//  Pattern.CPP
//
//   rbgp^[̕`s CPatternNX̓̒`s
//

//p^[rbg}bvobt@ɃRs[
//炩m_sizeSrcAm_pbyteSrcɒlZbgĂ

#include "stdafx.h"
#include "BSch.h"
#include "Pattern.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

CPattern g_Pattern;

void CPattern::Copy()
{
	int srcXbyte=((m_sizeSrc.cx+15)/16)*2;
	int x,y;
	m_sizeBmp=m_sizeSrc;
	const BYTE* pSrc=m_pbyteSrc;
	BYTE* pDst=m_pbyteBuff;
	for(y=0;y<m_sizeSrc.cy;y++){
		for(x=0;x<srcXbyte;x++){
			*pDst++=*pSrc++;
		}
	}
}

//p^[rbg}bvobt@90x]Rs[
//炩m_sizeSrcAm_pbyteSrcɒlZbgĂ
//\[XcXLAfXeBl[VŏドC牡XL
//                 
//                        
//                 
//                    
//
void CPattern::Rot90()
{
	int srcXbyte=((m_sizeSrc.cx+15)/16)*2;
	int dstXbyte=((m_sizeSrc.cy+15)/16)*2;
	int x,y;
	BYTE bitSrc,bitDst;
	m_sizeBmp.cx=m_sizeSrc.cy;
	m_sizeBmp.cy=m_sizeSrc.cx;
	const BYTE* pSrcTop=m_pbyteSrc+srcXbyte*(m_sizeSrc.cy-1);//̃oCgw
	BYTE* pDstTop=m_pbyteBuff;			//̃oCgw
	bitSrc=0x80;
	for(x=0;x<m_sizeSrc.cx;x++){
		const BYTE* pSrc=pSrcTop;
		BYTE* pDst=pDstTop;
		*pDst=0;
		bitDst=0x80;
		for(y=0;y<m_sizeSrc.cy;y++){
			if(*pSrc & bitSrc) *pDst |= bitDst;
			pSrc-=srcXbyte;		//\[X1Ɉړ
			if(bitDst==0x01){	//fXeBl[Ṽ͍rbgɈړ
				bitDst=0x80;	//ׂ̃oCgɈڂƂ
				pDst++;
				*pDst=0;		//ڂ̃oCg
			}else{
				bitDst>>=1;
			}
		}
		//P񂪏I
		if(bitSrc==0x01){		//\[Xׂ̃rbgɈړ
			bitSrc=0x80;
			pSrcTop++;
		}else{
			bitSrc>>=1;
		}
		pDstTop+=dstXbyte;		//fXeBl[V̍sɈړ
	}
}

//p^[rbg}bvobt@180x]Rs[
//炩m_sizeSrcAm_pbyteSrcɒlZbgĂ
//\[XEォ牡XLAfXeBl[V牡XL
//             
//                      
//               
//                
//               
void CPattern::Rot180()
{
	int srcXbyte=((m_sizeSrc.cx+15)/16)*2;
	int x,y;
	BYTE bitSrc,bitDst,bitRight;
	m_sizeBmp=m_sizeSrc;
	
	BYTE* pDstTop=m_pbyteBuff+srcXbyte*(m_sizeSrc.cy-1);//̃oCgw
	const BYTE* pSrcTop=m_pbyteSrc+(m_sizeSrc.cx+7)/8-1;		//ẼoCgw
	bitRight=0x80>>((m_sizeSrc.cx+7) % 8);				//E[̃rbg

	for(y=0;y<m_sizeSrc.cy;y++){
		BYTE* pDst=pDstTop;
		const BYTE* pSrc=pSrcTop;
		*pDst=0;
		bitDst=0x80;
		bitSrc=bitRight;
		for(x=0;x<m_sizeSrc.cx;x++){
			if(*pSrc & bitSrc) *pDst |= bitDst;
			if(bitSrc==0x80){
				pSrc--;
				bitSrc=0x01;
			}else{
				bitSrc<<=1;
			}
			if(bitDst==0x01){
				pDst++;
				*pDst=0;
				bitDst=0x80;
			}else{
				bitDst>>=1;
			}
		}
		pDstTop-=srcXbyte;	//fXeBl[V͂PɈړ
		pSrcTop+=srcXbyte;	//\[X͂PɈړ
	}
}


//p^[rbg}bvobt@270x]Rs[
//炩m_sizeSrcAm_pbyteSrcɒlZbgĂ
//\[XォcXLAfXeBl[V牡XL
//                 
//                        
//                 
//                    
//                 
void CPattern::Rot270()
{
	int srcXbyte=((m_sizeSrc.cx+15)/16)*2;
	int dstXbyte=((m_sizeSrc.cy+15)/16)*2;
	int x,y;
	BYTE bitSrc,bitDst;
	m_sizeBmp.cx=m_sizeSrc.cy;
	m_sizeBmp.cy=m_sizeSrc.cx;
	const BYTE* pSrcTop=m_pbyteSrc;	//̃oCgw
	BYTE* pDstTop=m_pbyteBuff+dstXbyte*(m_sizeSrc.cx-1);//̃oCgw
	bitSrc=0x80;
	for(x=0;x<m_sizeSrc.cx;x++){
		const BYTE* pSrc=pSrcTop;
		BYTE* pDst=pDstTop;
		*pDst=0;
		bitDst=0x80;
		for(y=0;y<m_sizeSrc.cy;y++){
			if(*pSrc & bitSrc) *pDst |= bitDst;
			pSrc+=srcXbyte;		//\[X1񉺂Ɉړ
			if(bitDst==0x01){	//fXeBl[Ṽ͍rbgɈړ
				bitDst=0x80;	//ׂ̃oCgɈڂƂ
				pDst++;
				*pDst=0;		//ڂ̃oCg
			}else{
				bitDst>>=1;
			}
		}
		//P񂪏I
		if(bitSrc==0x01){		//\[Xׂ̃rbgɈړ
			bitSrc=0x80;
			pSrcTop++;
		}else{
			bitSrc>>=1;
		}
		pDstTop-=dstXbyte;		//fXeBl[V̍sɈړ
	}
}


//rbg}bvobt@̏㉺]
void CPattern::Vrev()
{
	BYTE buff[256];						//PC]pobt@
	int nXbyte=((m_sizeBmp.cx+15)/16)*2;//PCoCg
	if(nXbyte>256) return;
	int x,y,l;
	BYTE* p0Top=m_pbyteBuff;			//̃oCgw
	BYTE* p1Top=m_pbyteBuff+nXbyte*(m_sizeBmp.cy-1);//̃oCgw
	BYTE* p0;
	BYTE* p1;

	l=m_sizeBmp.cy/2;
	for(y=0;y<l;y++){
		p0=p0Top;
		for(x=0;x<nXbyte;x++) buff[x]=*p0++;
		p0=p0Top;
		p1=p1Top;
		for(x=0;x<nXbyte;x++) *p0++=*p1++;
		p1=p1Top;
		for(x=0;x<nXbyte;x++) *p1++=buff[x];
		p0Top+=nXbyte;
		p1Top-=nXbyte;
	}
}


//p^[̕`	
//BSchł͕i]ƍE]ŕ\Ă邪Ap^[̏̎Ԃ
//ۂ͉̏]Ə㉺]ōs
//                        m_nRot(]p)
//              (0)        (1)        (2)        (3)
// m_bMirror                               
//                                
//  (FALSE)    
//                                
//                                         
//
//
//                                         
//                                
//  (TRUE )    
//                                
//                                         
//
//     ͂̏㉺]
//     ͂̏㉺]
//     ͂̏㉺]
//     ͂̏㉺]



void CPattern::PutPtn(	
	CDC* pDC,		//o͐foCXReLXg
	int x,int y,	//o͈ʒu
	const BYTE* lpPtn,	//o̓p^[
	int  width,
	int  height,
	COLORREF col,	//o͐F
	UINT nMode/*=DRAW_ON*/,	//`惂[h
	int  nRot/*=0*/,		//]p
	BOOL bMirror/*=FALSE*/,	//E]tO
	int  nVExt/*=1*/,		//\{(View)
	int  nWExt/*=1*/)		//\{(Window)
{
	COLORREF colOldText,colOldBk;
	CSize    sizeOut;
	//TCY̐ݒ
	m_sizeSrc.cx=width;				//\[X̃p^[̂TCY
	m_sizeSrc.cy=height;			//\[X̃p^[̂TCY
	m_pbyteSrc=lpPtn;
	//p^[̏
	if(bMirror) nRot=(nRot+2)&3;
	switch(nRot){
	case 0:Copy();	 break;	//̂܂܃Rs[
	case 1:Rot90();  break;	//90x]Rs[
	case 2:Rot180(); break;	//180x]Rs[
	case 3:Rot270(); break;	//270x]Rs[
	}
	if(bMirror) Vrev();		//㉺]
	CBitmap bitmap;
	bitmap.CreateBitmap(m_sizeBmp.cx,m_sizeBmp.cy,1,1,m_pbyteBuff);
	CDC dcMem;						//foCXReLXgIuWFNg̍쐬

	dcMem.CreateCompatibleDC(pDC);	//pDCƌ݊̂郁foCXReLXg
	dcMem.SelectObject(&bitmap);

	int expandOffset=nVExt/nWExt/2;
	//o͈ʒǔvZ
	x=(x*nVExt)/nWExt-expandOffset;
	y=(y*nVExt)/nWExt-expandOffset;
	
	//o̓TCY̌vZ
	sizeOut.cx=(m_sizeBmp.cx*nVExt)/nWExt;
	sizeOut.cy=(m_sizeBmp.cy*nVExt)/nWExt;
	//
	if(nVExt<nWExt){ sizeOut.cx++; sizeOut.cy++; }

//	pDC->SetStretchBltMode(WHITEONBLACK);
	if(nMode&DRAW_OFF) col=0;
//	if(nMode&DRAW_ON || nMode&DRAW_TEMP){
	if(1){
		CBrush brush;
		brush.CreateSolidBrush(col);
		CBrush* pOldBrush = pDC->SelectObject(&brush);
		pDC->SetStretchBltMode(WHITEONBLACK);
		colOldBk	= pDC->SetBkColor(0xFFFFFF);	//2005/03/29 BkColor̐ݒ	
		colOldText	= pDC->SetTextColor(0);			//2005/03/29 TextColor̐ݒ
  		pDC->StretchBlt(       x,y,sizeOut.cx,  sizeOut.cy,
			            &dcMem,0,0,m_sizeBmp.cx,m_sizeBmp.cy,
						0x00E20746);
				// [P]   1   1   1   1   0   0   0   0
				// [S]   1   1   0   0   1   1   0   0
				// [D]   1   0   1   0   1   0   1   0
				// -------------------------------------
				//       1   1   1   0   0   0   1   0  ----> 0xE2
		pDC->SelectObject(pOldBrush);
		pDC->SetBkColor(colOldBk);			//2005/03/29 BkColor̕A
		pDC->SetTextColor(colOldText);		//2005/03/29 TextColor̕A



//		colOldBk	= pDC->SetBkColor(col);	//BkColor̐ݒiۂɂ̓rbg}bv̐F)
//		colOldText	= pDC->SetTextColor(0);	//TextColor̐ݒ
//
//		pDC->SetStretchBltMode(WHITEONBLACK);
//  
//		pDC->StretchBlt(       x,y,sizeOut.cx,  sizeOut.cy,
//			            &dcMem,0,0,m_sizeBmp.cx,m_sizeBmp.cy,
//						SRCPAINT);
//				// [P]   1   1   1   1   0   0   0   0
//				// [S]   1   1   0   0   1   1   0   0
//				// [D]   1   0   1   0   1   0   1   0
//				// -------------------------------------
//				//       1   1   1   0   1   1   1   0  ----> 0xEE
//		pDC->SetBkColor(colOldBk);			//BkColor̕A
//		pDC->SetTextColor(colOldText);		//TextColor̕A
	}else if(nMode&DRAW_OFF){
		colOldBk	= pDC->SetBkColor(RGB(255,255,255));//BkColor̐ݒiۂɂ͕̐F)
		colOldText	= pDC->SetTextColor(0);	//TextColor̐ݒ


		dcMem.BitBlt(0,0,m_sizeBmp.cx,m_sizeBmp.cy,&dcMem,0,0,DSTINVERT);
		int oldbkmode = pDC->SetBkMode(TRANSPARENT);
		pDC->SetStretchBltMode(BLACKONWHITE);

		pDC->StretchBlt(x,y,sizeOut.cx,  sizeOut.cy,
		            &dcMem,0,0,m_sizeBmp.cx,m_sizeBmp.cy,
						SRCAND);
		pDC->SetBkMode(oldbkmode);

		pDC->SetBkColor(colOldBk);			//BkColor̕A
		pDC->SetTextColor(colOldText);		//TextColor̕A

	}else{
		TRACE("\nsȕ`惂[h(CPattern::PutPtn())");
	}
}


