// SetAddIn.cpp : t@C
//

#include "stdafx.h"
#include "nlist.h"
#include "SetAddIn.h"
#include "SAddInFiles.h"

// CSetAddIn _CAO

IMPLEMENT_DYNAMIC(CSetAddIn, CDialog)

CSetAddIn::CSetAddIn(CWnd* pParent /*=NULL*/)
	: CDialog(CSetAddIn::IDD, pParent)
{
	m_nAddinCount = 0;
}

CSetAddIn::~CSetAddIn()
{
}

void CSetAddIn::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
}

void CSetAddIn::SetListboxWidth()
{
	CListBox* pLB=(CListBox*)GetDlgItem(IDC_LIST_FILES);
	CString str;
	CDC* pDC;
	CSize textsize;
	int maxwidth=0;
	int i,n;
	pDC = pLB->GetDC();

	n = pLB->GetCount();
	for(i=0;i<n;i++){
		pLB->GetText(i,str);
		textsize = pDC->GetTextExtent(str);
		if(textsize.cx>maxwidth) maxwidth = textsize.cx;
	}
	pLB->SetHorizontalExtent(maxwidth);
	pLB->ReleaseDC(pDC);
}

//_CAO\{^̃Cl[u
void CSetAddIn::EnableButton(UINT id,BOOL bEnable)
{
	CButton*  pBtn=(CButton*)GetDlgItem(id);
	// fBZ[u悤Ƃ{^ɃtH[JXꍇ
	// nj{^ɃtH[JXZbg
	if(!bEnable){
		CWnd* pWnd=GetFocus();
		if(pWnd==pBtn){
			CButton* pDefaultBtn=(CButton*)GetDlgItem(IDOK);
			pDefaultBtn->SetFocus();
		}
	}
	pBtn->EnableWindow(bEnable);
}


BEGIN_MESSAGE_MAP(CSetAddIn, CDialog)
	ON_BN_CLICKED(IDC_BUTTON_ADD, &CSetAddIn::OnBnClickedButtonAdd)
	ON_BN_CLICKED(IDC_BUTTON_REMOVE, &CSetAddIn::OnBnClickedButtonRemove)
	ON_BN_CLICKED(IDC_BUTTON_DOWN, &CSetAddIn::OnBnClickedButtonDown)
	ON_BN_CLICKED(IDC_BUTTON_UP, &CSetAddIn::OnBnClickedButtonUp)
	ON_LBN_SELCHANGE(IDC_LIST_FILES, &CSetAddIn::OnLbnSelchangeListFiles)
END_MESSAGE_MAP()


// CSetAddIn bZ[W nh

BOOL CSetAddIn::OnInitDialog()
{
	CDialog::OnInitDialog();

	
	// TODO: ̈ʒuɏ̕⑫ǉĂ
	CListBox* pLB=(CListBox*)GetDlgItem(IDC_LIST_FILES);
	CString str;
	CSize textsize;
	char szEntry[32];
	int i;


	//WXgɓo^ꂽCut@CXg{bNX֐ݒ
	for(i=0;i<MAX_ADDIN;i++){
		wsprintf(szEntry,"ADDIN%d",i);			//Gg̍쐬
		str=AfxGetApp()->GetProfileString("ADDINLIB",szEntry);
		if(str.IsEmpty()) break;		//iAhCt@CjlłȂbreak
		pLB->InsertString(-1,str);		//Xg{bNX̍Ōɒǉ
	}
	SetListboxWidth();


	m_nAddinCount = pLB->GetCount();			//o^̐ݒ
	EnableButton(IDC_BUTTON_ADD,m_nAddinCount<MAX_ADDIN);	//܂o^łȂΒǉ\Ȃ悤ɁuADDvCl[u
		
	EnableButton(IDC_BUTTON_DOWN,FALSE);		//uֈړv{^̓fBZ[u
	if(m_nAddinCount!=0){						//o^OłȂ
		pLB->SetCurSel(m_nAddinCount-1);		//Xg{bNẌԉ̍sɃJ[\ݒ
	}else{										//o^OȂ
		EnableButton(IDC_BUTTON_UP,  FALSE);	//uֈړvu폜vfBZ[u
		EnableButton(IDC_BUTTON_REMOVE, FALSE);
	}

	return TRUE;  // return TRUE unless you set the focus to a control
	// O : OCX vpeB y[W͕K FALSE Ԃ܂B
}

void CSetAddIn::OnBnClickedButtonAdd()
{
	// TODO: ɃRg[ʒmnh R[hǉ܂B
		int nResult;
		if(m_nAddinCount>=MAX_ADDIN) return;	//łɓo^ȂȂɂȂ

	char szFileNameBuffer[_MAX_PATH *MAX_ADDIN+256];
	strcpy(szFileNameBuffer,"*.DLL");

	CFileDialog dlg(TRUE,				//I[v_CAO
					"dll",				//gqtȂꍇ̃ftHg
					NULL,			//t@C
					OFN_HIDEREADONLY|OFN_FILEMUSTEXIST|OFN_ALLOWMULTISELECT,
					"Add in (*.dll)|*.DLL||",	//tB^
					this);				//eEChE
	
	CString strCaption;
	strCaption.LoadString(IDS_ADD_ADDIN);//_CAO{bNX̃LvV\[X烍[h
	dlg.m_ofn.lpstrTitle=strCaption;		//t@C_CAONXɃLvV̐ݒ
	dlg.m_ofn.lpstrFile = szFileNameBuffer;	//t@Ci[obt@ݒ肷B
	dlg.m_ofn.nMaxFile = _MAX_PATH *MAX_ADDIN+256;		//t@Ci[obt@̃TCYݒ肷B
	
	nResult=dlg.DoModal();			//t@C_CAO̎s
	if(nResult==IDOK){		//IȂc
//		CString rString=CString(dlg.m_ofn.lpstrFile);		//t@C_CAOt@C擾
		CListBox* pLB=(CListBox*)GetDlgItem(IDC_LIST_FILES);	//Xg{bNX擾āc
		int n;
		CString strPath;
		POSITION pos = dlg.GetStartPosition();
		while(pos){
			strPath = dlg.GetNextPathName(pos);				
			n=pLB->GetCurSel();				//ݑIĂƂɑ}邽߂Ɍݒl擾
			if(n==LB_ERR) n=0;				//ݑIĂ̂Ȃΐ擪ɓ
			pLB->InsertString(n,strPath);	//Xg{bNXւ̃Zbg
			pLB->SetCurSel(n);				//Is̍Đݒ
			m_nAddinCount=pLB->GetCount();		//o[ϐւ̓o^̐ݒ
			if(m_nAddinCount>=MAX_ADDIN) break;
		}
		SetListboxWidth();
		EnableButton(IDC_BUTTON_ADD ,m_nAddinCount<MAX_ADDIN);//uADDv{^̐ݒ
		EnableButton(IDC_BUTTON_DOWN,n<m_nAddinCount-1);		//uցv{^̐ݒ
		EnableButton(IDC_BUTTON_UP  ,n>0);				//uցv{^̐ݒ
		EnableButton(IDC_BUTTON_REMOVE ,TRUE);			//uDELv{^̐ݒ
	}
}

void CSetAddIn::OnBnClickedButtonRemove()
{
	// TODO: ɃRg[ʒmnh R[hǉ܂B
	int n;
	if(m_nAddinCount==0) return;		//o^OȂ牽Ȃ
    CListBox* pLB=(CListBox*)GetDlgItem(IDC_LIST_FILES);
	n=pLB->GetCurSel();			//IĂ̂̔ԍ擾
	if(n==LB_ERR) return;		//IĂ̂ȂΉȂ
	pLB->DeleteString(n); 		//IĂ̂폜
    m_nAddinCount=pLB->GetCount(); 	//o^̐ݒ
	if(n>=m_nAddinCount) n=m_nAddinCount-1;	//폜̂ŉŝ̂Ȃ玟ɑÎ͈
	if(n>=0)pLB->SetCurSel(n);
	SetListboxWidth();
	EnableButton(IDC_BUTTON_ADD, TRUE);
   	EnableButton(IDC_BUTTON_DOWN,n<m_nAddinCount-1 && m_nAddinCount>0);
   	EnableButton(IDC_BUTTON_UP,  n>0);
	EnableButton(IDC_BUTTON_REMOVE, m_nAddinCount>0);
}

void CSetAddIn::OnBnClickedButtonDown()
{
	// TODO: ɃRg[ʒmnh R[hǉ܂B
	CListBox* pLB=(CListBox*)GetDlgItem(IDC_LIST_FILES);
	CString str;
	int n=pLB->GetCurSel();						//IĂʒu̎擾
	if(n==LB_ERR || n>=m_nAddinCount-1) return;	//IĂ̂ȂɍŌ̏ꍇ͉Ȃ
	pLB->GetText(n,str);						//IĂ镶擾āc
	pLB->DeleteString(n);						//			Xg{bNX폜
	n++;										//ԍĂāc
	pLB->InsertString(n,str);					//			ǉāc
	pLB->SetCurSel(n);							//			J[\ݒ肵đIԂɂ
	EnableButton(IDC_BUTTON_DOWN,n<m_nAddinCount-1);		//uցv{^̐ݒ
	EnableButton(IDC_BUTTON_UP  ,n>0);				//uցv{^̐ݒ
}

void CSetAddIn::OnBnClickedButtonUp()
{
	// TODO: ɃRg[ʒmnh R[hǉ܂B
	CListBox* pLB=(CListBox*)GetDlgItem(IDC_LIST_FILES);
	CString str;
	int n=pLB->GetCurSel();			//IĂʒu̎擾
	if(n==LB_ERR || n==0) return;	//IĂ̂Ȃɐ擪̏ꍇ͉Ȃ
	pLB->GetText(n,str);		//IĂ镶擾āc
	pLB->DeleteString(n);			//			Xg{bNX폜
	n--;							//ԍグāc
	pLB->InsertString(n,str);	//			ǉāc
	pLB->SetCurSel(n);				//			J[\ݒ肵đIԂɂ
	EnableButton(IDC_BUTTON_DOWN,n<m_nAddinCount-1);		//uցv{^̐ݒ
	EnableButton(IDC_BUTTON_UP  ,n>0);				//uցv{^̐ݒ
}

void CSetAddIn::OnLbnSelchangeListFiles()
{
	// TODO: ɃRg[ʒmnh R[hǉ܂B
	CListBox* pLB=(CListBox*)GetDlgItem(IDC_LIST_FILES);
	int n=pLB->GetCurSel();									//IĂʒu̎擾
	EnableButton(IDC_BUTTON_DOWN,n<m_nAddinCount-1);		//uցv{^̐ݒ
	EnableButton(IDC_BUTTON_UP  ,n>0);						//uցv{^̐ݒ
}

void CSetAddIn::OnOK()
{
	// TODO: ɓȃR[hǉ邩A͊{NXĂяoĂB
	CListBox* pLB=(CListBox*)GetDlgItem(IDC_LIST_FILES);	//Xg{bNX擾āc
	int count = pLB->GetCount();
	for(int index = 0;index<MAX_ADDIN;index++){
		CString addinPath;
		char szEntry[32];
		wsprintf(szEntry,"ADDIN%d",index);			//Gg̍쐬

		if(index<count){
			pLB->GetText(index,addinPath);
		}else{
			addinPath.Empty();
		}
		AfxGetApp()->WriteProfileString("ADDINLIB",szEntry,addinPath);
	}

	CDialog::OnOK();
}

void CSetAddIn::OnCancel()
{
	// TODO: ɓȃR[hǉ邩A͊{NXĂяoĂB

	CDialog::OnCancel();
}
