// Copyright (C) 2002 H.Okada(suigyodo) All rights reserved.
/****************************************************************************
** XBSch}ʏNX̎
****************************************************************************/
#include "stdafx.h"
#include <stdio.h>
#include <string>
using namespace std;
#include "ce3io.h"

#include "xbschobj.h"
#include "xbschsheetinfo.h"

bool SXBSchSheetInfo::readCe3(SReadCE3& rce3,const SPoint*,SXBSchDoc*)
{
	string str;
	int nParam;
	bool bInitW = false;
	bool bInitH = false;
	while(1){
		if(rce3.ReadRecord(str)==EOF) return false;
		if(str[0] == '-'){
			if((str != "-SHEETINFO") || !bInitW || !bInitH){
				return false;
			}else{
				break;
			}
		}else if(str[0] == '+'){
			str[0]='-';
			if(rce3.SkipTo(str)==EOF) return false;
		}else{
			char cc = str[0];
			switch(cc){
			case 'W':
				if(str[1] != ':') break;
				nParam = atoi(str.substr(2).c_str());
				if(nParam>=500 && nParam <=3000) m_p1.setX(nParam);
				bInitW = true;
				break;
			case 'H':
				if(str[1] != ':') break;
				nParam = atoi(str.substr(2).c_str());
				if(nParam>=400 && nParam <=2000) m_p1.setY(nParam);
				bInitH = true;
				break;
			default:
				break;
			}
		}
	}
	return true;
}
/*
//Xg[̓ǂݍ ` -SHEETINFO
bool SXBSchSheetInfo::readStream(SCsvIStream* pStrm,const SPoint*)
{
	if(!pStrm) return false;
	QString str;
	int nResult;
	int nParam;
	bool bInitW = false;
	bool bInitH = false;
	while(1){
		nResult = pStrm->getRecord(str);
		if(nResult == SCsvIStream::GETRECORD_EOF || nResult == SCsvIStream::GETRECORD_ERROR){
			return false;
		}
		//str = deleteLeftSpace(str);
		if(str[0] == '-'){
			if((str != "-SHEETINFO") || !bInitW || !bInitH){
				return false;
			}else{
				break;
			}
		}else if(str[0] == '+'){
			if(pStrm->skipTo(str.replace(1,1,"-")) != SCsvIStream::GETRECORD_NORMAL)return false;
		}else{
			QChar cc = str[0];
			switch(cc){
			case 'W':
				if(str[1] != ':') break;
				nParam = (str.mid(2)).toInt();
				m_p1.setX(nParam);
				bInitW = true;
				break;
			case 'H':
				if(str[1] != ':') break;
				nParam = (str.mid(2)).toInt();
				m_p1.setX(nParam);
				bInitH = true;
				break;
			default:
				break;
			}
		}
	}
	return true;
}			
*/

bool SXBSchSheetInfo::writeCe3(SWriteCE3& wce3,const SPoint* )
{
	char sz[32];
	wce3.WriteRecord("+SHEETINFO");
	wce3.WriteRecordInt("EL",m_Layer);
	wce3.WriteRecordInt("VL",m_Selection);
	sprintf(sz,"W:%d",m_p1.x());
	wce3.WriteRecord(sz);
	sprintf(sz,"H:%d",m_p1.y());
	wce3.WriteRecord(sz);
	wce3.WriteRecord("-SHEETINFO");
	wce3.WriteEOL();
	return true;
}

/*
//Xg[ւ̏݁@+SHEETINFO ` -SHEETINFO
bool SXBSchSheetInfo::writeStream(SCsvOStream* pStrm,const SPoint*)
{
	if(!pStrm) return false;
	char sz[32];
	pStrm->writeRecord("+SHEETINFO");
	sprintf(sz,"W:%d",m_p1.x());
	pStrm->writeRecord(sz);
	sprintf(sz,"H:%d",m_p1.y());
	pStrm->writeRecord(sz);
	pStrm->writeRecord("-SHEETINFO");
	pStrm->writeEOL();
	return true;
}
*/