/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.widgets;

import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.internal.Converter;
import org.eclipse.swt.internal.gtk.OS;
import org.eclipse.swt.widgets.Dialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;

public class FontDialog
extends Dialog {
    FontData fontData;
    RGB rgb;

    public FontDialog(Shell shell) {
        this(shell, 65536);
    }

    public FontDialog(Shell shell, int n) {
        super(shell, FontDialog.checkStyle(shell, n));
        this.checkSubclass();
    }

    public FontData getFontData() {
        return this.fontData;
    }

    public FontData[] getFontList() {
        if (this.fontData == null) {
            return null;
        }
        FontData[] fontDataArray = new FontData[]{this.fontData};
        return fontDataArray;
    }

    public RGB getRGB() {
        return this.rgb;
    }

    public FontData open() {
        boolean bl;
        int n;
        int n2;
        byte[] byArray = Converter.wcsToMbcs(null, this.title, true);
        Display display = this.parent != null ? this.parent.getDisplay() : Display.getCurrent();
        int n3 = OS.gtk_font_selection_dialog_new(byArray);
        if (this.parent != null) {
            int n4 = this.parent.topHandle();
            OS.gtk_window_set_transient_for(n3, n4);
            n2 = OS.gtk_window_get_icon_list(n4);
            if (n2 != 0) {
                OS.gtk_window_set_icon_list(n3, n2);
                OS.g_list_free(n2);
            }
        }
        OS.gtk_window_set_modal(n3, true);
        if (this.fontData != null) {
            Font font = new Font((Device)display, this.fontData);
            n2 = OS.pango_font_description_to_string(font.handle);
            n = OS.strlen(n2);
            byte[] byArray2 = new byte[n + 1];
            OS.memmove(byArray2, n2, n);
            font.dispose();
            OS.g_free(n2);
            OS.gtk_font_selection_dialog_set_font_name(n3, byArray2);
        }
        display.addIdleProc();
        Dialog dialog = null;
        if (OS.gtk_window_get_modal(n3)) {
            dialog = display.getModalDialog();
            display.setModalDialog(this);
        }
        n2 = 0;
        n = 0;
        if ((this.style & 0x4000000) != 0) {
            n2 = OS.g_signal_lookup(OS.map, OS.GTK_TYPE_WIDGET());
            n = OS.g_signal_add_emission_hook(n2, 0, display.emissionProc, n3, 0);
        }
        int n5 = OS.gtk_dialog_run(n3);
        if ((this.style & 0x4000000) != 0) {
            OS.g_signal_remove_emission_hook(n2, n);
        }
        if (OS.gtk_window_get_modal(n3)) {
            display.setModalDialog(dialog);
        }
        boolean bl2 = bl = n5 == -5;
        if (bl) {
            int n6 = OS.gtk_font_selection_dialog_get_font_name(n3);
            int n7 = OS.strlen(n6);
            byte[] byArray3 = new byte[n7 + 1];
            OS.memmove(byArray3, n6, n7);
            OS.g_free(n6);
            int n8 = OS.pango_font_description_from_string(byArray3);
            Font font = Font.gtk_new(display, n8);
            this.fontData = font.getFontData()[0];
            OS.pango_font_description_free(n8);
        }
        display.removeIdleProc();
        OS.gtk_widget_destroy(n3);
        if (!bl) {
            return null;
        }
        return this.fontData;
    }

    public void setFontData(FontData fontData) {
        this.fontData = fontData;
    }

    public void setFontList(FontData[] fontDataArray) {
        this.fontData = fontDataArray != null && fontDataArray.length > 0 ? fontDataArray[0] : null;
    }

    public void setRGB(RGB rGB) {
        this.rgb = rGB;
    }
}

